/*
 * Utils.java
 *
 * Created on November 6, 2007, 2:55 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package Patristic;

import Patristic.tree.Node;
//import Patristic.tree.NodeI;
import Patristic.tree.Tree;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author mathieu
 */
public class Utils {
    
    /** Creates a new instance of Utils */
    public Utils() {
    }
     public static Tree createTree(String newick) throws Exception{
        Vector<Node> taxa=new Vector<Node>();
        if(!newick.endsWith(";")) newick+=";";
        String[] newickArray=stringToArray(newick);
        Stack<Node> stack = new Stack<Node>();
        boolean isBoot=false;
        
        Pattern p = Pattern.compile("^:(.+)\\[(.+)\\]$");
        Matcher m = p.matcher("");
        
        for(int i=0;i<newickArray.length;i++){
            if(newickArray[i].equals(";")) break;
            if(newickArray[i].equals("(")){
                Node node=new Node();
                
                if(!stack.empty()){
                    stack.peek().getChildren().addElement(node);
                    node.setParent(stack.peek());
                }
                stack.push(node);
                
                //System.out.print(names[namesID-1]);
                //print_stack(stack);
            } else if(newickArray[i].equals(")")){
                if(newickArray[i+1].equals(";")) break;
                // if there is a length branch
                if(newickArray[i+1].startsWith(":")){
                    // there is a bootstrap value  ex :0.01[95]
                    m.reset(newickArray[i+1]);
                    if(m.find()){
                        stack.peek().setBrlens(Double.valueOf(m.group(1)).doubleValue());
                        stack.peek().setBootstrap(Double.valueOf(m.group(2)).doubleValue());
                        isBoot=true;
                    } else
                        stack.peek().setBrlens(Double.valueOf(newickArray[i+1].substring(1)).doubleValue());
                    i++;
                }
                // does not start with a : but : is present => bootstrap value at the beginning ex 95:0.01
                else if(newickArray[i+1].contains(":")){
                    String[] temp=newickArray[i+1].split(":");
                    stack.peek().setBrlens(Double.valueOf(temp[1]).doubleValue());
                    stack.peek().setBootstrap(Double.valueOf(temp[0]).doubleValue());
                    i++;
                    isBoot=true;
                }
                stack.pop();
            } else if(newickArray[i].equals(",")){
                
            } else{
                String[] split=newickArray[i].split(":");
                Node node=new Node(split[0]);
                taxa.addElement(node);
                // There is no branch length
                if(split.length==1){
                    
                } else{
                    node.setBrlens(Double.valueOf(split[1]).doubleValue());
                }
                stack.peek().getChildren().addElement(node);
                node.setParent(stack.peek());
            }
        }
        Tree tree=new Tree(newick);
        tree.setTree(stack.pop());
        if(newick.contains(":")) tree.isBrlens=true;
        tree.isBootstrap = isBoot;
        tree.setTaxa(taxa);
        return tree;
    }
     
     private static String[] stringToArray(String str) throws Exception{
        Vector<String> arrayTemp=new Vector<String>();
        String wordTemp=""; //branch length or tip name
        int bracket=0;
        for(int i=0;i<str.length();i++){
            if(str.charAt(i) == ',' || str.charAt(i) == '(' || str.charAt(i) == ')' || str.charAt(i) == ';' ){
                //if( str.charAt(i)==':' || str.substring(i,i+1).compareTo(",")==0 || str.substring(i,i+1).compareTo("(")==0 || str.substring(i,i+1).compareTo(")")==0 || str.substring(i,i+1).compareTo(";")==0 ){
                if (wordTemp.compareTo("")!=0) arrayTemp.add(wordTemp);
                wordTemp="";
                arrayTemp.add(str.substring(i,i+1));
                if(str.charAt(i) == '(') bracket++;
                else if(str.charAt(i) == ')') bracket--;
            } else wordTemp+=str.substring(i,i+1);
        }
        if(bracket>0) throw new Exception("Newick tree malformated: more (");
        else if(bracket<0) throw new Exception("Newick tree malformated: more )");
        
        return (String[])arrayTemp.toArray(new String[arrayTemp.size()]);
    }
}
