/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.PlotCoord;
import Patristic.PlotList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.math.BigDecimal;
import javax.swing.JPanel;

public class Distribution
extends JPanel {
    private static final int XLEFT = 10;
    private static final int LINELENGTH = 280;
    private static final int WIDTHLINE = 2;
    private PlotList list;
    int valueX;
    int valueY;
    String infoEvent;
    BigDecimal max;
    BigDecimal min;
    int maxBeam = 0;
    int mean;
    int std;
    int length;
    int size = 0;

    public Distribution(PlotList list, int size) {
        this.list = list;
        this.size = size;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(Color.WHITE);
        g.setColor(Color.BLACK);
        g.setFont(new Font("Courier New", 1, 12));
        g.fillRect(10, 10, 2, 280);
        g.fillRect(10, 290, 280, 2);
        g.drawString("nb", 7, 6);
        g.drawString("beam", 294, 290);
        this.drawOneGraph(this.list, g);
    }

    private void drawOneGraph(PlotList list, Graphics g) {
        this.max = new BigDecimal("0");
        this.min = new BigDecimal("0");
        for (int i = 0; i < list.getNbPosition(); ++i) {
            BigDecimal val = ((PlotCoord)list.getList().elementAt(i)).getStatValue();
            if (val.compareTo(this.max) == 1) {
                this.max = val;
            }
            if (val.compareTo(this.min) != -1) continue;
            this.min = val;
        }
        String[][] array = this.toBeam();
        int width = 280 / this.length;
        for (int j = 1; j < this.length; ++j) {
            BigDecimal val = new BigDecimal(array[j][1]);
            BigDecimal lengthl = new BigDecimal(String.valueOf(280));
            val = val.multiply(lengthl);
            val = val.divide(new BigDecimal(String.valueOf(this.maxBeam + 5)), 1);
            int valI = val.intValue();
            g.fillRect(10 + (j - 1) * width, 400 - valI, width, valI);
        }
    }

    private String[][] toBeam() {
        int j;
        String str = "";
        BigDecimal i = new BigDecimal("0");
        BigDecimal step = new BigDecimal("0.01");
        int goaltemp = this.max.add(step).movePointRight(2).intValue();
        BigDecimal goal = new BigDecimal(String.valueOf(goaltemp)).movePointLeft(2);
        this.length = goal.multiply(new BigDecimal("100")).intValue();
        boolean l = false;
        String[][] array = new String[this.length + 3][2];
        for (j = 0; j < this.length + 2; ++j) {
            array[j][0] = String.valueOf(i);
            array[j][1] = "0";
            i = i.add(step);
        }
        for (j = 0; j < this.list.getNbPosition(); ++j) {
            int pos = 0;
            String strs = ((PlotCoord)this.list.getList().elementAt(j)).getStatValue().toString();
            BigDecimal dataDecAbs = new BigDecimal(strs).abs();
            while (dataDecAbs.compareTo(new BigDecimal(array[pos][0])) == 1 || dataDecAbs.compareTo(new BigDecimal(array[pos][0])) == 0) {
                ++pos;
            }
            array[pos][1] = String.valueOf(Integer.valueOf(array[pos][1]) + 1);
            if (Integer.valueOf(array[pos][1]) <= this.maxBeam) continue;
            this.maxBeam = Integer.valueOf(array[pos][1]);
        }
        return array;
    }
}

