/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.PlotModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class Option
extends JFrame {
    private PlotModel plotModel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton applyButton;
    private JLabel maxXLabel;
    private JLabel minXLabel;
    private JLabel unitXLabel;
    private JLabel maxYLabel;
    private JLabel minYLabel;
    private JLabel unitYLabel;
    private JTextField maxXTextField;
    private JTextField minXTextField;
    private JTextField unitXTextField;
    private JTextField maxYTextField;
    private JTextField minYTextField;
    private JTextField unitYTextField;
    private String maxX;
    private String minX;
    private String unitX;
    private String maxY;
    private String minY;
    private String unitY;
    private String dot;
    private String std;
    private String formula;
    private JPanel panelButton;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel dotPanel;
    private JLabel dotLabel;
    private JTextField dotTextField;
    private JTabbedPane jTabbedPane1;
    private JTextField formulaTextField;
    private JTextField stdTextField;
    private JLabel formulaLabel;
    private JLabel stdLabel;

    public Option(PlotModel optionObject) {
        this.plotModel = optionObject;
        this.init();
    }

    private void init() {
        this.setTitle("Options");
        this.panelButton = new JPanel();
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.applyButton = new JButton("Apply");
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.formulaLabel = new JLabel("Formula:");
        this.formulaTextField = new JTextField("(x-y)");
        this.stdLabel = new JLabel("Standard deviation:");
        this.stdTextField = new JTextField("3");
        this.maxXLabel = new JLabel("Max X");
        this.maxXTextField = new JTextField("-1");
        this.minXLabel = new JLabel("Min X");
        this.minXTextField = new JTextField("-1");
        this.unitXLabel = new JLabel("Unit X");
        this.unitXTextField = new JTextField("1");
        this.maxYLabel = new JLabel("Max Y");
        this.maxYTextField = new JTextField("-1");
        this.minYLabel = new JLabel("Min Y");
        this.minYTextField = new JTextField("-1");
        this.unitYLabel = new JLabel("Unit Y");
        this.unitYTextField = new JTextField("1");
        this.dotPanel = new JPanel();
        this.dotLabel = new JLabel("Dot size (pixel):");
        this.dotTextField = new JTextField(3);
        Container pane = this.getContentPane();
        this.maxXTextField.setText(this.plotModel.getMaxXGraph().toString());
        this.maxX = this.plotModel.getMaxXGraph().toString();
        this.minXTextField.setText(this.plotModel.getMinXGraph().toString());
        this.minX = this.plotModel.getMinXGraph().toString();
        this.unitXTextField.setText(this.plotModel.getXUnit().toString());
        this.unitX = this.plotModel.getXUnit().toString();
        this.maxYTextField.setText(this.plotModel.getMaxYGraph().toString());
        this.maxY = this.plotModel.getMaxYGraph().toString();
        this.minYTextField.setText(this.plotModel.getMinYGraph().toString());
        this.minY = this.plotModel.getMinYGraph().toString();
        this.unitYTextField.setText(this.plotModel.getYUnit().toString());
        this.unitY = this.plotModel.getYUnit().toString();
        this.formulaTextField.setText(this.plotModel.getFormula());
        this.formula = this.plotModel.getFormula();
        this.stdTextField.setText(this.plotModel.getStd());
        this.std = this.plotModel.getStd();
        this.dotTextField.setText(this.plotModel.getDotSize());
        this.dot = this.plotModel.getDotSize();
        this.setSize(250, 200);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Option.this.exitForm();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Option.this.plotModel.updateScaleX(new BigDecimal(Option.this.maxXTextField.getText()), new BigDecimal(Option.this.minXTextField.getText()), new BigDecimal(Option.this.unitXTextField.getText()));
                Option.this.plotModel.updateScaleY(new BigDecimal(Option.this.maxYTextField.getText()), new BigDecimal(Option.this.minYTextField.getText()), new BigDecimal(Option.this.unitYTextField.getText()));
                Option.this.plotModel.updateFormula(Option.this.formulaTextField.getText());
                Option.this.plotModel.updateSTD(Option.this.stdTextField.getText());
                try {
                    int nb = Integer.valueOf(Option.this.dotTextField.getText());
                    if (nb <= 0) {
                        throw new NumberFormatException();
                    }
                    Option.this.plotModel.updateProperties(Option.this.dotTextField.getText());
                    Option.this.plotModel.fireUpdated();
                    Option.this.exitForm();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Option.this.maxX.compareTo(Option.this.maxXTextField.getText()) != 0 || Option.this.minX.compareTo(Option.this.minXTextField.getText()) != 0 || Option.this.maxY.compareTo(Option.this.maxYTextField.getText()) != 0 || Option.this.minY.compareTo(Option.this.minYTextField.getText()) != 0 || Option.this.unitX.compareTo(Option.this.unitXTextField.getText()) != 0 || Option.this.unitY.compareTo(Option.this.unitYTextField.getText()) != 0) {
                    Option.this.plotModel.updateScaleX(new BigDecimal(Option.this.maxXTextField.getText()), new BigDecimal(Option.this.minXTextField.getText()), new BigDecimal(Option.this.unitXTextField.getText()));
                    Option.this.plotModel.updateScaleY(new BigDecimal(Option.this.maxYTextField.getText()), new BigDecimal(Option.this.minYTextField.getText()), new BigDecimal(Option.this.unitYTextField.getText()));
                }
                if (Option.this.formula.compareTo(Option.this.formulaTextField.getText()) != 0) {
                    Option.this.plotModel.updateFormula(Option.this.formulaTextField.getText());
                }
                if (Option.this.std.compareTo(Option.this.stdTextField.getText()) != 0) {
                    Option.this.plotModel.updateSTD(Option.this.stdTextField.getText());
                }
                if (Option.this.dot.compareTo(Option.this.dotTextField.getText()) != 0) {
                    Option.this.plotModel.updateProperties(Option.this.dotTextField.getText());
                }
                Option.this.plotModel.fireUpdated();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Option.this.exitForm();
            }
        });
        this.jTabbedPane1.addTab("Statistic", this.jPanel2);
        this.jPanel2.setLayout(new GridLayout(3, 2));
        this.jPanel2.add(this.formulaLabel);
        this.jPanel2.add(this.formulaTextField);
        this.jPanel2.add(this.stdLabel);
        this.jPanel2.add(this.stdTextField);
        this.jTabbedPane1.addTab("Scale", this.jPanel3);
        this.jPanel3.setLayout(new GridLayout(3, 4));
        this.jPanel3.add(this.maxXLabel);
        this.jPanel3.add(this.maxXTextField);
        this.jPanel3.add(this.maxYLabel);
        this.jPanel3.add(this.maxYTextField);
        this.jPanel3.add(this.minXLabel);
        this.jPanel3.add(this.minXTextField);
        this.jPanel3.add(this.minYLabel);
        this.jPanel3.add(this.minYTextField);
        this.jPanel3.add(this.unitXLabel);
        this.jPanel3.add(this.unitXTextField);
        this.jPanel3.add(this.unitYLabel);
        this.jPanel3.add(this.unitYTextField);
        this.jTabbedPane1.addTab("Properties", this.dotPanel);
        this.dotPanel.add(this.dotLabel);
        this.dotPanel.add(this.dotTextField);
        pane.add((Component)this.jTabbedPane1, "Center");
        this.panelButton.add(this.okButton);
        this.panelButton.add(this.cancelButton);
        this.panelButton.add(this.applyButton);
        pane.add((Component)this.panelButton, "South");
    }

    private void exitForm() {
        this.dispose();
    }
}

