/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class MarkerSizeSpecificationMode
extends CGMTag {
    public static final int ABSOLUTE = 0;
    public static final int SCALED = 1;
    public static final int FRACTIONAL = 2;
    public static final int MM = 3;
    private int mode;

    public MarkerSizeSpecificationMode() {
        super(2, 3, 1);
    }

    public MarkerSizeSpecificationMode(int mode) {
        this();
        this.mode = mode;
    }

    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.setMarkerSizeSpecificationMode(this.mode);
        cgm.writeEnumerate(this.mode);
    }

    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.setMarkerSizeSpecificationMode(this.mode);
        cgm.print("MARKERSIZEMODE ");
        switch (this.mode) {
            default: {
                cgm.print("ABS");
                break;
            }
            case 1: {
                cgm.print("SCALED");
                break;
            }
            case 2: {
                cgm.print("FRACTIONAL");
                break;
            }
            case 3: {
                cgm.print("METRIC");
            }
        }
    }
}

