/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *
 * @author  Fourment Mathieu
 */  
package Patristic;
   import javax.swing.*;
   import java.io.*;
   import java.math.BigDecimal;

/**
 * This class save the results in a text file
 */
public class Saver {
    
    protected Patristic frame;
    protected String pathname;
    protected BufferedWriter out;
    private File pathReturn;
    
    // save a dip-file 
    public Saver(String str, File path){
         pathname="";         
         JFileChooser sauveur =  new JFileChooser();
         sauveur.setCurrentDirectory(path);
         pathReturn=path;
         sauveur.addChoosableFileFilter(new FiltreExtension("csv", "CSV file"));
         int returnVal =  sauveur.showSaveDialog(frame);
         if (returnVal == JFileChooser.APPROVE_OPTION) {
             pathname=sauveur.getSelectedFile().toString()+".csv";
             pathReturn=sauveur.getCurrentDirectory();
             try{
                out = new BufferedWriter(new FileWriter(pathname));
                out.write(str);              
                out.close();
             }
             catch(IOException er){}
         }
    }
        
    // Return the path of that file
    public String getPathway(){
        return pathname;
    }
    
    public File getPathFileChooser(){
        return pathReturn;
    }
}
