/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package Patristic;


public class Tree {
    // Root node pointer. Will be null for an empty tree.
    private Node root;
    private Node currentNode=null;
    private Node newRoot=null;
    
    public static void main(String[] args) {
        new Tree();
    }
    
  /*
   --Node--
   The binary tree is built using this nested node class.
   Each node stores one data element, and has left and right
   sub-tree pointer which may be null.
   The node is a "dumb" nested class -- we just use it for
   storage; it does not have any methods.
   */
    private static class Node implements Cloneable {
        Node left;
        Node right;
        Node nodeParent;
        int data;
        String taxon1="";
        String taxon2="";
        String branchLength="";
        String branchLength2="";
        
        public Object clone() {
            try {
                return super.clone();
            }
            catch(CloneNotSupportedException e) {
                // we implement Cloneable, this exception will never be thrown
                return null;
            }
        }
        
        
        Node(int newData) {
            left = null;
            right = null;
            data = newData;
        }
        
        Node(Node parent){
            this("","",null,null,parent);
        }
        
        Node(String taxon, String branchLength) {
            this(taxon,branchLength,null,null,null);
        }
        
        Node(String taxon, String branchLength, Node node1, Node node2, Node nodeParent) {
            left = node1;
            right = node2;
            this.nodeParent=nodeParent;
            this.taxon1 = taxon;
            this.branchLength = branchLength;
        }
        
        public void addTaxon(String taxon) {
            this.taxon1=taxon;
        }
        public String[] getTaxon() {
            String[] list={this.taxon1,this.taxon2};
            return list;
        }
        public Node[] getKid() {
            Node[] list={this.left,this.right};
            return list;
        }
        
        public void setKid(Node kidNode) {
            if(left==null && right==null) left=kidNode;
            else if(right==null)right=kidNode;
            else System.out.println("left and right already full");
        }
        public void setTaxon(String tax) {
            if(taxon1.equals("")) taxon1=tax;
            else if(taxon2.equals(""))taxon2=tax;
            else System.out.println("left and right already full");
        }
        public Node getDaddy() {
            return this.nodeParent;
        }
        public void setDaddy(Node daddy) {
            this.nodeParent=daddy;
        }
        
        public void resetParentReference(Node daddy){
            if(left.equals(daddy)){System.out.println("daddy left "+left); left=null;}
            if(right.equals(daddy)){System.out.println("daddy right "+right); right=null;System.out.println("daddy right "+right);}
        }
        
        public void resetKid(){
            this.left=null;
            this.right=null;
        }
        
        public void setKid() {
            this.right=this.nodeParent;
            System.out.println("SETKID "+this.right);
//            if(this.left==null)left=this.nodeParent;
//            else right=this.nodeParent;
        }
    }
    
    /**
     * Creates an empty binary tree -- a null root pointer.
     */
    public  Tree() {
        root = null;
        String tree="(1,(2,(((3,5),(6,7)),4)))";
        int nbNode=0;
        Node dad=null;
        
        for(int i=0;i<tree.length();i++){
            String str=tree.substring(i,i+1);
            if(str.equals("(")){
                dad=currentNode;
                Node newNode=new Node(currentNode);
                if(root!=null){currentNode.setKid(newNode);System.out.println("kids pointet "+currentNode.getKid()[0]+" "+currentNode.getKid()[1]);}
                else root=newNode;
                currentNode=newNode;
                nbNode++;                
            }
            else if(str.equals(":")){
                
            }
            else if(str.equals(")")){
                currentNode=currentNode.getDaddy();
            }
            else if(str.equals(",")){
            }
            else {
                if(str.equals("2")) newRoot=currentNode;
                currentNode.setTaxon(str);
                System.out.println("TAXON "+str+" REFERENCE "+currentNode+" DADDY "+dad);
            }
            
        }
        System.out.println("number node "+nbNode);
        System.out.println("ROOT REFERENCE "+root);
        preOrder();
        reroot();
        System.out.println("NEW ROOT REFERENCE "+root);
        preOrder();
    }
    
    public void reroot(){
        Node dads=newRoot.getDaddy();
        System.out.println();
        System.out.println("new root "+newRoot);
        System.out.println("daddy "+dads);
        dads.resetKid();
        newRoot.setKid();
        root=newRoot;
        //newRoot.setDaddy(null);
        //newRoot.resetParentReference(newRoot.getDaddy());
    }
    
    private void preOrder(){
        preOrder(root);
    }
    
    private void preOrder(Node nody){
        if(nody!=null){
            System.out.print("(");
            String[] listTaxon=nody.getTaxon();
//            if(listTaxon[0].equals("") && listTaxon[1].equals("")){}
//            else if(!listTaxon[0].equals("") && listTaxon[1].equals("")){System.out.print(nody+",");}//System.out.print(listTaxon[0]+",");}
//            else if(listTaxon[0].equals("") && !listTaxon[1].equals("")){System.out.print(nody);}//System.out.print(listTaxon[1]);}
//            else {System.out.print(nody+","+nody);} //{System.out.print(listTaxon[0]+","+listTaxon[1]);}
            
            
//            if(listTaxon[0].equals("") && listTaxon[1].equals("")){}
//            else if(!listTaxon[0].equals("") && listTaxon[1].equals("")){System.out.print(listTaxon[0]+",");}
//            else if(listTaxon[0].equals("") && !listTaxon[1].equals("")){System.out.print(listTaxon[1]);}
//            else {System.out.print(listTaxon[0]+","+listTaxon[1]);}
            
            //            for(int i=0;i<listTaxon.length;i++)
            //                if(!listTaxon[i].equals("")){
            //                    if(i==0)System.out.print(listTaxon[i]+",");
            //                    else System.out.print(listTaxon[i]);
            //                }
            System.out.print(nody.getTaxon()[0]+","+nody.getTaxon()[1]+" ");
            //System.out.println("\n"+nody);
            //System.out.println("left");
            preOrder(nody.right);
            System.out.print(",");
            preOrder(nody.left);
            System.out.print(")");
        }
        //else System.out.println("NULL");
    }
    
    
    /**
     * Returns true if the given target is in the binary tree.
     * Uses a recursive helper.
     */
    public boolean lookup(int data) {
        return(lookup(root, data));
    }
    
    
    /**
     * Recursive lookup  -- given a node, recur
     * down searching for the given data.
     */
    private boolean lookup(Node node, int data) {
        if (node==null) {
            return(false);
        }
        
        if (data==node.data) {
            return(true);
        }
        else if (data<node.data) {
            return(lookup(node.left, data));
        }
        else {
            return(lookup(node.right, data));
        }
    }
    
    
    /**
     * Inserts the given data into the binary tree.
     * Uses a recursive helper.
     */
    public void insert(int data) {
        root = insert(root, data);
    }
    
    
    /**
     * Recursive insert -- given a node pointer, recur down and
     * insert the given data into the tree. Returns the new
     * node pointer (the standard way to communicate
     * a changed pointer back to the caller).
     */
    private Node insert(Node node, int data) {
        if (node==null) {
            node = new Node(data);
        }
        else {
            if (data <= node.data) {
                node.left = insert(node.left, data);
            }
            else {
                node.right = insert(node.right, data);
            }
        }
        
        return(node); // in any case, return the new pointer to the caller
    }
    
}
