Program pcalc;

uses crt;

Var
cr: real; { concentracao do primer em ug/uL}
vr: real; { volume da reacao em ul}
vpip: real; {volume de pipetagem da solucao de uso na reacao}
vu: real; {volume da solucao de uso, em ul}
ce: real; {concentracao do estoque, em ug/ul}
vep: real; {volume do estoque que se deve pipetar para produzir a sol de uso}
cu: real; { concentracao da solucao de uso, em ug/ul}
vh2ou: real; { volume de agua que se deve adicionar para formar a solucao de uso}
pmp:real; {peso molecular do primer}
cc1:char; {codigo da unidade de massa da quantidade de primer no estoque}
mpex : real; {massa de primer no tubo estoque , em unidade definida pelo usuario}
cc2: char ; {cdigo da concentracao de primer na reacao}
crx: real; {concentracao da reacao, em unidade definida pelo usurio}
cc3: char; {cdigo da concentracao da solucao estoque}
cex: real; {concentracao da solucao estoque , em unidade definida pelo usurio}
mpe: real; {massa de primer no estoque, em ug}
opcao: char; {codigo de escolha da tarefa}

{bloco das declaracoes forward}

  Procedure pisoluso ; Forward;
  Procedure Seqprimer; Forward;
  Procedure encerrar; Forward;
  procedure converte; Forward;
  procedure entrada; Forward;
  procedure odconv; Forward;
  procedure calcta; Forward;
  procedure calcmw; Forward;
  procedure creditos; Forward;




{**************************bloco das procedures****************************}

 Procedure Global;

Begin

ClrScr;


Writeln ('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>ENTRADA DE DADOS<<<<<<<<<<<<<<<<<<<<<<<<<<<');

Writeln ('');
write ('Digite o peso molecular do primer --> ');
readln (pmp);
Write ('Digite o volume da reao [valor em microlitros] --> ');
readln (vr);
writeln('');
Writeln ('*********ENTRADA DE DADOS DA MASSA DE PRIMER CONTIDA NO TUBO ESTOQUE*********');
writeln ('');
Writeln ('Escolha a unidade de massa');
Writeln ('[1]Molar, [2]uMolar, [3]nMolar, [4]pMolar, [5]ug, [6]ng, [7]pg ');
Write ('Digite o cdigo da unidade de massa --> ');
readln  (cc1);
Write ('Digite o valor da massa de primer no tubo estoque --> ');
readln (mpex);
writeln ('');
Writeln ('************ENTRADA DE DADOS DA CONCENTRAO DE PRIMER NA REAO*************');
writeln ('');
writeln ('Escolha a unidade de concentrao');
Writeln ('[1]Moles, [2]uMoles, [3]nMoles, [4]pMoles, [5]ug/uL, [6]ng/uL, [7]pg/uL ');
write ('Digite o cdigo da concentrao escolhida --> ');
readln (cc2);
write ('Digite o valor da concentrao de primer na reao --> ');
readln (crx);
writeln ('');
write ('Digite o volume da soluo de uso que voc deseja pipetar na reao [em uL] -> ');
readln (vpip);
writeln('');
write ('Digite o volume de soluo de uso que voc deseja estocar [em uL] --> ');
readln (vu);
writeln ('');
writeln ('**************ENTRADA DE DADOS DA CONCENTRAO DA SOLUO ESTOQUE*************');
writeln ('');
writeln ('Escolha a unidade de concentrao');
Writeln ('[1]Moles, [2]uMoles, [3]nMoles, [4]pMoles, [5]ug/uL, [6]ng/uL, [7]pg/uL ');
write ('Digite o cdigo da concentrao escolhida --> ');
readln (cc3);
write ('Digite o valor da concentrao que voc deseja na soluo estoque --> ');
readln (cex);
writeln ('');
writeln ('*****************************************************************************');
writeln ('******************************FIM DA ENTRADA DE DADOS************************');
writeln ('*****************************************************************************');
writeln ('Pressione enter para iniciar o processamento...');
readln;
{fim da entrada de dados}

{inicio da secao de processamento de dados}

{inicio da secao de conversao da massa de primer dada pelo usurio para ug}

case (cc1) of

  '1': mpe := (pmp * 1000000 * mpex);  {converte M em ug}
  '2': mpe := (pmp * mpex);  {converte uM em ug}
  '3': mpe := (pmp * mpex * 0.001);  {converte nM em ug}
  '4': mpe := (pmp * mpex * 0.000001)  ;  {converte pM em ug}
  '5': mpe := mpex;                    {converte ug em ug}
  '6': mpe := mpex/1000;               {converte ng em ug}
  '7': mpe := mpex/1000000;            {converte pg em ug}
  end;

{massa do primer no tubo estoque j foi passada para ug}

{inicio da secao de conversao da concentracao de primer na reacao}

case (cc2) of

  '1': cr  := (pmp * 1000000 * crx)     ; {converte M em ug/uL  }
  '2': cr  := (pmp * crx) ; {converte uM em ug/uLg  }
  '3': cr  := (pmp * crx * 0.001); {converte nM em ug/uLg  }
  '4': cr  :=(pmp * crx * 0.000001); {converte pM em ug/uLg  }
  '5': cr  := crx     ; {converte ug/ul em ug/uL  }
  '6': cr  := crx/1000 ; {converte ng em ug/uL  }
  '7': cr  := crx/1000000 ; {converte pg em ug/uL  }
  end;

{fim da secao de conversao da concentracao de primer na reacao}

{inicio da secao de conversao da concentracao da solucao estoque}

case (cc3) of

  '1': ce  := (pmp * 1000000 * cex) ; {converte M em ug/uL  }
  '2': ce  := (pmp * cex) ; {converte uM em ug/uLg  }
  '3': ce  := (pmp * cex * 0.001); {converte nM em ug/uLg  }
  '4': ce  := (pmp * cex * 0.000001) ; {converte pM em ug/uLg  }
  '5': ce  := cex     ; {converte ug/ul em ug/uL  }
  '6': ce  := cex/1000 ; {converte ng em ug/uL  }
  '7': ce  := cex/1000000 ; {converte pg em ug/uL  }
  end;

{fim da secao de conversao da concentracao da solucao estoque}

{inicio da secao de calculo da diluicao dos primers}

cu:=(cr*vr)/vpip;
vep:=(cu*vu)/ce;
vh2ou:=vu-vep;

{fim da secao de clculo da diluicao dos primers}

{inicio da secao de saida dos dados}

textcolor (1);
textbackground (1);

Clrscr;

textcolor (green);
textbackground (black);

WriteLn ('////////////////////////////////////////////////////////////////////////////');
Writeln ('*******************************SAIDA DOS DADOS******************************');
Writeln ('\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\');
writeln ('                                                                            ');

WriteLn ('Volume de H2O,(em uL),a ser pipetado no tubo estoque -> ', mpe/ce);
WriteLn ('Volume da sol. estoque pipetado para formar a sol. de uso -> ', vep   );
Writeln ('Volume de H2O,(em uL),a ser pipetado para formar a sol. de uso -> ', vu -vep);

{os algoritmos abaixo convertem ug/uL em diferentes concentraes}
writeln ('                                                                            ');
writeln (')))))))))))))))))))))) CONCENTRAO DO PRIMER NA REAO ((((((((((((((((((((');
writeln ('                                                                            ');
writeln ('Concentrao 1 --> ', cr/(pmp*1000000) ,' Moles/uL                                ');
writeln ('Concentrao 2 --> ', cr/pmp ,' uMoles/uL                     ');
writeln ('Concentrao 3 --> ', (cr*1000)/pmp ,' nMoles/uL                  ');
writeln ('Concentrao 4 --> ', (cr*1000000 )/pmp ,' pMoles/uL             ');
writeln ('Concentrao 5 --> ', cr ,' ug/uL                                           ');
writeln ('Concentrao 6 --> ', cr * 1000 ,' ng/uL                                    ');
writeln ('Concentrao 7 --> ', cr * 1000000 ,' pg/uL                                 ');
writeln ('                                                                            ');
writeln ('                                                                            ');
writeln ('Pressione enter para continuar                                              ');
readln;
ClrScr;
writeln (')))))))))))))))))))))) CONCENTRAO DA SOLUO ESTOQUE (((((((((((((((((((((');
writeln ('');
writeln ('Concentrao 1 --> ', ce/(pmp*1000000) ,' Moles/uL                                ');
writeln ('Concentrao 2 --> ', ce/pmp ,' uMoles/uL                     ');
writeln ('Concentrao 3 --> ', (ce * 1000)/pmp ,' nMoles/uL                  ');
writeln ('Concentrao 4 --> ', (ce * 1000000)/pmp ,' pMoles/uL             ');
writeln ('Concentrao 5 --> ', ce ,' ug/uL                                           ');
writeln ('Concentrao 6 --> ', ce * 1000 ,' ng/uL                                    ');
writeln ('Concentrao 7 --> ', ce * 1000000 ,' pg/uL                                 ');
writeln ('');
writeln (')))))))))))))))))))))) CONCENTRAO DA SOLUO DE USO ((((((((((((((((((((((');
writeln ('');
writeln ('Concentrao 1 --> ', cu/(pmp*1000000) ,' Moles/uL                                ');
writeln ('Concentrao 2 --> ', cu/pmp ,' uMoles/uL                     ');
writeln ('Concentrao 3 --> ', (cu * 1000)/pmp ,' nMoles/uL                  ');
writeln ('Concentrao 4 --> ', (cu * 1000000)/pmp ,' pMoles/uL             ');
writeln ('Concentrao 5 --> ', cu ,' ug/uL                                           ');
writeln ('Concentrao 6 --> ', cu * 1000 ,' ng/uL                                    ');
writeln ('Concentrao 7 --> ', cu * 1000000 ,' pg/uL                                 ');
writeln ('');
write ('Pressione Enter');
readln;

textcolor (1);
textbackground (1);

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}

Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;



readln;

End;









Procedure encerrar;

Begin
textcolor (black);
textbackground (red);

Clrscr;
writeln ('######################LABDROS - LABORATRIO DE BIOLOGIA MOLECULAR############');
writeln('');
writeln('#########################UNIVERSIDADE FEDERAL DE SANTA MARIA##################');
writeln ('*****************************************************************************');
writeln ('*****************************************************************************');
writeln ('*****************************************************************************');
writeln ('*****************************************************************************');
writeln ('**************************PCALC  - ENCERRADO*********************************');
writeln ('*****************************************************************************');
writeln ('*****************************************************************************');
writeln ('*****************************************************************************');
writeln ('Envie seus comentrios para : operon@www.ufsm.br');

end;



Procedure Seqprimer;

Var
cdna : array [1..1000] of char;
origin : array [1..1000] of char;
cont : integer;
num :integer;
resp : string;
bases : integer;
id : integer;
opcao: char;

Begin
ClrScr;
cont := 1;
bases := 0;
num :=1;
id := 0;

Writeln ('(((((((((((((((CLCULO DA SEQUNCIA COMPLEMENTAR DO PRIMER))))))))))))))))))))))');
writeln (' ');
writeln ('Digite a sequencia de nucleotdeos . Para encerrar a entrada de dados digite x (pressione enter...)');
readln;

  while cont < 1000  do
  Begin
   writeln ('Digite o ', cont, ' nucleotdeo');
   readln (origin [cont]);
    if (origin [cont]) = 'x' then
     begin
      cont := 999;
      end;
   bases:= bases + 1;
   cont := cont + 1;
  end;

bases := bases - 1;

writeln ('total de nucleotdeos  ', bases );
readln;
clrscr;

WriteLn ('Lista para confirmao de digitao. (pressione enter)');
readln;
clrscr;

writeln ('Listando...(pressione enter)');
readln;
 repeat
   begin
    id := id + 1;
    write ('nucleotdeo nmero ', id);
    write ('  ');
    write ( origin[id]);
    readln;
   end;
 Until (id = bases);


readln;

writeln ('fim da listagem');
writeln ('Inicar processamento?(s/n)');
readln (resp);
if resp = 's' then
 begin
  writeln (' Iniciar processamento. (pressione enter)');

  readln;
  writeln ('listando cadeia complementar...');
  Repeat
  begin
  case origin[num] of
   'a': write ('t');
   't': write ('a');
   'g': write ('c');
   'c': write ('g');
   end;
   num := num + 1;
   end;
  Until ( num - 1  = bases);

Writeln ('');
writeln ('');
Writeln ('Pressione Enter');
readln;

Clrscr;

textcolor (1);
textbackground (1);

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}
Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;

end;
readln;
end;

{ inicio da procedure para calculo do volume  a ser pipetado de solucao de uso.}

Procedure op1;

Var
op: char; {codigo da opcao de calculo}
c1: char; { codigo da opcao para unidade da [] de primer na reacao}
cry: real; {[] do primer na reaco em unidade definida pelo usurio}
crk: real; {concentracao do primer na reacao, em uL}
c2: char;{ codigo da opcao para unidade da [] da solucao de uso}
cuy: real; {[] da solucao de uso em unidade definida pelo usurio}
cuk: real; {[] da solucao de uso em uL}
vrk: real; {volume da reacao em uL}
vuk: real; {volume da solucao de uso desejada}
c3: char; {codigo da opcao para unidade de [] da solucao estoque}
cek: real; {[] da solucao de uso em unidade definida pelo usuario}
cey:real; {[] da solucao estoque em uL}
pmpy: real; {peso molecular do primer}

Begin

 writeln ('              ----------ENTRADA DE DADOS----------');
       writeln ('');
       writeln ('');
       write ('Digite o peso molecular do primer -->');
       readln (pmpy);
       writeln ('');
       writeln ('');
       write ('Digite o volume da reao (em uL) --> ');
       readln (vrk);
       writeln ('');
       writeln ('');
       Writeln ('************ENTRADA DE DADOS DA CONCENTRAO DE PRIMER NA REAO*************');
       writeln ('');
       writeln ('Escolha a unidade de concentrao');
       Writeln ('[1]Moles, [2]uMoles, [3]nMoles, [4]pMoles, [5]ug/uL, [6]ng/uL, [7]pg/uL ');
       write ('Digite o cdigo da concentrao escolhida --> ');
       readln (c1);
       write ('Digite o valor da concentrao de primer na reao --> ');
       readln (cry);
       writeln ('');
       Writeln ('************ENTRADA DE DADOS DA CONCENTRAO DA SOLUCAO DE USO*************');
       writeln ('');
       writeln ('Escolha a unidade de concentrao');
       Writeln ('[1]Moles, [2]uMoles, [3]nMoles, [4]pMoles, [5]ug/uL, [6]ng/uL, [7]pg/uL ');
       write ('Digite o cdigo da concentrao escolhida --> ');
       readln (c2);
       write ('Digite o valor da concentrao de primer na reao --> ');
       readln (cuy);
       writeln ('');
       writeln ('');

       { inicio do processamento}

       {transformacao dos valores

       {inicio da secao de conversao da concentracao de primer na reacao}

       case (c1) of

         '1': crk  := (pmpy * 1000000 * cry)     ; {converte M em ug/uL  }
         '2': crk  := (pmpy * cry) ; {converte uM em ug/uLg  }
         '3': crk  := (pmpy * cry * 0.001); {converte nM em ug/uLg  }
         '4': crk  :=(pmpy * cry * 0.000001); {converte pM em ug/uLg  }
         '5': crk  := cry     ; {converte ug/ul em ug/uL  }
         '6': crk  := cry/1000 ; {converte ng em ug/uL  }
         '7': crk  := cry/1000000 ; {converte pg em ug/uL  }
       end;

       {fim da secao de conversao da concentracao de primer na reacao}

       {inicio da secao de conversao da concentracao da solucao de uso}

       case (c2) of

         '1': cuk  := (pmpy * 1000000 * cuy)     ; {converte M em ug/uL  }
         '2': cuk  := (pmpy * cuy) ; {converte uM em ug/uLg  }
         '3': cuk  := (pmpy * cuy * 0.001); {converte nM em ug/uLg  }
         '4': cuk  :=(pmpy * cuy * 0.000001); {converte pM em ug/uLg  }
         '5': cuk  := cuy     ; {converte ug/ul em ug/uL  }
         '6': cuk  := cuy/1000 ; {converte ng em ug/uL  }
         '7': cuk  := cuy/1000000 ; {converte pg em ug/uL  }
       end;

       {fim da secao de conversao da concentracao de primer na reacao}

       {saida e calculo do volume a ser pipetado}

       writeln ('O volume de soluo de uso a ser pipetado  -->',(crk*vrk)/cuk );

       writeln ('Pressione Enter');
       readln;

       textcolor (1);
       textbackground (1);

       Clrscr;

       textcolor (yellow);
       textbackground (blue);

        {inicio das secao de escolha da tarefa}
     Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;





end;

Procedure creditos;

Begin

clrscr;

textcolor (white);
textbackground (blue);

Writeln('');
writeln('LABDROS - LABORATRIO DE BIOLOGIA MOLECULAR');
writeln('UNIVERSIDADE FEDERAL DE SANTA MARIA');
writeln('#############################################################################');
writeln('PCALC - VERSO 0.1');
writeln('');
writeln('DESENVOLVIDO POR MARCOS OLIVEIRA DE CARVALHO');
writeln('BOLSISTA PIBIC/CNPQ - LABDROS - LABORATRIO DE BIOLOGIA MOLECULAR');
writeln('GRADUANDO DO CURSO DE AGRONOMIA');
writeln('GRADUANDO DO CURSO DE FARMCIA E BIOQUMICA');
Writeln('Universidade Federal de Santa Maria');
Writeln('WEBMASTER DO SITE OPERON - HTTP://WWW.UFSM.BR/OPERON');
writeln('#############################################################################');
Writeln('Ultima compilao em 9/02/2000 s 02:26 hs');
writeln('#############################################################################');
Writeln('Para entrar em contato:');
writeln('Labdros - Laboratrio de Biologia Molecular');
writeln('Universidade Federal de Santa Maria - Santa Maria - Rio Grande do Sul - Brasil');
writeln('Centro de Cincias Naturais e Exatas - Departamento de Biologia');
writeln('Tel: +55 220 8912');
writeln('e-mail: operon@www.ufsm.br');
writeln('#############################################################################');
writeln('Agradecimentos:  Professor Elgion Loreto - LabDros');
writeln('                 Professora Lenira Sepel - LabDors');
writeln('#############################################################################');
Write ('Pressione Enter');
readln;

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}
Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;
end;






Procedure op2;

Var

op: char; {codigo da opcao de calculo}
c1: char; { codigo da opcao para unidade da [] de primer na reacao}
cry: real; {[] do primer na reaco em unidade definida pelo usurio}
crk: real; {concentracao do primer na reacao, em uL}
c2: char;{ codigo da opcao para unidade da [] da solucao de uso}
cuy: real; {[] da solucao de uso em unidade definida pelo usurio}
cuk: real; {[] da solucao de uso em uL}
vrk: real; {volume da reacao em uL}
vuk: real; {volume da solucao de uso desejada}
c3: char; {codigo da opcao para unidade de [] da solucao estoque}
cek: real; {[] da solucao de uso em unidade definida pelo usuario}
cey:real; {[] da solucao estoque em uL}
pmpy: real; {peso molecular do primer}

Begin


 Clrscr;
        Writeln ('              ----------ENTRADA DE DADOS-----------');
        writeln ('');
        writeln ('');
        write ('Digite o peso molecular do primer -->');
        readln (pmpy);
        writeln ('');
        writeln ('');
        write ('Digite o volume da reao (em uL) --> ');
        readln (vrk);
        writeln ('');
        write ('Digite o volume de soluo de uso desejado (em uL) --> ');
        readln (vuk);
        writeln ('');
        writeln ('');
        Writeln ('************ENTRADA DE DADOS DA CONCENTRAO DE PRIMER NA REAO*************');
        writeln ('');
        writeln ('Escolha a unidade de concentrao');
        Writeln ('[1]Moles, [2]uMoles, [3]nMoles, [4]pMoles, [5]ug/uL, [6]ng/uL, [7]pg/uL ');
        write ('Digite o cdigo da concentrao escolhida --> ');
        readln (c1);
        write ('Digite o valor da concentrao de primer na reao --> ');
        readln (cry);
        ClrScr;
        writeln ('');
        Writeln ('************ENTRADA DE DADOS DA CONCENTRAO DA SOLUCAO DE USO*************');
        writeln ('');
        writeln ('Escolha a unidade de concentrao');
        Writeln ('[1]Moles, [2]uMoles, [3]nMoles, [4]pMoles, [5]ug/uL, [6]ng/uL, [7]pg/uL ');
        write ('Digite o cdigo da concentrao escolhida --> ');
        readln (c2);
        write ('Digite o valor da concentrao de primer na reao --> ');
        readln (cuy);
        writeln ('');
        writeln ('**************ENTRADA DE DADOS DA CONCENTRAO DA SOLUO ESTOQUE*************');
        writeln ('');
        writeln ('Escolha a unidade de concentrao');
        Writeln ('[1]Moles, [2]uMoles, [3]nMoles, [4]pMoles, [5]ug/uL, [6]ng/uL, [7]pg/uL ');
        write ('Digite o cdigo da concentrao escolhida --> ');
        readln (c3);
        write ('Digite o valor da concentrao que voc deseja na soluo estoque --> ');
        readln (cey);
        writeln ('');

        { inicio do processamento}

        {transformacao dos valores

        {inicio da secao de conversao da concentracao de primer na reacao}

        case (c1) of

          '1': crk  := (pmpy * 1000000 * cry)     ; {converte M em ug/uL  }
          '2': crk  := (pmpy * cry) ; {converte uM em ug/uLg  }
          '3': crk  := (pmpy * cry * 0.001); {converte nM em ug/uLg  }
          '4': crk  :=(pmpy * cry * 0.000001); {converte pM em ug/uLg  }
          '5': crk  := cry     ; {converte ug/ul em ug/uL  }
          '6': crk  := cry/1000 ; {converte ng em ug/uL  }
          '7': crk  := cry/1000000 ; {converte pg em ug/uL  }
        end;

        {fim da secao de conversao da concentracao de primer na reacao}

        {inicio da secao de conversao da concentracao da solucao de uso}

        case (c2) of

          '1': cuk  := (pmpy * 1000000 * cuy)     ; {converte M em ug/uL  }
          '2': cuk  := (pmpy * cuy) ; {converte uM em ug/uLg  }
          '3': cuk  := (pmpy * cuy * 0.001); {converte nM em ug/uLg  }
          '4': cuk  :=(pmpy * cuy * 0.000001); {converte pM em ug/uLg  }
          '5': cuk  := cuy     ; {converte ug/ul em ug/uL  }
          '6': cuk  := cuy/1000 ; {converte ng em ug/uL  }
          '7': cuk  := cuy/1000000 ; {converte pg em ug/uL  }
        end;

        {fim da secao de conversao da concentracao de primer na reacao}

        {inicio da secao de conversao da concentracao da solucao estoque}

        case (cc3) of

        '1': cek  := (pmpy * 1000000 * cey) ; {converte M em ug/uL  }
        '2': cek  := (pmpy * cey) ; {converte uM em ug/uLg  }
        '3': cek  := (pmpy * cey * 0.001); {converte nM em ug/uLg  }
        '4': cek  := (pmpy * cey * 0.000001) ; {converte pM em ug/uLg  }
        '5': cek  := cey     ; {converte ug/ul em ug/uL  }
        '6': cek  := cey/1000 ; {converte ng em ug/uL  }
        '7': cek  := cey/1000000 ; {converte pg em ug/uL  }
        end;

        {fim da secao de conversao da concentracao da solucao estoque}


        {saida e calculo do volume a ser pipetado}
        writeln ('                        ---------SADA DOS DADOS----------');
        writeln ('O volume de soluo de uso a ser pipetado  -->',(crk*vrk)/cuk );
        writeln ('');
        writeln ('O volume de sol. estoque necessria para formar a sol. de uso  --> ', (cuk*vuk)/cek );
        writeln ('O volume de H2O que deve ser adicionado ao estoque pipetado  --> ', vuk - (cuk*vuk)/cek );
        writeln ('');
        writeln ('Pressione Enter');
        readln;

        {os algoritmos abaixo convertem ug/uL em diferentes concentraes}
        writeln ('                                                                            ');
        writeln (')))))))))))))))))))))) CONCENTRAO DO PRIMER NA REAO ((((((((((((((((((((');
        writeln ('                                                                            ');
        writeln ('Concentrao 1 --> ', crk/(pmpy*1000000)  ,' Moles/uL                                ');
        writeln ('Concentrao 2 --> ', crk/pmpy ,' uMoles/uL                     ');
        writeln ('Concentrao 3 --> ', (crk * 1000)/pmpy ,' nMoles/uL                  ');
        writeln ('Concentrao 4 --> ', (crk * 1000000)/pmpy ,' pMoles/uL             ');
        writeln ('Concentrao 5 --> ', crk ,' ug/uL                                           ');
        writeln ('Concentrao 6 --> ', crk * 1000 ,' ng/uL                                    ');
        writeln ('Concentrao 7 --> ', crk * 1000000 ,' pg/uL                                 ');
        writeln ('                                                                            ');
        writeln ('                                                                            ');
        writeln ('Pressione enter para continuar                                              ');
        readln;
        ClrScr;
        writeln (')))))))))))))))))))))) CONCENTRAO DA SOLUO ESTOQUE (((((((((((((((((((((');
        writeln ('');
        writeln ('Concentrao 1 --> ', cek/(pmpy*1000000) ,' Moles/uL                                ');
        writeln ('Concentrao 2 --> ', cek/pmpy ,' uMoles/uL                     ');
        writeln ('Concentrao 3 --> ', (cek * 1000)/pmpy,' nMoles/uL                  ');
        writeln ('Concentrao 4 --> ', (cek * 1000000)/pmpy ,' pMoles/uL             ');
        writeln ('Concentrao 5 --> ', cek ,' ug/uL                                           ');
        writeln ('Concentrao 6 --> ', cek * 1000 ,' ng/uL                                    ');
        writeln ('Concentrao 7 --> ', cek * 1000000 ,' pg/uL                                 ');
        writeln ('');
        writeln (')))))))))))))))))))))) CONCENTRAO DA SOLUO DE USO ((((((((((((((((((((((');
        writeln ('');
        writeln ('Concentrao 1 --> ', cuk/(pmpy*1000000) ,' Moles/uL                                ');
        writeln ('Concentrao 2 --> ', cuk /pmpy ,' uMoles/uL                     ');
        writeln ('Concentrao 3 --> ', (cuk * 1000)/pmpy ,' nMoles/uL                  ');
        writeln ('Concentrao 4 --> ', (cuk * 1000000)/pmpy ,' pMoles/uL             ');
        writeln ('Concentrao 5 --> ', cuk ,' ug/uL                                           ');
        writeln ('Concentrao 6 --> ', cuk * 1000 ,' ng/uL                                    ');
        writeln ('Concentrao 7 --> ', cuk * 1000000 ,' pg/uL                                 ');
        writeln ('');

        textcolor (1);
        textbackground (1);

        Clrscr;

        textcolor (yellow);
        textbackground (blue);

         {inicio das secao de escolha da tarefa}
       Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;


end;

Procedure con1;

Var
pm: real; {peso molecular}
cm: char; {codigo da escolha de unidade de massa}
mx: real; {massa em unidade do usurio}
m : real; {massa em ug}


Begin



ClrScr;

Writeln('');
Writeln('');
Writeln('');
Writeln('::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::');
Writeln(':::::::::::::::::::::CLCULO DE CONVERSO DE UNIDADE DE MASSA:::::::::::::::::');
Writeln('::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::');
writeln ('');
writeln ('');
write ('Digite o peso molecular --> ');
readln(pm);
writeln('');
Writeln ('*************************ENTRADA DE DADOS DA MASSA **************************');
writeln ('');
Writeln ('Escolha a unidade de massa');
Writeln ('[1]Molar, [2]uMolar, [3]nMolar, [4]pMolar, [5]ug, [6]ng, [7]pg ');
Write ('Digite o cdigo da unidade de massa --> ');
readln  (cm);
Write ('Digite o valor da massa  --> ');
readln (mx);
writeln ('');
{ iniciar processamento}
{inicio da secao de conversao da massa de primer dada pelo usurio para ug}

case (cm) of

  '1': m := (pm * 1000000 * mx);  {converte M em ug}
  '2': m := (pm * mx);  {converte uM em ug}
  '3': m := (pm * mx * 0.001);  {converte nM em ug}
  '4': m := (pm * mx * 0.000001)  ;  {converte pM em ug}
  '5': m := mx;                    {converte ug em ug}
  '6': m := mx/1000;               {converte ng em ug}
  '7': m := mx/1000000;            {converte pg em ug}
  end;

{massa do primer no tubo estoque j foi passada para ug
{saida dos dados}
writeln ('                                                                            ');
writeln (')))))))))))))))))))))) UNIDADES DE MASSA CONVERTIDAS ((((((((((((((((((((');
writeln ('                                                                            ');
writeln ('Massa 1 --> ', m/(pm*1000000) ,' Moles                            ');
writeln ('Massa 2 --> ', m /pm ,' uMoles                     ');
writeln ('Massa 3 --> ', (m * 1000)/pm ,' nMoles                  ');
writeln ('Massa 4 --> ', (m * 1000000)/pm ,' pMoles             ');
writeln ('Massa 5 --> ', m ,' ug                                          ');
writeln ('Massa 6 --> ', m * 1000 ,' ng                                   ');
writeln ('Massa 7 --> ', m * 1000000 ,' pg                                ');
writeln ('                                                                ');
writeln ('                                                                            ');
writeln ('Pressione Enter');
readln;
textcolor (1);
textbackground (1);

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}
Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;



end;

Procedure con2;

Var
pm: real; {peso molecular}
cc: char; {codigo da escolha de unidade de []}
ccx: real; {[] em unidade do usurio}
cccx : real; {massa em ug}


Begin



ClrScr;

Writeln('');
Writeln('');
Writeln('');
Writeln('::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::');
Writeln(':::::::::::::::::::::CLCULO DE CONVERSO DE CONCENTRAO:::::::::::::::::::::');
Writeln('::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::');
writeln ('');
writeln ('');
write ('Digite o peso molecular --> ');
readln(pm);
writeln('');
Writeln ('*************************ENTRADA DE DADOS DA CONCENTRAO *******************');
writeln ('');
Writeln ('Escolha a unidade de massa');
Writeln ('[1]Molar/uL, [2]uMolar/uL, [3]nMolar/uL, [4]pMolar/uL, [5]ug/uL, [6]ng/uL, [7]pg/ul ');
Write ('Digite o cdigo da unidade de concentrao --> ');
readln  (cc);
Write ('Digite o valor da concentrao a converter  --> ');
readln (ccx);
writeln ('');
{ iniciar processamento}
{inicio da secao de conversao da concentracao dada pelo usurio para ug/uL}

case (cc) of

  '1': cccx  := (pm * 1000000 * ccx)     ; {converte M em ug/uL  }
  '2': cccx  := (pm * ccx) ; {converte uM em ug/uLg  }
  '3': cccx  := (pm * ccx * 0.001); {converte nM em ug/uLg  }
  '4': cccx  := (pm * ccx * 0.000001); {converte pM em ug/uLg  }
  '5': cccx  := ccx     ; {converte ug/ul em ug/uL  }
  '6': cccx  := ccx/1000 ; {converte ng em ug/uL  }
  '7': cccx  := ccx/1000000 ; {converte pg em ug/uL  }
  end;

{fim da secao de conversao da concentracao }

{saida dos dados da convercao de concentracao}
{os algoritmos abaixo convertem ug/uL em diferentes concentraes}
writeln ('                                                                            ');
writeln ('))))))))))))))))))))))))))) CONCENTRAO CONVERTIDA ((((((((((((((((((((((((');
writeln ('                                                                            ');
writeln ('Concentrao 1 --> ', cccx/(pm*1000000) ,' Moles/uL                                ');
writeln ('Concentrao 2 --> ', cccx/pm ,' uMoles/uL                     ');
writeln ('Concentrao 3 --> ', (cccx * 1000)/pm ,' nMoles/uL                  ');
writeln ('Concentrao 4 --> ', (cccx * 1000000)/pm ,' pMoles/uL             ');
writeln ('Concentrao 5 --> ', cccx ,' ug/uL                                           ');
writeln ('Concentrao 6 --> ', cccx * 1000 ,' ng/uL                                    ');
writeln ('Concentrao 7 --> ', cccx * 1000000 ,' pg/uL                                 ');
writeln ('                                                                            ');
writeln ('                                                                            ');
Writeln ('Pressione Enter');
readln ;

textcolor (1);
textbackground (1);

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}
Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;


end;





Procedure pisoluso;

Var
op: char; {codigo da opcao de calculo}

Begin

ClrScr;

Writeln ('#############################################################################');
writeln ('########Clculo do volume da soluo de uso a ser pipetado na reao#########');
writeln ('#############################################################################');
writeln ('');
writeln ('');
writeln ('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>ESCOLHA A SUA OPO<<<<<<<<<<<<<<<<<<<<<<<<<<<<<');
writeln ('');
writeln ('[1] --> Calcular a partir de soluo de uso pronta');
writeln ('');
writeln ('[2] --> Calcular a partir de nova soluo de uso');
writeln ('');
write ('Opo = ');
readln (op);

 case (op) of

 '1' :  op1;


 '2' :  op2;

 end;
end;


Procedure converte;

Var
op: char; {codigo da opcao de calculo}

Begin

ClrScr;

Writeln ('#############################################################################');
writeln ('############Clculo de converso de unidades de massa e concentrao#########');
writeln ('#############################################################################');
writeln ('');
writeln ('');
writeln ('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>ESCOLHA A SUA OPO<<<<<<<<<<<<<<<<<<<<<<<<<<<<<');
writeln ('');
writeln ('[1] --> Calcular converso de massa');
writeln ('');
writeln ('[2] --> Calcular converso de concentrao');
writeln ('');
write ('Opo = ');
readln (op);

 case (op) of

 '1' :  con1;


 '2' :  con2;

 end;
end;







Procedure entrada;

Var

opcao: char;


Begin

ClrScr;

{nicio da tela de entrada}

textcolor (black);
textbackground (red);

writeln ('***************** LABDROS - LABORATRIO DE BIOLOGIA MOLECULAR****************');
writeln ('                                                                             ');
writeln ('                        UNIVERSIDADE FEDERAL DE SANTA MARIA                  ');
writeln ('                                                                             ');
writeln ('                                                                             ');
writeln ('               x xxxxxxxxxxxx  xxxxxxxxxx  xxxxxxxxxx  xx          xxxxxxxxx ');
writeln ('              x xxxxxxxxxxxxx  xxxxxxxxxx  xxxxxxxxxx  xx          xxxxxxxxx ');
writeln ('             x x         x x   xx          xx      xx  xx          xx        ');
writeln ('            x x         x x    xx          xx      xx  xx          xx        ');
writeln ('           x x         x x     xx          xx      xx  xx          xx        ');
writeln ('          x x         x x      xx          xx      xx  xx          xx        ');
writeln ('         x x         x x       xx          xx      xx  xx          xx        ');
writeln ('        x xxxxxxxxxxxxx        xx          xxxxxxxxxx  xx          xx        ');
writeln ('       x xxxxxxxxxxxxx         xx          xxxxxxxxxx  xx          xx        ');
writeln ('      x x                      xx          xx      xx  xx          xx        ');
writeln ('     x x                       xx          xx      xx  xx          xx        ');
writeln ('    x x                        xx          xx      xx  xx          xx        ');
writeln ('   x x                         xx          xx      xx  xx          xx        ');
writeln ('  x x  Compilado em 05/02/2000 xx          xx      xx  xx          xx        ');
writeln (' x x                           xxxxxxxxxx  xx      xx  xxxxxxxxxx  xxxxxxxxx ');
writeln ('x x                            xxxxxxxxxx  xx      xx  xxxxxxxxxx  xxxxxxxxx ');
writeln ('                                                                             ');
writeln ('                                                                             ');
writeln ('Dvidas,sugestes e para obter o fonte-> operon@www.ufsm.br [pressione enter]');

readln;

{fim da tela de entrada}

textcolor (1);
textbackground (1);

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}
Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;


end;


Procedure calcta;

Var
cdna : array [1..1000] of char;
origin : array [1..1000] of char;
cont : integer;
num :integer;
resp : string;
bases : integer;
id : integer;
opcao: char;
a: integer;
t: integer;
c: integer;
g: integer;


Begin
ClrScr;
cont := 1;
bases := 0;
num :=1;
id := 0;
a:= 0;
t:= 0;
c:= 0;
g:= 0;

Writeln ('((((((((((((CLCULO DA TEMPERATURA DE ANELAMENTO DO PRIMER)))))))))))))))))))');
writeln ('');

writeln (' ');
writeln ('Digite a sequencia de nucleotdeos . Para encerrar a entrada de dados digite x (pressione enter...)');
readln;

  while cont < 1000  do
  Begin
   writeln ('Digite o ', cont, ' nucleotdeo');
   readln (origin [cont]);
    if (origin [cont]) = 'x' then
     begin
      cont := 999;
      end;

    case origin[cont] of

     'a' : a := a + 1;
     't' : t := t + 1;
     'c' : c := c + 1;
     'g' : g := g + 1;

    end;

   bases:= bases + 1;
   cont := cont + 1;
  end;

bases := bases - 1;





clrscr;

WriteLn ('Lista para confirmao de digitao. (pressione enter)');
readln;
clrscr;

writeln ('Listando...(pressione enter)');
readln;
 repeat
   begin
    id := id + 1;
    write ('nucleotdeo nmero ', id);
    write ('  ');
    write ( origin[id]);
    readln;
   end;
 Until (id = bases);

Writeln ('Final da Listagem - Pressione Enter');
readln;





ClrScr;

textcolor (1);
textbackground (1);

textcolor (blue);
textbackground (white);

writeln ('Total de nucleotdeos  ', bases                                              );

writeln ('Nmero de A = ', a                                                            );
writeln ('Nmero de T = ', t                                                            );
writeln ('Nmero de C = ', c                                                            );
writeln ('Nmero de G = ', g                                                            );

writeln ('% de A = ', (a/bases) *100,' -----------  % de T = ', (t/bases) *100                   );
writeln ('% de C = ', (c/bases) *100,' -----------  % de G = ', (g/bases) *100                   );

writeln ('% de A + T = ',((a + t)/bases)*100                                            );
writeln ('% de C + G = ',((c + g)/bases)*100                                            );

writeln ('');
writeln ('                 ############CLCULO DA TEMP. DE ANELAMENTO#############     ');
writeln ('');
writeln ('TEMPERATURA DE ANELAMENTO  --> ',(((a+t)*2) +((g+c)*4)),' graus celsius');
writeln ('');
writeln ('Pressione Enter                                                              ');
readln;

textcolor (1);
textbackground (1);

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}
Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;



readln;

end;




Procedure odconv;

Var
cdna : array [1..1000] of char;
origin : array [1..1000] of char;
cont : integer;
num :integer;
resp : string;
bases : integer;
id : integer;
opcao: char;
a: integer;
t: integer;
c: integer;
g: integer;
od : real;
mw : real;
odug: real;
e: real;

Begin
ClrScr;
cont := 1;
bases := 0;
num :=1;
id := 0;
a:= 0;
t:= 0;
c:= 0;
g:= 0;

Writeln ('((((((((((((((((((((((CLCULO DA CONVERSO DE OD)))))))))))))))))))))))))))))');
writeln ('');
write ('Digite o nmero de ODs -->  ');
readln (od);
write ('Digite o peso molecular do primer --> ');
readln (mw);
writeln ('');
writeln (' ');
writeln ('Digite a sequencia de nucleotdeos . Para encerrar a entrada de dados digite x (pressione enter...)');
readln;

  while cont < 1000  do
  Begin
   writeln ('Digite o ', cont, ' nucleotdeo');
   readln (origin [cont]);
    if (origin [cont]) = 'x' then
     begin
      cont := 999;
      end;

    case origin[cont] of

     'a' : a := a + 1;
     't' : t := t + 1;
     'c' : c := c + 1;
     'g' : g := g + 1;

    end;

   bases:= bases + 1;
   cont := cont + 1;
  end;

bases := bases - 1;

e :=  ((8.8*t) + (7.3*c) + (11.7*g) + (15.4*a))*0.9;
odug := (od * mw) / e;




clrscr;

WriteLn ('Lista para confirmao de digitao. (pressione enter)');
readln;
clrscr;

writeln ('Listando...(pressione enter)');
readln;
 repeat
   begin
    id := id + 1;
    write ('nucleotdeo nmero ', id);
    write ('  ');
    write ( origin[id]);
    readln;
   end;
 Until (id = bases);

Writeln ('Final da Listagem - Pressione Enter');
readln;


ClrScr;

textcolor (1);
textbackground (1);

textcolor (blue);
textbackground (white);

writeln ('Total de nucleotdeos  ', bases                                              );

writeln ('Nmero de A = ', a                                                            );
writeln ('Nmero de T = ', t                                                            );
writeln ('Nmero de C = ', c                                                            );
writeln ('Nmero de G = ', g                                                            );

writeln ('% de A = ', (a/bases) *100,' -----------  % de T = ', (t/bases) *100                   );
writeln ('% de C = ', (c/bases) *100,' -----------  % de G = ', (g/bases) *100                   );

writeln ('% de A + T = ',((a + t)/bases)*100                                            );
writeln ('% de C + G = ',((c + g)/bases)*100);

writeln ('Coeficiente de extino molar = ',e                                           );
writeln ('');
writeln ('                       ############Converso de ODs#############             ');
writeln ('');
writeln ('unidade 1 --> ', odug/(mw*1000000) ,' Moles                                  ');
writeln ('unidade 2 --> ', odug/mw ,' uMoles                                           ');
writeln ('unidade 3 --> ', (odug * 1000)/mw ,' nMoles                                  ');
writeln ('unidade 4 --> ', (odug * 1000000)/mw ,' pMoles                               ');
writeln ('unidade 5 --> ', odug ,' ug                                                  ');
writeln ('unidade 6 --> ', odug * 1000 ,' ng                                           ');
writeln ('unidade 7 --> ', odug * 1000000 ,' pg                                        ');
writeln ('                                                                             ');
writeln ('Pressione Enter                                                              ');
readln;

textcolor (1);
textbackground (1);

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}
Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;



readln;

end;



Procedure calcmw;

Var
cdna : array [1..1000] of char;
origin : array [1..1000] of char;
cont : integer;
num :integer;
resp : string;
bases : integer;
id : integer;
opcao: char;
a: integer;
t: integer;
c: integer;
g: integer;


Begin
ClrScr;
cont := 1;
bases := 0;
num :=1;
id := 0;
a:= 0;
t:= 0;
c:= 0;
g:= 0;

Writeln ('(((((((((((((((((CLCULO DO PESO MOLECULAR DO PRIMER)))))))))))))))))))))))))');
writeln ('');

writeln (' ');
writeln ('Digite a sequencia de nucleotdeos . Para encerrar a entrada de dados digite x (pressione enter...)');
readln;

  while cont < 1000  do
  Begin
   writeln ('Digite o ', cont, ' nucleotdeo');
   readln (origin [cont]);
    if (origin [cont]) = 'x' then
     begin
      cont := 999;
      end;

    case origin[cont] of

     'a' : a := a + 1;
     't' : t := t + 1;
     'c' : c := c + 1;
     'g' : g := g + 1;

    end;

   bases:= bases + 1;
   cont := cont + 1;
  end;

bases := bases - 1;





clrscr;

WriteLn ('Lista para confirmao de digitao. (pressione enter)');
readln;
clrscr;

writeln ('Listando...(pressione enter)');
readln;
 repeat
   begin
    id := id + 1;
    write ('nucleotdeo nmero ', id);
    write ('  ');
    write ( origin[id]);
    readln;
   end;
 Until (id = bases);

Writeln ('Final da Listagem - Pressione Enter');
readln;





ClrScr;

textcolor (1);
textbackground (1);

textcolor (blue);
textbackground (white);

writeln ('Total de nucleotdeos  ', bases                                              );

writeln ('Nmero de A = ', a                                                            );
writeln ('Nmero de T = ', t                                                            );
writeln ('Nmero de C = ', c                                                            );
writeln ('Nmero de G = ', g                                                            );

writeln ('% de A = ', (a/bases) *100,' -----------  % de T = ', (t/bases) *100                   );
writeln ('% de C = ', (c/bases) *100,' -----------  % de G = ', (g/bases) *100                   );

writeln ('% de A + T = ',((a + t)/bases)*100                                            );
writeln ('% de C + G = ',((c + g)/bases)*100                                            );

writeln ('');
writeln ('                       ############CLCULO DO PESO MOLECULAR#############             ');
writeln ('');
writeln ('PESO MOLECULAR  IGUAL A -->  ', (249*a)+(240*t)+(265*g)+(225*c)+(63*(bases-1))+2);
writeln ('Pressione Enter                                                              ');
readln;

textcolor (1);
textbackground (1);

Clrscr;

textcolor (yellow);
textbackground (blue);

{inicio das secao de escolha da tarefa}
Writeln ('ESCOLHA A TAREFA');
writeln ('');
writeln ('[1] --> Clculo das solues dos primers');
writeln ('[2] --> Clculo do volume da soluo de uso que deve ser pipetada na reao');
writeln ('[3] --> Clculo da cadeia complementar do primer');
writeln ('[4] --> Clculos de converso de Unidades');
writeln ('[5] --> Voltar para o inicio');
writeln ('[6] --> Encerrar o programa');
writeln ('[7] --> Clculo de Converso de OD');
writeln ('[8] --> Clculo do peso molecular do primer');
writeln ('[9] --> Clculo da temperatura de anelamento do primer');
writeln ('[0] --> Creditos');

writeln ('');
write (' Digite a sua opo --> ');
readln (opcao);
case (opcao) of


 '1': Global;
 '2': pisoluso;
 '3': Seqprimer;
 '4': converte;
 '5': entrada;
 '6': encerrar;
 '7': odconv ;
 '8': calcmw ;
 '9': calcta ;
 '0': creditos;
  end;



readln;

end;






{************************** fim do bloco das procedures**********************}


Begin

entrada;


End.