#pragma once
#include <stdio.h>
#include <iostream>
#include  <string>
#include  <vector>
#include <algorithm>
using namespace std;


enum GeneElementType
{
	Type_Exon,
	Type_Intron,
	Type_UTR
};

class GeneElement
{
public:	
	int m_Start;
	int m_End;
	GeneElementType m_Type;
	GeneElement(int start, int end)
	{
		m_Start = start;
		m_End = end;		
	}
	virtual ~GeneElement(){};
	virtual GeneElementType GetType()
	{
		return m_Type;
	}
	virtual void Print()=0;
	virtual string GetName()=0;
};



class Exon: public GeneElement
{
	public:
	int m_Index;
	Exon(int start, int end, int index):GeneElement(start,end)
	{
		m_Type = Type_Exon;	
		m_Index = index;
	}	
	virtual void Print()
	{
		cout << "Exon: index " << m_Index << " start " << m_Start << " End " << m_End << endl; 
	}
	virtual string GetName()
	{
		char buf[100];
		if(m_Index > 0)
		{
			sprintf(buf,"%s%d","Exon",m_Index);
		}
		else //if(m_Index == -1)
		{
			sprintf(buf,"%s","LastExon");
		}
		string name = buf;
		return name;
	}
};

class Intron: public GeneElement
{	
public:
	int m_Index;
	Intron(int start, int end, int index):GeneElement(start,end)
	{
		m_Type = Type_Intron;
		m_Index = index;
	}	
	virtual void Print()
	{
		cout << "Intron: index " << m_Index << " start " << m_Start << " End " << m_End << endl; 
	}
	virtual string GetName()
	{
		char buf[100];
		if(m_Index > 0)
		{
			sprintf(buf,"%s%d","Intron",m_Index);
		}
		else //if(m_Index == -1)
		{
			sprintf(buf,"%s","LastIntron");
		}
		string name = buf;
		return name;
	}
};

class UTR: public GeneElement
{
public:	
	int m_UTR_Index;

	UTR(int start, int end, int UTRIndex):GeneElement(start,end)
	{			
		m_Type = Type_UTR;	
		m_UTR_Index = UTRIndex;
	}
	virtual void Print()
	{
		cout << "UTR" << m_UTR_Index << " start " << m_Start << " End " << m_End << endl; 
	}
	virtual string GetName()
	{
		char buf[100];
		sprintf(buf,"%s%d","UTR",m_UTR_Index);
		string name = buf;
		return name;
	}
};

