#pragma once
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <map>
#include <list>
using namespace std;

#include "BinarySearch.h"
#include "Position.h"
#include "GeneralParser.h"
#include "BEDParser.h"

class PeakAnnotator
{	
private:
	//Input file names
	string m_File1Name;
	string m_File2Name;
	
	//output file names
	string m_OutFileName;
	string m_OverlapFileName;

	//output file streams
	ofstream m_outFile;
	ofstream m_outOverlapFile;

	//the map key is the chromosome and the value is a vector of positions in this chromosome
	//the maps are used to 
	map<string,vector<Position*>* > m_MapOfPeaks;
	map<string,vector<Position*>* > m_MapOfGenes;

	map<string,int> m_SizeMap;

	int m_NumRandomDataSets;	
    bool m_Use5EndDistance;
	map<string,vector<Position*>*>* CreateRandomDataset();
	int RandomOverlaps(map<string,vector<Position*>*>* randomMapOfPeaks);
public:	

	PeakAnnotator(string peakFile, string geneFile, string outputFile, string symbolFile,bool mustStrand, bool use5EndDistance,
		string chrSizeFile = "NULL", int numRandomDataSets = 0);

	void ClosestTSS(bool checkOverlap);

	void ClosestDownstreamGenes();	

	void OverlapPositions();

private:
	void Initialize(string peakFile, string geneFile, string outputFile, string symbolFile,bool mustStrand,
		bool use5EndDistance, string chrSizeFile, int numRandomDataSets);

	void PrintOverlapPosition(Position* gene,Position* position, 
		GeneElement* overlapStart,
		GeneElement* overlapCentral,
		GeneElement* overlapEnd);

	void PrintClosestGene(Position* ClosestDownstreamPosGene, int ClosestDownstreamPosDistance,
									 Position* ClosestDownstreamNegGene, int ClosestDownstreamNegDistance,
									 Position* position, int numOfOverlapGenes);

	string GetFileName(string FullPath)
	{	
		int inx = FullPath.find_last_of("\\");
		if(inx == -1)
			inx = FullPath.find_last_of("//");
		return FullPath.substr(inx+1,FullPath.length()-inx);
	}

	int GetInt32Rand()
	{
		if(RAND_MAX == 0x7fff)
		{
			int randomnumber1 = rand();
			int randomnumber2 = rand();
			int longrandomnumber = (randomnumber1 << 16) | randomnumber2;
			return longrandomnumber;
		}
		else
		{
			return rand();
		}
	}
};
