#pragma once
#include <stdio.h>
#include <iostream>
#include <string>
#include <vector>
#include <list>
#include <algorithm>
#include <math.h>
using namespace std;
#include "GeneElement.h"

enum Strand
{
	Strand_Positive,
	Strand_Negative,
	Strand_Unknown
};
class Position
{

public:	
	int m_Start;
	int m_End;	
	string m_Chromosome;
	string m_RecordInfo;
	double m_CentralPoint;
	Strand m_Strand;
	string m_Id;
	string m_Symbol;
	vector<GeneElement*> m_GeneElements;		
	UTR* m_BeginUTR;
	UTR* m_EndUTR;
	list<Position*>* m_Containers; //positions contain the specific locus
	bool m_OverlapFlag; // set to true if there is other position which overlaps

	Position()
	{
		m_BeginUTR = NULL;
		m_EndUTR = NULL;
		m_Containers = new list<Position*>();
	};

	Position(int start,int end,string chrom);

	Position(int start,int end,string id,string symbol,
		string chrom,Strand strand,string recordInfo);

	Position(int start,int end,string id,string symbol,vector<GeneElement*> elements,
		string chrom,Strand strand, UTR* beginUTR, UTR* endUTR);
	virtual ~Position(void);
	
	bool IsBeginUTRExists();
	bool IsEndUTRExists();		
	void Print();
	int IsRight(Position& other);
	//virtual int operator - (Position& other);
	virtual int Minus (Position* other);
	virtual int MinusTSS (Position* other);
	bool IsContained(Position& other);

	void FindOverlapGeneElement(Position* position,											
											GeneElement*& overlapStart,
											GeneElement*& overlapCentral,
											GeneElement*& overlapEnd);
	double GetCentralPoint();

	bool Overlap (Position* other);

	//used in remove_if
	bool operator() (Position& other) {return !this->IsContained(other); }
};
