#include "PeakAnnotator.h"
#include <cstring>

#ifdef WIN32
#define strcasecmp stricmp
#endif

void PrintClosestDownstreamGenesUsage()
{
	cout <<"NDG <Peak file> <Annotation file> [<Symbol file>] <Output file>" << endl;
}

void PrintClosestTSSUsage()
{
	cout <<"TSS <Peak file> <Annotationfile> [<Symbol file>] <Output file>" << endl;
}

void PrintClosestPositionUsage()
{
	cout <<"closestPosition <Peak file> <Position file> [<Symbol file>] <Output file>" << endl;
}
void PrintPrintOverlapUsage()
{
	cout << "ODS <Position file1> <Position file2> <Output file> <chrSizeFile (optional)>  <numRandomDatasets (optional)>" << endl;
}
/*void PrintEnsemblDownloadUsage()
{
	cout << "EnsemblDownload <Organism> <Output file>" << endl;
}*/

void PrintMenu()
{	
	cout << endl;
	//cout << "EnsemblDownload\t Retrieve genes data from Ensembl" <<endl;
	cout << "NDG" << "\t" << "For eack peak find its closest downstream gene on both strands"<<endl;
	cout << "TSS" <<"\t"<< "For each peak find the distance to its closest TSS" <<endl;
	cout << "ODS" << "\t" << "Find overlaps between two position files" << endl;
	cout << "closestPosition" << "\t"<<"Same as TSS, distance from peaks to overlapping genes is set to be zero"<<endl;
	cout << endl;
}

int main(int argc, char* argv[])
{
	try
	{				
		if(argc == 1)
		{
			PrintMenu();
			return 0;
		}
		if(strcasecmp(argv[1],"NDG") == 0)
		{
			if(argc < 5)
			{
				PrintClosestDownstreamGenesUsage();
				return -1;
			}	
			if(argc == 5)
			{
				PeakAnnotator annotator(argv[2],argv[3],argv[4],"NULL",true);
				annotator.ClosestDownstreamGenes();			
			}
			else
			{
				PeakAnnotator annotator(argv[2],argv[3],argv[5],argv[4],true);
				annotator.ClosestDownstreamGenes();
			}
		}		
		else if(strcasecmp(argv[1],"TSS") == 0)
    	{
    		if(argc < 5)
    		{
            	PrintClosestTSSUsage();
				return -1;
    		}    		
            if(argc == 5)
			{				
				PeakAnnotator annotator(argv[2],argv[3],argv[4],"NULL",false);
				annotator.ClosestTSS(false);			
			}
			else
			{				
				PeakAnnotator annotator(argv[2],argv[3],argv[5],argv[4],false);
				annotator.ClosestTSS(false);
			}
    	}		
		else if(strcasecmp(argv[1],"closestPosition") == 0)
    	{
    		if(argc < 5)
    		{
            	PrintClosestPositionUsage();
				return -1;
    		}    		
            if(argc == 5)
			{				
				PeakAnnotator annotator(argv[2],argv[3],argv[4],"NULL",false);
				annotator.ClosestTSS(true);			
			}
			else
			{				
				PeakAnnotator annotator(argv[2],argv[3],argv[5],argv[4],false);
				annotator.ClosestTSS(true);
			}
    	}
		else if(strcasecmp(argv[1],"ODS") == 0)
    	{
        	if(argc < 5)
        	{
				PrintPrintOverlapUsage();
        	}
        	else if(argc == 7)
			{				
				int numRandom = atoi(argv[6]);	
				if((numRandom == 0) && (argv[6][0] != '0'))
				{
					string err = "Invalid number " + string(argv[6]);
					throw err;
				}
				PeakAnnotator annotator(argv[2],argv[3],argv[4],"NULL", false, argv[5],numRandom);
				annotator.OverlapPositions();
			}
			else
        	{
				PeakAnnotator annotator(argv[2],argv[3],argv[4],"NULL",false);
				annotator.OverlapPositions();
			}
    	}
		/*else if(strcasecmp(argv[1],"EnsemblDownload") == 0)
		{
			if(argc < 4)
			{
				PrintEnsemblDownloadUsage();
				return -1;
			}
			else
			{
				annotator.EnsemblDownload(argv[2],argv[3]);
			}
		}*/
		else
		{
			PrintMenu();
			return -1;
		}
		return 0;
	}
	catch(char* msg)
	{
		cerr << msg << endl;
		return -1;
	}
	catch(string& str)
	{
		cerr << str.c_str() << endl;
		return -1;
	}
	catch(...)
	{
		cerr << "error occured" << endl;
		return -1;
	}
}


