#pragma once
#include <iostream> //cin, cout, <, >
#include <fstream> //ifstream, ofstream
#include <string>
#include <vector>
using namespace std;
#include "Position.h"

int AtoI(string& str);
string ToUpper(string& str);

class Parser
{
protected:
	ifstream m_File;	
	char m_LineDelimiter;
public:
	Parser(string fileName);
	virtual ~Parser(void);
	virtual void Tokenize(const string& str,
                      vector<string>& tokens,
                      const string& delimiters = " ");	
};

class ReadFileParser: public Parser
{
protected:
	int m_ReadLength;
public:
	ReadFileParser(string fileName):Parser(fileName){};
	~ReadFileParser(void){};
	virtual Position* ParseLine() = 0;
	virtual int ReadLength()
	{
		return m_ReadLength;
	}
};
