#include "Position.h"
#include "Parser.h"

Position::~Position(void)
{	
	/*list<Position*>::iterator itr;
	for(itr = m_Containers->begin(); itr != m_Containers->end(); ++itr)	
	{
		delete *itr;
	}*/
	delete m_Containers;
	if(m_BeginUTR != NULL)
	{
		delete m_BeginUTR;
	}
	if(m_EndUTR != NULL)
	{
		delete m_EndUTR;
	}
	for(int i=0;i<m_GeneElements.size();i++)
	{
		delete m_GeneElements[i];
	}
}

Position::Position(int start,int end,string chrom)
{
	m_Start = start;
	m_End = end;
	m_BeginUTR = NULL;
	m_EndUTR = NULL;
	m_Containers = new list<Position*>();	

	if(ToUpper(chrom).substr(0,3) == "CHR")
	{
		m_Chromosome = chrom;
	}
	else
	{
		m_Chromosome = "CHR" + chrom;
	}
	m_Chromosome.replace(0,3,"chr");
	if(m_Chromosome == "chrMT")
	{
		m_Chromosome = "chrM";
	}
}

Position::Position(int start,int end,string id,string symbol,
		   string chrom,Strand strand,string recordInfo)
{
	m_Start = start;
	m_End = end;
	m_BeginUTR = NULL;
	m_EndUTR = NULL;
	m_Containers = new list<Position*>();	
	if(ToUpper(chrom).substr(0,3) == "CHR")
	{
		m_Chromosome = chrom;
	}
	else
	{
		m_Chromosome = "CHR" + chrom;
	}
	m_Chromosome.replace(0,3,"chr");
	if(m_Chromosome == "chrMT")
	{
		m_Chromosome = "chrM";
	}
	m_RecordInfo = recordInfo;

	m_CentralPoint = m_Start + (double)(m_End-m_Start)/2;
	m_Id = id;
	m_Symbol = symbol;	
	m_Strand = strand;		
	m_BeginUTR = NULL;
	m_EndUTR = NULL;
	m_OverlapFlag = false;
}

Position::Position(int start,int end,string id,string symbol,vector<GeneElement*> elements,
		string chrom,Strand strand, UTR* beginUTR, UTR* endUTR)
{	
	m_Start = start;
	m_End = end;
	m_BeginUTR = NULL;
	m_EndUTR = NULL;
	m_Containers = new list<Position*>();

	if(ToUpper(chrom).substr(0,3) == "CHR")
	{
		m_Chromosome = chrom;
	}
	else
	{
		m_Chromosome = "CHR" + chrom;
	}
	m_Chromosome.replace(0,3,"chr");
	if(m_Chromosome == "chrMT")
	{
		m_Chromosome = "chrM";
	}
	m_RecordInfo = "";
	m_CentralPoint = m_Start + (double)(m_End-m_Start)/2;
	m_Id = id;
	m_Symbol = symbol;	
	m_Strand = strand;
	m_GeneElements = elements;
	m_BeginUTR = beginUTR;
	m_EndUTR = endUTR;
	m_OverlapFlag = false;
}
int Position::IsRight(Position& other)
{
	if(this->m_Chromosome != other.m_Chromosome)
	{
		string err = "Cannot compare Positions of different chromosomes";
		throw err;
	}	

	return (this->m_Start - other.m_End);
}
int Position::Minus (Position* other)
{
	//normally peak is first and then gene
	//this is the gene from file2 other is the peak from file1	
	//peak.centre - gene.start

	//if gene is first and then peak
	//this is the peak from file2 other is the gene from file1


	/************************************************************************************************************************
	*	the sign of the distance (+ or -) has biological meaning
	*	+ means that the peak is downstream to the gene
	*	- means that the peak is upstream to the gene
	*	the order of the input files doesn't matter
	*	unless there is no strand information at all.
	*	in this case the distance is calculated as the central of position from file 1 minus central of position from file 2 
	/************************************************************************************************************************/
	if(this->m_Chromosome != other->m_Chromosome)
	{
		string err = "Cannot compare Positions of different chromosomes";
		throw err;
	}		

	if(this->m_Strand == Strand_Positive)
		return(int)(other->GetCentralPoint() - this->m_Start);
	else if(this->m_Strand == Strand_Negative)
		return(int)(this->m_End - other->GetCentralPoint());
	else //unknwon
	{
		if(other->m_Strand == Strand_Positive)
			return(int)(this->GetCentralPoint() - other->m_Start);
		else if(other->m_Strand == Strand_Negative)
			return(int)(other->m_End - this->GetCentralPoint());
		return(int)(other->GetCentralPoint() - this->GetCentralPoint());
	}
};


bool Position::IsContained(Position& other)
{
	if(other.m_Chromosome != this->m_Chromosome)
		return false;
	if(other.m_Start <= this->m_Start && other.m_End >= this->m_End)
		return true;
	return false;
}


void Position::FindOverlapGeneElement(Position* position,
											GeneElement*& overlapStart,
											GeneElement*& overlapCentral,
											GeneElement*& overlapEnd)
{
	int i=0;	
	int k=0;
	overlapStart = NULL;
	overlapCentral = NULL;
	overlapEnd = NULL;
	if(this->m_GeneElements.size() == 0)
	{
		string err = "Gene Element information is missing";
		throw err;
	}
	//find first gene element that exceeds peak start
	for(; i < this->m_GeneElements.size();i++)
	{			
		if((position->m_Start >= this->m_GeneElements[i]->m_Start) &&
			(position->m_Start <= this->m_GeneElements[i]->m_End))
		{
			overlapStart = this->m_GeneElements[i];		
			break;
		}
		if(position->m_Start < this->m_GeneElements[i]->m_Start)
			break;
	}	
	for(k = i; k < this->m_GeneElements.size(); k++)
	{
		if((position->m_CentralPoint >= this->m_GeneElements[k]->m_Start) &&
			(position->m_CentralPoint <= this->m_GeneElements[k]->m_End))
		{
			overlapCentral = this->m_GeneElements[k];		
			break;
		}
		if(position->m_CentralPoint < this->m_GeneElements[k]->m_Start)
			break;
	}

	for(int j = k; j < this->m_GeneElements.size(); j++)
	{
		if((position->m_End >= this->m_GeneElements[j]->m_Start) &&
			(position->m_End <= this->m_GeneElements[j]->m_End))
		{
			overlapEnd = this->m_GeneElements[j];		
			break;
		}
		if(position->m_End < this->m_GeneElements[j]->m_Start)
			break;		
	}
	//check if the Begin element overlaps a UTR
	if ((overlapStart != NULL) &&
		(overlapStart->m_Type == Type_Exon) &&
		(this->m_BeginUTR != NULL) &&		
		position->m_Start <= this->m_BeginUTR->m_End)
	{
		overlapStart = this->m_BeginUTR;
	}

	if ((overlapCentral != NULL) &&
		(overlapCentral->m_Type == Type_Exon) &&
		(this->m_BeginUTR != NULL) &&		
		position->m_Start <= this->m_BeginUTR->m_End)
	{
		overlapCentral = this->m_BeginUTR;
	}

	if ((overlapEnd != NULL) &&
		(overlapEnd->m_Type == Type_Exon) &&
		(this->m_BeginUTR != NULL) &&
		(position->m_End >= this->m_BeginUTR->m_Start) &&
		position->m_End <= this->m_BeginUTR->m_End)
	{
		overlapEnd = this->m_BeginUTR;
	}	

	//check if the End element overlaps a UTR
	if ((overlapStart != NULL) &&
		(overlapStart->m_Type == Type_Exon) &&
		(this->m_EndUTR != NULL) &&
		(position->m_Start >= this->m_EndUTR->m_Start) &&
		position->m_Start <=   this->m_EndUTR->m_End)
	{
		overlapStart = this->m_EndUTR;
	}
	if ((overlapCentral != NULL) &&
		(overlapCentral->m_Type == Type_Exon) &&
		(this->m_EndUTR != NULL) &&
		(position->m_Start >= this->m_EndUTR->m_Start) &&
		position->m_Start <=   this->m_EndUTR->m_End)
	{
		overlapCentral = this->m_EndUTR;
	}

	if ((overlapEnd != NULL) &&
		(overlapEnd->m_Type == Type_Exon) &&
		(this->m_EndUTR != NULL) &&
		(position->m_End >= this->m_EndUTR->m_Start))
	{
		overlapEnd = this->m_EndUTR; 
	}
}

bool Position::IsBeginUTRExists()
{
	if(m_BeginUTR != NULL)
		return true;
	return false;
}
bool Position::IsEndUTRExists()
{
	if(m_EndUTR != NULL)
		return true;
	return false;
}

void Position::Print()
{
	cout<< "Position details:" << endl;
	cout<< "Position Start " << this->m_Start << " Position End " << this->m_End << endl;
	if(this->IsBeginUTRExists())
	{		
		this->m_BeginUTR->Print();
	}
	for(int i=0;i<this->m_GeneElements.size();i++)
	{
		m_GeneElements[i]->Print();		
	}
	if(this->IsEndUTRExists())	
	{
		this->m_EndUTR->Print();		
	}
}

double Position::GetCentralPoint()
{
	return m_CentralPoint;
};
bool Position::Overlap (Position* other)
{
	if((this->m_End < other->m_Start) || (this->m_Start > other->m_End))
		return false;
	return true;
}
