package org.peakAnnotator;

import java.util.ArrayList;

public class BinarySearch {

	/********************************************************************************************************************
	* This is the function that is called by the application.                                                           *                                    
	* This method initiate a binary search on the given vector of positions and returns the minimal element index       *   
	* whose start position is bigger than the given point.                                                              *                                    
	* If no such element is found in the vector the method returns -1                                                   *                                    
	* it is assumed that all positions in the vector are of the same chromosome.                                        *                                   
	* In addition it is assumed that the vector is sorted according to the elements' start position.                    *                   
	********************************************************************************************************************/

	public static int FindRightAdjacentGene(ArrayList<Position> vec,int point)
	{
	        //if vector is empty - there is nothing to do
	        if(vec.size() == 0)
	                return -1;
	        //initiate a binary search over the whole vector
	        return FindRightAdjacentGene(vec,0,vec.size()-1,point);
	}
	/*
	* This method is called recursively every time on half of the vector from the previous step.
	*/
	private static int FindRightAdjacentGene(ArrayList<Position> vec,int start,int end,int point)
	{
	        //stop condition - the search area is of size 1
	        if(end == start)
	        {
	                //if vec[start] is right to the point returns value > 0
	                int current = (vec.get(start).m_Start - point);
	                if(current > 0)
	                        return start;
	                else
	                      return -1;
	        }

	        //find the middle of the vector
	        int middle = (end+start)/2;
	        //check if the middle element is on the left or on the right of the point
	        //if vec[middle] is right to the point returns value > 0
	        int res = vec.get(middle).m_Start - point;
	                
	        if(res > 0)
	        {
	                //search in the lower half. vec[middle] is also a potential target
	            return FindRightAdjacentGene(vec,start,middle,point);
	        }
	        else
	        {
	                //search in the higher half. vec[middle] is not a potential target
	                return FindRightAdjacentGene(vec,middle+1,end,point);
	        }
	}




}
