package org.peakAnnotator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public abstract class Parser {

	protected BufferedReader m_File;
	protected long m_size;
	protected long m_currentOffset;
	
	public Parser(String fileName) throws FileNotFoundException
	{
		File temp = new File(fileName);
		m_size = temp.length();
		
		FileReader file = new FileReader(fileName);
		m_File = new BufferedReader(file);
		m_currentOffset = 0;
	}
                
	public void clean() throws IOException
	{
        m_File.close();
	}
	public abstract Position GetPosition() throws IOException;
	
	public long getSize()
	{
		return m_size;
	}
	public long getCurrentOffset(){
		return m_currentOffset;
	}
}

