package org.peakAnnotator;

import java.util.ArrayList;

import org.peakAnnotator.GeneElement.GeneElementType;

public class Position implements Comparable<Position> {

	protected int m_Start;
	protected int m_End;
	protected String m_Chromosome;
	private double m_CentralPoint;
	protected Strand m_Strand;
	protected String m_Symbol;
	protected String m_Id;
	protected String m_Source;
	ArrayList<GeneElement> m_GeneElements;
    UTR m_BeginUTR;
    UTR m_EndUTR;
    ArrayList<Position> m_Containers; //positions contain the specific locus
    boolean m_OverlapFlag; // set to true if there is other position which
	public enum Strand{
		Strand_Positive,
		Strand_Negative,
		Strand_Unknown	
	}
	public Position(){}
	public Position(int start, int end,String chr)
	{
		m_Start=start;
		m_End=end;
		if(chr.toUpperCase().startsWith("CHR")){
			m_Chromosome = chr;
		}
		else{
			m_Chromosome = "CHR" +chr;
		}
		m_Chromosome=m_Chromosome.replace("CHR", "chr");
		//change chrMT to be chrM
		if(m_Chromosome.equals("chrMT"))
		{
			m_Chromosome="chrM";
		}
		m_Containers = new ArrayList<Position>();
	}
	
	public  Position(int start, int end,String id,String symbol,String chrom, Strand strand,String source,String recordInfo) {
		m_Start = start;
		m_End = end;
		m_Source=source;
		if(chrom.toUpperCase().startsWith("CHR")){
			m_Chromosome = chrom;
		}
		else{
			m_Chromosome = "CHR" +chrom;
		}
		m_Chromosome=m_Chromosome.replace("CHR", "chr");
		//change chrMT to be chrM
		if(m_Chromosome.equals("chrMT"))
		{
			m_Chromosome="chrM";
		}
			
		m_CentralPoint = m_Start + (double)(m_End-m_Start)/2;

        m_Id = id;
        m_Symbol = symbol;
        m_Strand = strand;
        m_BeginUTR = null;
        m_EndUTR = null;
        m_OverlapFlag = false;
        m_Containers = new ArrayList<Position>();
	}
	
	public Position(int start,int end,String id,String symbol,ArrayList<GeneElement> elements,
            String chrom,Strand strand, UTR beginUTR, UTR endUTR,String source){
		
		m_Start = start;
        m_End = end;
        m_Source=source;
        
        if(chrom.toUpperCase().startsWith("CHR"))
        {
                m_Chromosome = chrom;
        }
        else
        {
                m_Chromosome = "CHR" + chrom;
        }
        m_Chromosome=m_Chromosome.replaceFirst("CHR", "chr");
      //change chrMT to be chrM
		if(m_Chromosome.equals("chrMT"))
		{
			m_Chromosome="chrM";
		}
	
		//m_CentralPoint = m_Start +( (int) Math.floor(((double)(m_End-m_Start)/2) + 0.5) );
		m_CentralPoint = m_Start + (double)(m_End-m_Start)/2;
		
        m_Id = id;
        m_Symbol = symbol;
        m_Strand = strand;
        m_GeneElements = elements;
        m_BeginUTR = beginUTR;
        m_EndUTR = endUTR;
        m_OverlapFlag = false;
        m_Containers = new ArrayList<Position>();
	}
	public int IsRight(Position other) throws Exception  
	{
	        if(this.m_Chromosome != other.m_Chromosome)
	        {
	            throw new Exception ("Cannot compare Positions of different chromosomes");    
	        }
	        
	        return (this.m_Start - other.m_End);
	}
	public int Minus (Position other) throws Exception
	{
	        //normally peak is first and then gene
	        //this is the gene from file2 other is the peak from file1
	        //peak.center - gene.start
	                
	        //if gene is first and then peak
	        //this is the peak from file2 other is the gene from file1
		  /************************************************************************************************************************
	        *       the sign of the distance (+ or -) has biological meaning
	        *       + means that the peak is downstream to the gene
	        *       - means that the peak is upstream to the gene
	        *       the order of the input files doesn't matter
	        *       unless there is no strand information at all.
	        *       in this case the distance is calculated as the central of position from file 1 minus central of position from file 2
	        /************************************************************************************************************************/
	        if(!this.m_Chromosome.equals(other.m_Chromosome))
	        {
	        	throw new Exception( "Cannot compare Positions of different chromosomes");
	        }
	        
	        if(this.m_Strand.equals(Strand.Strand_Positive)){
	                return(int)(other.GetCentralPoint() - this.m_Start);
	        }
	        else if(this.m_Strand.equals(Strand.Strand_Negative))
	                return(int)(this.m_End - other.GetCentralPoint());
	        else //unknwon
	        {
	                if(other.m_Strand.equals(Strand.Strand_Positive))
	                        return(int)(this.GetCentralPoint() - other.m_Start);
	                else if(other.m_Strand.equals(Strand.Strand_Negative))
	                    return(int)(other.m_End - this.GetCentralPoint());
	                return(int)(other.GetCentralPoint() - this.GetCentralPoint());
	        }
	}
	public int MinusTSS (Position other) throws Exception
	{
	  if(!this.m_Chromosome.equals(other.m_Chromosome))
      {
        	throw new Exception( "Cannot compare Positions of different chromosomes");
      }
		
//	  if(this.m_BeginUTR==null || ( this.m_Strand.equals(Strand.Strand_Unknown) && other.m_BeginUTR == null))
//			return Minus(other);

	  switch(this.m_Strand)
	  {
		  case Strand_Positive:
		  {
			  if(this.m_BeginUTR==null)
				  return Minus(other);
			  return(int)(other.GetCentralPoint() - (this.m_BeginUTR.m_End+1));	  
		  }	  
		  case Strand_Negative:
			  if(this.m_EndUTR==null)
				  return Minus(other);
			  return(int)( (this.m_EndUTR.m_Start-1) - other.GetCentralPoint());
		  default: //unknown strand
			  if(other.m_Strand.equals(Strand.Strand_Positive))
	          {
				  if(other.m_BeginUTR==null)
					  return(Minus(other));
	    		  return(int)(this.GetCentralPoint() - (other.m_BeginUTR.m_Start+1));  	
	          }            
	          else if(other.m_Strand.equals(Strand.Strand_Negative))
	          {
	        	  if(other.m_EndUTR==null)
	        		  return Minus(other);
	        	  return(int)( (other.m_EndUTR.m_Start-1) - this.GetCentralPoint());
	          }  
	          return(int)(other.GetCentralPoint() - this.GetCentralPoint());
	  }
	}

	boolean IsContained(Position other)
	{
		if(!other.m_Chromosome.equals(this.m_Chromosome))
		{
			return false;
		}
	        if(other.m_Start <= this.m_Start && other.m_End >= this.m_End)
	                return true;
	        return false;
	}
	
	public void FindOverlapGeneElement(Position position,
            ArrayList<GeneElement> overlapPositions) throws Exception
	{
		int i=0;
		int k=0;
		GeneElement overlapStart = null;
		GeneElement overlapCentral = null;
		GeneElement overlapEnd = null;
		if(this.m_GeneElements==null || this.m_GeneElements.size() == 0)
		{
			throw new Exception ("Gene Element information is missing in the annotation file");
		}
		//find first gene element that exceeds peak start
		for(; i < this.m_GeneElements.size();i++)
		{
		if((position.m_Start >= this.m_GeneElements.get(i).m_Start) &&
		(position.m_Start <= this.m_GeneElements.get(i).m_End))
		{
            overlapStart = this.m_GeneElements.get(i);
            break;
	    }
	    if(position.m_Start < this.m_GeneElements.get(i).m_Start)
	            break;
		}
		for(k = i; k < this.m_GeneElements.size(); k++)
		{
		    if((position.m_CentralPoint >= this.m_GeneElements.get(k).m_Start) &&
		            (position.m_CentralPoint <= this.m_GeneElements.get(k).m_End))
		    {
		        overlapCentral = this.m_GeneElements.get(k);
		        break;
		}
		if(position.m_CentralPoint < this.m_GeneElements.get(k).m_Start)
		        break;
		}
		
		for(int j = k; j < this.m_GeneElements.size(); j++)
		{
		if((position.m_End >= this.m_GeneElements.get(j).m_Start) &&
		        (position.m_End <= this.m_GeneElements.get(j).m_End))
		{
		        overlapEnd = this.m_GeneElements.get(j);
		        break;
		}
		if(position.m_End < this.m_GeneElements.get(j).m_Start)
		        break;
		}
		//check if the Begin element overlaps a UTR
		if ((overlapStart != null) &&
		(overlapStart.m_Type.equals(GeneElementType.Type_Exon) &&
		(this.m_BeginUTR != null) &&
		position.m_Start <= this.m_BeginUTR.m_End))
		{
			overlapStart = this.m_BeginUTR;
		}
		
		if ((overlapCentral != null) &&
		(overlapCentral.m_Type.equals(GeneElementType.Type_Exon) &&
		(this.m_BeginUTR != null) &&
		position.m_Start <= this.m_BeginUTR.m_End))
		{
		    overlapCentral = this.m_BeginUTR;
		}
		 
		if ((overlapEnd != null) &&
		        (overlapEnd.m_Type.equals(GeneElementType.Type_Exon) &&
		        (this.m_BeginUTR != null) &&
		        (position.m_End >= this.m_BeginUTR.m_Start) &&
		        position.m_End <= this.m_BeginUTR.m_End))
		{
		        overlapEnd = this.m_BeginUTR;
		}
		        
		//check if the End element overlaps a UTR
		if ((overlapStart != null) &&
		        (overlapStart.m_Type.equals(GeneElementType.Type_Exon) &&
		        (this.m_EndUTR != null) &&
		        (position.m_Start >= this.m_EndUTR.m_Start) &&
		        position.m_Start <=   this.m_EndUTR.m_End))
		{
		        overlapStart = this.m_EndUTR;
		}
		if ((overlapCentral != null) &&
		        (overlapCentral.m_Type.equals(GeneElementType.Type_Exon) &&
		        (this.m_EndUTR != null) &&
		        (position.m_Start >= this.m_EndUTR.m_Start) &&
		        position.m_Start <=   this.m_EndUTR.m_End))
		{
		        overlapCentral = this.m_EndUTR;
		}
		        
		if ((overlapEnd != null) &&
		        (overlapEnd.m_Type.equals(GeneElementType.Type_Exon) &&
		        (this.m_EndUTR != null) &&
		        (position.m_End >= this.m_EndUTR.m_Start)))
		{
		    overlapEnd = this.m_EndUTR;
		}
		
		//put the elements into the array
		overlapPositions.add(overlapStart);
		overlapPositions.add(overlapCentral);
		overlapPositions.add(overlapEnd);
}

	public boolean IsBeginUTRExists()
	{
	        if(m_BeginUTR != null)
	                return true;
	        return false;
	}
	public boolean IsEndUTRExists()
	{
	        if(m_EndUTR != null)
	                return true;
	        return false;
	}   
	public void Print()
	{
	        System.out.println("Position details:"+"\n"+ "Position Start " +this.m_Start + " Position End " + this.m_End +"\n");
	        if(this.IsBeginUTRExists())
	        {
	                this.m_BeginUTR.Print();
	        }
	        for(int i=0;i<this.m_GeneElements.size();i++)
	        {
	                m_GeneElements.get(i).Print();
	        }
	        if(this.IsEndUTRExists())
	        {
	                this.m_EndUTR.Print();   
	        }
	}
	public double GetCentralPoint()
	{
	        return m_CentralPoint;
	}
	public boolean Overlap (Position other)   
	{
	        if((this.m_End < other.m_Start) || (this.m_Start > other.m_End))
	                return false;
	        return true;
	}
	public int compareTo(Position o) {
		if(this.m_Start < o.m_Start)
		{
			return -1;
		}
		else if(this.m_Start > o.m_Start)
		{
			return 1;
		}
		return 0;
	}
	public String GetSymbol()
	{
		if(m_Symbol==null)
			return m_Id;
		return m_Symbol;
	}
}
