package org.peakAnnotator;

import argparser.ArgParser;
import argparser.BooleanHolder;
import argparser.IntHolder;
import argparser.StringHolder;

public class Init 
{
	public static void main(String[] args) throws Exception 
	{	
		//create holder objects for the results
		
		StringHolder utility = new StringHolder();
		StringHolder peak1File = new StringHolder();
		StringHolder peak2File = new StringHolder();
		StringHolder annotationFile = new StringHolder();
		StringHolder outDir = new StringHolder();
		StringHolder symbolFile = new StringHolder();
		BooleanHolder mustStrand = new BooleanHolder();
		StringHolder formatType = new StringHolder();
		StringHolder geneType = new StringHolder();
		StringHolder prefix = new StringHolder();
		StringHolder chrLengthFile = new StringHolder();
		IntHolder numRandom = new IntHolder();
		
		//add default values to the arguments holders
		
		mustStrand.value=true;
		symbolFile.value="NULL";
		prefix.value = "";
		chrLengthFile.value="NULL";
		numRandom.value=1000;
//		use5end.value=true;
		
		//create the parser and specify allowed options
		ArgParser parser = new ArgParser("java -jar peakAnnotator.jar -u utility <Options>\n" + "press -u <utility name> in order to get help about the options that are specific for each utility\n");
		parser.addOption("-u,--utility %s #utility: NDG, TSS, ODS", utility);
		parser.addOption("-p,--peakFile %s #input peak file", peak1File);
		parser.addOption("-a,--annotationFile %s #input annotation GTF or BED file", annotationFile);
		parser.addOption("-p2,--peakFile2 %s #input second peak file", peak2File);
		parser.addOption("-o,--outDir %s #output folder", outDir);
		parser.addOption("-x,--prefix %s #string to add to output file names", prefix);
		parser.addOption("-s,--symbolFile %s #optional input symbol file", symbolFile);
		parser.addOption("-g,--geneType %s #gene type for annotation: protein_coding or all", geneType);
		parser.addOption("-cs,--chrSizeFile %s #file indicating chromosome sizes",chrLengthFile);
		parser.addOption("-r,--numRandomDatasets %d #number of random datasets to generate when calculating overlap p value (default 1000)",numRandom);
	
		//match the arguments, and handle the un-matched
		parser.matchAllArgs(args);
		if(utility.value==null)
		{
			String help = parser.getHelpMessage();
			System.out.println(help + "\n");
			return;
		}
		else
			try
		{
			{
				if(utility.value.equalsIgnoreCase("NDG") || utility.value.equalsIgnoreCase("TSS") )
				{
					String application = "";
					if(utility.value.equalsIgnoreCase("NDG"))
					{
						application="NDG";
					}
					else
					{
						application="TSS";
					}
					if(peak1File.value==null || annotationFile.value==null || outDir.value==null)
					{
						System.out.println("java -jar peakAnnotator.jar -u "+ application +  " <options>\n"+
								"-p,--peakFile - chromosome start and end locations\n"+
								"-a,--annotationFile - could be in BED format downloaded from UCSC table browser or in GTF downloaded from \"http://www.ensembl.org/info/data/ftp/index.html\")>\n"+
								"-o,--outDir \n" +
								"Optional parameters:\n" +
								"-x,--prefix - output files prefix \n" +
								"-s,--symbolFile - necessary only when annotation file is of BED format or GTF that do not contains the \"gene_name\" field \n"+
								"-g,--geneType - \"protein_coding\" or \"all\" valid only if annotation file is of GTF format, default is \"protein_coding\"\n");
						return;
					}
					else 
					{
						if(utility.value.equalsIgnoreCase("TSS"))
						{
							mustStrand.value=false;
						}
						if(annotationFile.value.toLowerCase().contains(".gtf"))
						{
							formatType.value="GTF";
						}
						else
						{
							formatType.value="BED";
						}
						if(geneType.value==null)
						{
							geneType.value="protein_coding";
						}
							PeakAnnotator annotator = new PeakAnnotator();
							annotator.Init(utility.value.toLowerCase(),peak1File.value,annotationFile.value,outDir.value,symbolFile.value,mustStrand.value,formatType.value,geneType.value,prefix.value,chrLengthFile.value,numRandom.value);
						
						if(utility.value.equalsIgnoreCase("NDG"))
						{
							annotator.ClosestDownstreamGenes();
						}
						else
						{
							annotator.ClosestTSS(false);
						}
					}
				}
				else if (utility.value.equalsIgnoreCase("ODS"))
				{
					if(peak1File.value==null || peak2File.value==null || outDir.value==null)
					{
						System.out.println("java -jar peakAnnotator.jar -u ODS <options>\n"+
								"-p,--peakFile - chromosome start and end locations\n"+
								"-p2,--peakFile2 - chromosome start and end locations\n"+
								"-o,--outDir\n" +
								"-x,--prefix - output files prefix\n"+
								"-cs,--chrSizeFile - file indicating chromosome sizes \n"+
								"-r,--numRandomDatasets - number of random datasets to generate when calculating overlap p value (default 1000)\n");
						return;
					}
					else
					{
						mustStrand.value=false;
						formatType.value="BED";
						geneType.value="protein_coding";
						PeakAnnotator annotator = new PeakAnnotator();
						annotator.Init(utility.value.toLowerCase(),peak1File.value,peak2File.value,outDir.value,symbolFile.value,mustStrand.value,formatType.value,geneType.value,prefix.value,chrLengthFile.value,numRandom.value); 
	                    annotator.OverlapPositions();
					}
				}
				else
				{
					System.out.println("Don't recognize "+ utility.value + " utility\n" + parser.getHelpMessage());
				}
			}
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
	}

}
