/*
 *  Build script for iMatix SFL Package, for OS/2.
 *  Requires the iMatix 'c.cmd' script.
 *
 *  Generated by Otto v2.2 from buildsfl.txt on 100/04/01, 16:33:28
 *  For more info see Otto documentation at http://www.imatix.com.
 *  Bug reports & questions to <ewen@imatix.com>
 *  ---------------------------------------------------------------
 */
'@echo off'

/* Configuration options ------------------------------------------ 
 *
 * The actual programs use to compile, compile and archive, and 
 * link programs can be changed by editing the subroutines
 * CompileToObj, CompileToLib, and LinkProgram, at the bottom of
 * this script.  REXX doesn't support variable substitution in
 * the name of the called routine, so they cannot be defined here.
 */

SAY "Building the iMatix Standard Function Library"
SAY "Press [Enter] to continue, or Ctrl-C to abort."
'if .%1==. pause >nul'
SAY "Checking for required files..."

/* require prelude.h */
CALL AssertFileExists 'prelude.h'

/* require sflbits.h  sflbits.c */
CALL AssertFileExists 'sflbits.h'
CALL AssertFileExists 'sflbits.c'

/* require sflhttp.h  sflhttp.c */
CALL AssertFileExists 'sflhttp.h'
CALL AssertFileExists 'sflhttp.c'

/* require sflcomp.h  sflcomp.c */
CALL AssertFileExists 'sflcomp.h'
CALL AssertFileExists 'sflcomp.c'

/* require sflcons.h  sflcons.c */
CALL AssertFileExists 'sflcons.h'
CALL AssertFileExists 'sflcons.c'

/* require sflconv.h  sflcvbs.c  sflcvdp.c  sflcvds.c  sflcvns.c */
CALL AssertFileExists 'sflconv.h'
CALL AssertFileExists 'sflcvbs.c'
CALL AssertFileExists 'sflcvdp.c'
CALL AssertFileExists 'sflcvds.c'
CALL AssertFileExists 'sflcvns.c'

/* require            sflcvsb.c  sflcvsd.c  sflcvsn.c */
CALL AssertFileExists 'sflcvsb.c'
CALL AssertFileExists 'sflcvsd.c'
CALL AssertFileExists 'sflcvsn.c'

/* require            sflcvtp.c  sflcvts.c  sflconv.c */
CALL AssertFileExists 'sflcvtp.c'
CALL AssertFileExists 'sflcvts.c'
CALL AssertFileExists 'sflconv.c'

/* require sflcvst.c  sflcvst.d  sflcvst.i */
CALL AssertFileExists 'sflcvst.c'
CALL AssertFileExists 'sflcvst.d'
CALL AssertFileExists 'sflcvst.i'

/* require sflcryp.h  sflcryp.c */
CALL AssertFileExists 'sflcryp.h'
CALL AssertFileExists 'sflcryp.c'

/* require sfldate.h  sfldate.c */
CALL AssertFileExists 'sfldate.h'
CALL AssertFileExists 'sfldate.c'

/* require sfldbio.h  sfldbio.c */
CALL AssertFileExists 'sfldbio.h'
CALL AssertFileExists 'sfldbio.c'

/* require sfldir.h   sfldir.c */
CALL AssertFileExists 'sfldir.h'
CALL AssertFileExists 'sfldir.c'

/* require sflenv.h   sflenv.c */
CALL AssertFileExists 'sflenv.h'
CALL AssertFileExists 'sflenv.c'

/* require sflexdr.h  sflexdr.c */
CALL AssertFileExists 'sflexdr.h'
CALL AssertFileExists 'sflexdr.c'

/* require sflfile.h  sflfile.c */
CALL AssertFileExists 'sflfile.h'
CALL AssertFileExists 'sflfile.c'

/* require sflfind.h  sflfind.c */
CALL AssertFileExists 'sflfind.h'
CALL AssertFileExists 'sflfind.c'

/* require sflfort.h  sflfort.c */
CALL AssertFileExists 'sflfort.h'
CALL AssertFileExists 'sflfort.c'

/* require sflini.h   sflini.c */
CALL AssertFileExists 'sflini.h'
CALL AssertFileExists 'sflini.c'

/* require sfllang.h  sfllang.c */
CALL AssertFileExists 'sfllang.h'
CALL AssertFileExists 'sfllang.c'

/* require sfllbuf.h  sfllbuf.c */
CALL AssertFileExists 'sfllbuf.h'
CALL AssertFileExists 'sfllbuf.c'

/* require sfllist.h  sfllist.c */
CALL AssertFileExists 'sfllist.h'
CALL AssertFileExists 'sfllist.c'

/* require sflmail.h  sflmail.c */
CALL AssertFileExists 'sflmail.h'
CALL AssertFileExists 'sflmail.c'

/* require sflmath.h  sflmath.c */
CALL AssertFileExists 'sflmath.h'
CALL AssertFileExists 'sflmath.c'

/* require sflmem.h   sflmem.c */
CALL AssertFileExists 'sflmem.h'
CALL AssertFileExists 'sflmem.c'

/* require sflmesg.h  sflmesg.c */
CALL AssertFileExists 'sflmesg.h'
CALL AssertFileExists 'sflmesg.c'

/* require sflmysql.h sflmysql.c */
CALL AssertFileExists 'sflmysql.h'
CALL AssertFileExists 'sflmysql.c'

/* require sflmime.h  sflmime.c */
CALL AssertFileExists 'sflmime.h'
CALL AssertFileExists 'sflmime.c'

/* require sflnode.h  sflnode.c */
CALL AssertFileExists 'sflnode.h'
CALL AssertFileExists 'sflnode.c'

/* require sflproc.h  sflproc.c */
CALL AssertFileExists 'sflproc.h'
CALL AssertFileExists 'sflproc.c'

/* require sflprint.h sflprint.c */
CALL AssertFileExists 'sflprint.h'
CALL AssertFileExists 'sflprint.c'

/* require sflslot.h  sflslot.c */
CALL AssertFileExists 'sflslot.h'
CALL AssertFileExists 'sflslot.c'

/* require sflsock.h  sflsock.c */
CALL AssertFileExists 'sflsock.h'
CALL AssertFileExists 'sflsock.c'

/* require sflstr.h   sflstr.c */
CALL AssertFileExists 'sflstr.h'
CALL AssertFileExists 'sflstr.c'

/* require sflsymb.h  sflsymb.c */
CALL AssertFileExists 'sflsymb.h'
CALL AssertFileExists 'sflsymb.c'

/* require sflsyst.h  sflsyst.c */
CALL AssertFileExists 'sflsyst.h'
CALL AssertFileExists 'sflsyst.c'

/* require sfltok.h   sfltok.c */
CALL AssertFileExists 'sfltok.h'
CALL AssertFileExists 'sfltok.c'

/* require sfltree.h  sfltree.c */
CALL AssertFileExists 'sfltree.h'
CALL AssertFileExists 'sfltree.c'

/* require sfltron.h  sfltron.c */
CALL AssertFileExists 'sfltron.h'
CALL AssertFileExists 'sfltron.c'

/* require sfluid.h   sfluid.c */
CALL AssertFileExists 'sfluid.h'
CALL AssertFileExists 'sfluid.c'

/* require sflxml.h   sflxml.c */
CALL AssertFileExists 'sflxml.h'
CALL AssertFileExists 'sflxml.c'

/* require sflxmll.c  sflxmll.d  sflxmll.i */
CALL AssertFileExists 'sflxmll.c'
CALL AssertFileExists 'sflxmll.d'
CALL AssertFileExists 'sflxmll.i'

/* require testall.c */
CALL AssertFileExists 'testall.c'

/* require testbits.c */
CALL AssertFileExists 'testbits.c'

/* require testcomp.c */
CALL AssertFileExists 'testcomp.c'

/* require testconv.c */
CALL AssertFileExists 'testconv.c'

/* require testcryp.c */
CALL AssertFileExists 'testcryp.c'

/* require testdate.c */
CALL AssertFileExists 'testdate.c'

/* require testdes.c */
CALL AssertFileExists 'testdes.c'

/* require testdir.c */
CALL AssertFileExists 'testdir.c'

/* require testexdr.c */
CALL AssertFileExists 'testexdr.c'

/* require testfind.c */
CALL AssertFileExists 'testfind.c'

/* require testfort.c */
CALL AssertFileExists 'testfort.c'

/* require testmem.c */
CALL AssertFileExists 'testmem.c'

/* require testmime.c */
CALL AssertFileExists 'testmime.c'

/* require teststr.c */
CALL AssertFileExists 'teststr.c'

/* require testsym.c */
CALL AssertFileExists 'testsym.c'

/* require testtree.c */
CALL AssertFileExists 'testtree.c'

/* require testtron.c */
CALL AssertFileExists 'testtron.c'

/* require testuid.c */
CALL AssertFileExists 'testuid.c'

/* require testxml.c */
CALL AssertFileExists 'testxml.c'

/* require testcgi.c */
CALL AssertFileExists 'testcgi.c'

/* delete $lib libsfl */
'if exist libsfl.a del libsfl.a >nul'

/* library libsfl */

/* compile sflbits */
CALL CompileToLib 'sflbits' 'libsfl'

/* compile sflhttp */
CALL CompileToLib 'sflhttp' 'libsfl'

/* compile sflcomp */
CALL CompileToLib 'sflcomp' 'libsfl'

/* compile sflcons */
CALL CompileToLib 'sflcons' 'libsfl'

/* compile sflcryp */
CALL CompileToLib 'sflcryp' 'libsfl'

/* compile sflcvbs sflcvdp sflcvds sflcvns */
CALL CompileToLib 'sflcvbs' 'libsfl'
CALL CompileToLib 'sflcvdp' 'libsfl'
CALL CompileToLib 'sflcvds' 'libsfl'
CALL CompileToLib 'sflcvns' 'libsfl'

/* compile sflcvsb sflcvsd sflcvsn sflcvst */
CALL CompileToLib 'sflcvsb' 'libsfl'
CALL CompileToLib 'sflcvsd' 'libsfl'
CALL CompileToLib 'sflcvsn' 'libsfl'
CALL CompileToLib 'sflcvst' 'libsfl'

/* compile sflcvtp sflcvts sflconv */
CALL CompileToLib 'sflcvtp' 'libsfl'
CALL CompileToLib 'sflcvts' 'libsfl'
CALL CompileToLib 'sflconv' 'libsfl'

/* compile sfldate */
CALL CompileToLib 'sfldate' 'libsfl'

/* compile sfldbio */
CALL CompileToLib 'sfldbio' 'libsfl'

/* compile sfldir */
CALL CompileToLib 'sfldir' 'libsfl'

/* compile sflenv */
CALL CompileToLib 'sflenv' 'libsfl'

/* compile sflexdr */
CALL CompileToLib 'sflexdr' 'libsfl'

/* compile sflfile */
CALL CompileToLib 'sflfile' 'libsfl'

/* compile sflfind */
CALL CompileToLib 'sflfind' 'libsfl'

/* compile sflfort */
CALL CompileToLib 'sflfort' 'libsfl'

/* compile sflini */
CALL CompileToLib 'sflini' 'libsfl'

/* compile sfllang */
CALL CompileToLib 'sfllang' 'libsfl'

/* compile sfllbuf */
CALL CompileToLib 'sfllbuf' 'libsfl'

/* compile sfllist */
CALL CompileToLib 'sfllist' 'libsfl'

/* compile sflmail */
CALL CompileToLib 'sflmail' 'libsfl'

/* compile sflmath */
CALL CompileToLib 'sflmath' 'libsfl'

/* compile sflmem */
CALL CompileToLib 'sflmem' 'libsfl'

/* compile sflmesg */
CALL CompileToLib 'sflmesg' 'libsfl'

/* compile sflmime */
CALL CompileToLib 'sflmime' 'libsfl'

/* compile sflmysql */
CALL CompileToLib 'sflmysql' 'libsfl'

/* compile sflnode */
CALL CompileToLib 'sflnode' 'libsfl'

/* compile sflproc */
CALL CompileToLib 'sflproc' 'libsfl'

/* compile sflprint */
CALL CompileToLib 'sflprint' 'libsfl'

/* compile sflslot */
CALL CompileToLib 'sflslot' 'libsfl'

/* compile sflsock */
CALL CompileToLib 'sflsock' 'libsfl'

/* compile sflstr */
CALL CompileToLib 'sflstr' 'libsfl'

/* compile sflsymb */
CALL CompileToLib 'sflsymb' 'libsfl'

/* compile sflsyst */
CALL CompileToLib 'sflsyst' 'libsfl'

/* compile sfltok */
CALL CompileToLib 'sfltok' 'libsfl'

/* compile sfltree */
CALL CompileToLib 'sfltree' 'libsfl'

/* compile sfltron */
CALL CompileToLib 'sfltron' 'libsfl'

/* compile sfluid */
CALL CompileToLib 'sfluid' 'libsfl'

/* compile sflxml */
CALL CompileToLib 'sflxml' 'libsfl'

/* compile sflxmll */
CALL CompileToLib 'sflxmll' 'libsfl'

/* call buildh */
call buildh.cmd 

/* library */

/* compile testall  testbits testcomp testconv testcryp testdate testdes */
CALL CompileToObj 'testall'
CALL CompileToObj 'testbits'
CALL CompileToObj 'testcomp'
CALL CompileToObj 'testconv'
CALL CompileToObj 'testcryp'
CALL CompileToObj 'testdate'
CALL CompileToObj 'testdes'

/* compile testexdr testfind testmem  testmime testsym  testtree testuid */
CALL CompileToObj 'testexdr'
CALL CompileToObj 'testfind'
CALL CompileToObj 'testmem'
CALL CompileToObj 'testmime'
CALL CompileToObj 'testsym'
CALL CompileToObj 'testtree'
CALL CompileToObj 'testuid'

/* link    testall  testbits testcomp testconv testcryp testdate testdes */
CALL LinkProgram 'testall'
CALL LinkProgram 'testbits'
CALL LinkProgram 'testcomp'
CALL LinkProgram 'testconv'
CALL LinkProgram 'testcryp'
CALL LinkProgram 'testdate'
CALL LinkProgram 'testdes'

/* link    testexdr testfind testmem  testmime testsym  testtree testuid */
CALL LinkProgram 'testexdr'
CALL LinkProgram 'testfind'
CALL LinkProgram 'testmem'
CALL LinkProgram 'testmime'
CALL LinkProgram 'testsym'
CALL LinkProgram 'testtree'
CALL LinkProgram 'testuid'

/* compile testcgi  testdir  teststr  testxml  testtron testfort */
CALL CompileToObj 'testcgi'
CALL CompileToObj 'testdir'
CALL CompileToObj 'teststr'
CALL CompileToObj 'testxml'
CALL CompileToObj 'testtron'
CALL CompileToObj 'testfort'

/* link    testcgi  testdir  teststr  testxml  testtron testfort */
CALL LinkProgram 'testcgi'
CALL LinkProgram 'testdir'
CALL LinkProgram 'teststr'
CALL LinkProgram 'testxml'
CALL LinkProgram 'testtron'
CALL LinkProgram 'testfort'
SAY "SFL built successfully."

exit 0
/* End script */

/* Utility subroutines ---------------------------------------------------- */

/* AssertFileExists <file>
 *
 * Checks to see if the specified file (argument 1) exists.  If it does the
 * subroutine returns.  If it doesn't, the subroutine displays an error
 * message, and exits the whole script.
 */

AssertFileExists:
fullpath = stream(ARG(1), 'C', 'QUERY EXISTS')
IF fullpath = "" THEN
DO
  SAY ARG(1) "missing -- aborting"
  exit 1
END

return

/* CompileToLib <source> <library>
 *
 * This is a stub routine to sort things out for compiling to a library.
 * We need to set CCLIBNAME to the name of the library, then call the 
 * 'c' script, then reset CCLIBNAME.  
 */

CompileToLib:

PARSE ARG SOURCE LIBRARY

oldenv  = VALUE('CCLIBNAME', LIBRARY, 'OS2ENVIRONMENT')
CALL c              SOURCE
CALL c '-r' LIBRARY SOURCE
LIBRARY = VALUE('CCLIBNAME', oldenv,  'OS2ENVIRONMENT')

return

/* CompileToObj <source>
 *
 * This is a stub routine to sort things out for compiling to an object.
 * We need to clear CCLIBNAME, then call c script with the "-c" parameter
 * to indicate compile only, and then reset CCLIBNAME again.
 */

CompileToObj:

SOURCE = ARG(1)

oldenv  = VALUE('CCLIBNAME', '',      'OS2ENVIRONMENT')
CALL c '-c' SOURCE
LIBRARY = VALUE('CCLIBNAME', oldenv,  'OS2ENVIRONMENT')

return

/* LinkProgram <name>
 *
 * This is a stub routine to sort out the things required for linking.
 * We call the c script with the "-L" parameter to link only.
 */

LinkProgram:

PROGRAM = ARG(1)
CALL c '-L' PROGRAM

return

/* End of Utility Subroutines (remaining functionality now in c.cmd) ------ */
