!-------------------------------------------------------------------<Prolog>-
!   Name:       sflxmll.l
!   Title:      Dialog for XML loader function
!   Package:    Standard Function Library (SFL)
!
!   Written:    98/03/15  iMatix SFL project team <sfl@imatix.com>
!   Revised:    99/01/30
!
!   Copyright:  Copyright (c) 1991-99 iMatix Corporation
!   License:    This is free software; you can redistribute it and/or modify
!               it under the terms of the SFL License Agreement as provided
!               in the file LICENSE.TXT.  This software is distributed in
!               the hope that it will be useful, but without any warranty.
!------------------------------------------------------------------</Prolog>-*/

-source=sflxmll

After-Init:
    (--) Ok                                 -> Getting-First-Item
          + Open-XML-File
          + Initialise-XML-Tree
          + Get-Next-Tag-Token

Getting-First-Item:
    (--) Open                               -> Getting-Tag
          + Get-Next-Element-Token

Getting-Item:
    (--) Open                               -> Getting-Tag
          + Get-Next-Element-Token
    (--) Char                               -> Getting-Item
          + Collect-Item-Value
          + Get-Next-Tag-Token

Getting-Tag:
    (--) Name                               -> Getting-Attr
          + Attach-New-Item
          + Get-Next-Element-Token
    (--) Slash                              -> After-Closing-Item
          + Expect-Name
          + Confirm-Item-Name
          + Close-The-Item
          + Expect-Close
          + Check-For-Open-Item
    (--) Processing                         -> Getting-Item
          + Skip-Rest-Of-Processing
          + Get-Next-Tag-Token
    (--) Comment                            -> Getting-Item
          + Skip-Rest-Of-Comment
          + Get-Next-Tag-Token
    (--) Ignore                             -> Getting-Item
          + Skip-Rest-Of-Section
          + Get-Next-Tag-Token

Getting-Attr:
    (--) Name                               -> Getting-Attr
          + Expect-Equals-Token
          + Expect-Literal
          + Attach-New-Attribute
          + Get-Next-Element-Token
    (--) Close                              -> Getting-Item
          + Get-Next-Tag-Token
    (--) Slash                              -> After-Closing-Item
          + Expect-Close
          + Close-The-Item
          + Check-For-Open-Item

After-Closing-Item:
    (--) Ok                                 -> Getting-Item
          + Get-Next-Tag-Token
    (--) No-Items
          + Expect-End-Of-File
          + Close-XML-File
          + Return-Success-Feedback
          + Terminate-The-Program

Defaults:
    (--) Error                              ->
          + Close-XML-File
          + Free-Partial-XML-Tree
          + Return-Error-Feedback
          + Terminate-The-Program
    (--) End-Of-File                        ->
          + Unexpected-Token-Error
    (--) $other                             ->
          + Unexpected-Token-Error
