#include "BedGraphParser.h"



BedGraphParser::~BedGraphParser(void)
{
}

BedGraphParser::BedGraphParser(ifstream* bufReader, int position):Parser(bufReader,"BED")
{
	m_CurPosition = position;
	m_ResetPoint = m_CurPosition;
	string line;
	getline(*m_bufRead, line, '\n');
	m_CurPosition += line.size() + NEWLINE_LEN;
	vector<string> myelements;
	Parser::Tokenize(line, myelements, " \t");

    if(myelements.size() !=4) {
    	throw ("Invalid BedGraph file format");
    }

    //return to be before the first line of signal
    m_bufRead->seekg(m_ResetPoint);
	m_CurPosition = m_ResetPoint;
}

	//create hash tables,  hold base_index as key and tag number as value

wigPosition* BedGraphParser::nextPosition()
{
	m_ResetPoint = m_CurPosition;
	string line;
	getline(*m_bufRead, line, '\n');
	m_CurPosition += line.size() + NEWLINE_LEN;
	if(line.empty())
		return NULL;
	vector<string> myelements;
	Parser::Tokenize(line, myelements, " \t");
	string chr = myelements[0];
	int start = Parser::AtoI(myelements[1]);
	int end = Parser::AtoI(myelements[2]);
	float score = Parser::AtoF(myelements[3]);
	wigPosition* pos = new wigPosition(chr,start,end,score);
	return pos;
}
