#include "PeakParser.h"
#include "Parser.h";


PeakParser::~PeakParser(void)
{
}


PeakParser::PeakParser(ifstream* file)
{

        /*      Sets up a file reader to read the file passed on the command
                line one character at a time */

        /* Filter FileReader through a Buffered read to read a line at a
           time */

        m_bufRead = file;
        long firstPeak = file->tellg();
        long offset = 0;
        // Read first line
        string line;
		getline(*m_bufRead, line, '\n');
        //check if first line starts with the word track
        if((int)line.find("track") >= 0)
		{
        	firstPeak = m_bufRead->tellg();
        }
        vector<string> myelements;
		Parser::Tokenize(line, myelements, " \t");

        if(myelements.size() < 3)
		{
        	throw ("Invalid peak file format");
        }
        else
		{
        	while(!line.empty())
			{
				vector<string> tokens;
        		Parser::Tokenize(line, tokens, " \t");
        		if(m_chrInFile[tokens[0]] != NULL)
				{
        			m_chrInFile[tokens[0]] = offset;
        		}
        		offset = m_bufRead->tellg();
        		getline(*m_bufRead, line, '\n');
        	}
        }

        //go to the start of the file (must clear the EOF flag first)
		m_bufRead->clear();
        m_bufRead->seekg(0);
        current = NULL;
}

Position* PeakParser::nextPosition()
{
	string line;
	getline(*m_bufRead, line, '\n');
	if(line.empty())
	{
		return NULL;
	}
	else
	{
		vector<string> myelements;
		Parser::Tokenize(line, myelements, " \t");

        string chr = myelements[0];
		int start = Parser::AtoI(myelements[1]);
        int end = Parser::AtoI(myelements[2]);
        Position* g = new Position(start,end,chr);
        current = g;
        return g;
	}
}

Position* PeakParser::getCur()
{
	return current;
}
void PeakParser::moveToChr(string chr)
{
	m_bufRead->seekg(m_chrInFile[chr]);
}
