#include "variableStepParser.h"
#include <cmath>


VariableStepParser::~VariableStepParser(void)
{
}

VariableStepParser::VariableStepParser(ifstream* reader, int position, string chr):Parser(reader,"WIG")
{
	m_CurPosition = position;
	m_space = 1;
	m_ResetPoint = m_CurPosition;
	string line;
	getline(*m_bufRead, line, '\n');
	m_CurPosition += line.size() + NEWLINE_LEN;

	string upperCaseLine = Parser::ToUpper(line);
	if((int)upperCaseLine.find("VARIABLESTEP") >= 0)
	{
		vector<string> myelements;
		Parser::Tokenize(line, myelements, " \t");
		m_space=1;
		for(int i=0;i<myelements.size();i++)
		{
			vector<string> tokens;
			Parser::Tokenize(line, tokens, "=");
			string uppercaseToken = Parser::ToUpper(myelements[i]);
			if((int)uppercaseToken.find("CHROM") >= 0)
			{
				Parser::Tokenize(myelements[i], tokens, "=");
				m_chr = tokens[1];
			}
			else if((int)uppercaseToken.find("SPAN") >=0)
			{
				Parser::Tokenize(myelements[i], tokens, "=");
				m_space = Parser::AtoI(tokens[1]);
			}
		}
		m_ResetPoint = m_CurPosition;
	}
	getline(*m_bufRead, line, '\n');
	m_CurPosition += line.size() + NEWLINE_LEN;
	vector<string> myelements;
	Parser::Tokenize(line, myelements, " \t");
    if(myelements.size() !=2) {
    	throw ("Invalid wig file format");
    }

    int signal = Parser::AtoI(myelements[0]);
    m_sigDigit=signal%10;

    //return to be before the first line of signal
	m_CurPosition = m_ResetPoint;

	getline(*m_bufRead, line, '\n');

	if(m_chr.empty())
	{
		m_chr = chr;
	}
}


//create hash tables,  hold base_index as key and tag number as value
wigPosition* VariableStepParser::nextPosition ()
{
	m_ResetPoint = m_CurPosition;
	string line;
	getline(*m_bufRead, line, '\n');
	m_CurPosition += line.size() + NEWLINE_LEN;
	if(line.empty())
	{
		return NULL;
	}
	wigPosition* pos=NULL;
	vector<string> myelements;
	Parser::Tokenize(line, myelements, " \t");

	if((int)line.find("chrom")>=0)
	{
		//this is a chromosome defenition line
		m_space=1;
		for(int i=0;i<myelements.size();i++)
		{
			string uppercaseToken = Parser::ToUpper(myelements[i]);
			if((int)uppercaseToken.find("CHROM") >= 0)
			{
				vector<string> tokens;
				Parser::Tokenize(myelements[i], tokens, "=");
				m_chr = tokens[1];
			}
			else if((int)uppercaseToken.find("SPAN") >= 0)
			{
				vector<string> tokens;
				Parser::Tokenize(myelements[i], tokens, "=");
				m_space = Parser::AtoI(tokens[1]);
			}
		}
		getline(*m_bufRead, line, '\n');
		m_CurPosition += line.size() + NEWLINE_LEN;
		Parser::Tokenize(line, myelements, " \t");
	}
	int start = 0;
	try
	{
		start = Parser::AtoI(myelements[0]);
	}
	catch(string& str)
	{
		string err = "the first field should be an integer in line " + line + "\n";
		throw err;
	}
	int end = start + m_space-1;
	float score = Parser::AtoF(myelements[1]);
	pos = new wigPosition(m_chr,start,end,score);
	return pos;
}

int VariableStepParser::getDigit()
{
	return m_sigDigit;
}
