<?php

/***************************************************************************
                    xhtml_base.inc  -
         base object to navigate in an xhtml document
                           -------------------
  begin                :  19/01/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

/* xhtml_base interface
xhtml_base() //constructor

get_xhtml_doc() // get xml document pointer
get_current_node() // get pointer to the current xml node in the document

// methods to produce xhtml code:
xhtml_hr($class=-1)
xhtml_br($class=-1)
xhtml_header($title, $level = 0, $class = -1)
// produce an "ul" list from the array
xhtml_ul($array, $class=-1, $parameters=array())
// insert a "div" section containing the given text at the current node
xhtml_message($text, $class=-1)
// same as xhtml_message, but with explicit "div" tag
xhtml_insert_div($html_text, $class=-1)
// insert a "span" section containing the given text
 xhtml_insert_span($html_text, $class=-1)
// insert any xhtml tag the user want in the document, at the current node or the given node
// beware that the $html_text have to be a well formed node
xhtml_insert($html_text, $insert_node = -1)
*/

//modified by Olivier Langella 07/06/2004 to add xhtml_header

class xhtml_base {
	var $_xhtmldoc;
	var $_xpath;
	var $_currentnode;

	function xhtml_base() {
		$this -> _lock_zone = false;
	}

	function get_xhtml_doc() {
		return $this -> _xhtmldoc;
	}

	function get_current_node() {
		return $this -> _currentnode;
	}

	function priv_no_amp($text) {
		//return(str_replace("& ","&amp;",$text));
	}

	function xhtml_hr($class = -1) {
		$node = $this -> _xhtmldoc -> create_element("hr");
		if ($class != -1)
			$node -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($node);
	}

	function xhtml_header($title, $level = 0, $class = -1) {
		$node = $this -> _xhtmldoc -> create_element("h".$level);
		if ($class != -1)
			$node -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($node);
		$this -> priv_xhtml_insert(utf8_encode($title), $node);
	}

	function xhtml_br($class = -1) {
		$node = $this -> _xhtmldoc -> create_element("br");
		if ($class != -1)
			$node -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($node);
	}

	function xhtml_ul($array, $class = -1, $parameters = array()) {

		$ul = $this -> _xhtmldoc -> create_element("ul");
		if ($class != -1)
			$ul -> set_attribute("class", $class);
		$current = -1;
		if (array_key_exists("current", $parameters))
			$current = $parameters["current"];
		//$this->xhtml_message($current);
		if (is_array($array)) {
			reset($array);
			while (list ($i, $content) = each($array)) {
				//for ($i = 0; $i < count($array); $i++){
				// if ($array[$i] != "") {
				if ($content != "") {
					$li = $this -> _xhtmldoc -> create_element("li");
					//$this->xhtml_insert($array[$i],$li);
					$this -> priv_xhtml_insert(utf8_encode($content), $li);
					if (strpos($content, $current) == true) {
						$li -> set_attribute("class", "current");

					}
					$ul -> append_child($li);
				}
			}
		}
		//$this->xhtml_insert();

		$this -> _currentnode -> append_child($ul);
	}

	function new_li($class = -1) {
		$li = $this -> _xhtmldoc -> create_element("li");
		if ($class != -1)
			$li -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($li);
		$this -> _currentnode = $li;
	}

	function xhtml_message($text, $class = -1) {
		$this -> xhtml_insert_div($text, $class);
	}

	function xhtml_insert_div($html_text, $class = -1) {
			// insert $html_div in the current node
		//$dom = domxml_new_doc("1.0");

	$div = $this -> _xhtmldoc -> create_element("div");
		if ($class != -1) {
			$div -> set_attribute("class", $class);

		}

		if (!is_object($this -> _currentnode)) {
			echo ("ERROR: the field ".$html_text." is not consistent (xhtml_base object).");
			echo ("please contact the administrator");
			exit;
		}

		$this -> _currentnode -> append_child($div);

		$this -> priv_xhtml_insert(utf8_encode($html_text), $div);
		// $this->priv_xhtml_insert($html_text);
	}

	function xhtml_insert_span($html_text, $class = -1) {
			// insert $html_div in the current node
		//$dom = domxml_new_doc("1.0");
	$div = $this -> _xhtmldoc -> create_element("span");
		if ($class != -1) {
			$div -> set_attribute("class", $class);

		}
		$this -> _currentnode -> append_child($div);

		$this -> priv_xhtml_insert(utf8_encode($html_text), $div);
	}

	function xhtml_insert_tag($tag, $html_text, $class = -1) {
		$div = $this -> _xhtmldoc -> create_element($tag);
		if ($class != -1) {
			$div -> set_attribute("class", $class);

		}
		$this -> _currentnode -> append_child($div);

		$this -> priv_xhtml_insert(utf8_encode($html_text), $div);
	}

	function priv_xhtml_insert($html_text, $insert_node = -1) {
			// insert $html_div in the current node
		//echo "<pre>".$html_text."</pre>";
		//echo 	$html_text;	
	if ($insert_node == -1) {
			$insert_node = $this -> _currentnode;
		}
		$html_text = str_replace("<", "0(0", $html_text);
		$html_text = str_replace(">", "0)0", $html_text);
		$html_text = str_replace("\"", "0dquote0", $html_text);
		$html_text = str_replace("?", "0euh0", $html_text);
		$html_text = str_replace("&", "0and0", $html_text);

		$insert_node -> set_content($html_text);
		//$insert_node->set_content(htmlentities($html_text));
		//$insert_node->set_content($html_text);
		/*
		$dom = domxml_new_doc("1.0");
		if(!$dom = domxml_open_mem(utf8_encode($this->priv_no_amp($html_text)))) {
		//if(!$dom = domxml_open_mem($this->priv_no_amp($html_text))) {
		echo "Error in the object xhmtl_page to insert_div\n";
		echo $html_text."\n";
		exit;
		}
		//$this->_currentnode->append_child($this->_xhtmldoc->create_element("div"));
		$node = $this->_xhtmldoc->create_element("div");
		$insert_node->append_child($node);
		
		
		$node->append_sibling($dom->document_element());
		$node->unlink_node();
		*/
	}

}
?>