<?php

/***************************************************************************
                      xhtml_form.inc  -
           classe de base pour la construction de formulaire HTML
           inspiré du livre MySql PHP, O'Reilly, de Philippe Rigaud
                             -------------------
    begin                :  13/01/2004
    copyright            : (C) 2004 by Olivier Langella
    email                : langella@moulon.inra.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

// this object is inspired from the Philippe Rigaud's work: PHP & MySql, O'Reilly

/* xhtml_form object interface:
//constructor, parameters: xml document, current node, form name
xhtml_form($xhtmldoc, $node, $pname)
// set the basics attributes required for an xhtml form:
// method post or get, action: URL to submit form content
xhtml_form_set($pmethod, $paction, $pclass = "xhtml_form")

// methods to control layout of the form
// to display form field as text, no input box, no submit button: set_const(true)
set_const($is_const)
// to display the fields in a vertical table:
set_display_vtable()
// to display the fields in an horizontal table:
set_display_htable($line_number=1)
// to display the fields freely, without container by default, 
// but the user can set $free_mode to "div" or "span" to contain the fields.
set_display_free($free_mode="")

// this method assigns an array containing field name with values to the form.
set_lazy_mode($tab_values)

//methods to produce xhtml code specific to forms
// set a correct "enctype" attribute to upload files
set_file_transfer ($file_transfer=true)
// display fields in an elegant "fieldset" tag
new_zone_fieldset($name, $legend, $class=-1)
// submit image button
input_submit_image ( $src, $alt, $pclass=-1)
// display a select list
input_select($ptag,$pname, $pdefault, $plist_val ,   $pclass=-1)
// submit button with a title in $pval
input_submit ($pval,$pclass=-1)
// button to reset form with a title in $pval
input_reset ($pval,$pclass=-1)
// text field
input_text ($ptag, $pname, $pval, $psize=10, $pmaxlength=-1, $pclass=-1)
// text to display only
input_message ($ptag, $pname, $pval, $pclass=-1)
// hidden field
input_hidden ($pname, $pval, $pclass=-1)
// button to browse file locally for an upload
input_file ($ptag, $pname, $pval, $psize=10, $pmaxlength=-1, $pclass=-1)
// password field
input_password ($ptag, $pname, $pval, $psize=10, $pmaxlength=-1, $pclass=-1)
// free input in a wide textarea
input_textarea ($ptag, $pname, $pval, $row, $cols, $pclass=-1)
// checkbox
input_checkbox ($ptag, $pname, $pval,  $pcheck, $pclass=-1)

//Check input:
//add a piece of javascript code to control if the given field is filled
// display the alert message if not, and doesn't validate the form
add_check_fill($field_name, $alert_message)
// add a special link to post the current form and go the the URL:
add_post_link($url, $text)

*/

class xhtml_form extends xhtml_zone {
	// var $_xhtmldoc;
	var $_form;
	// var $_currentnode;
	var $_table_mode;
	var $_free_mode;
	var $_free_mode_class;
	var $_svg_node;
	var $_const;
	var $_i_lines;
	//var $_name;
	var $_title_row;
	var $_tab_value_row;
	var $_radio_number;
	var $_tab_values;
	var $_table_zones;

	function xhtml_form($xhtmldoc, $node, $pname) {
		$this -> _xhtmldoc = $xhtmldoc;
		$this -> _form = $this -> _xhtmldoc -> create_element("form");
		$node -> append_child($this -> _form);
		$this -> _currentnode = $this -> _form;
		$this -> _form -> set_attribute("id", $pname);
		//$this->_form->set_attribute("name",$pname);
		$this -> _tab_nodes[$this -> priv_get_unique_id("form")] = $this -> _form;
		$this -> _const = false;
		$this -> _table_mode = "";
		$this -> _free_mode = "";
		//$this->_form->set_attribute("id",$pname);
		$this -> _radio_number = 0;
		$this -> _tab_values = array();
		$this -> _tab_values_row = array();

		$this -> new_zone_div("ground0");

		//$this->_table_zones = array("table"=>-1, "thead"=>-1, "tbody"=>-1,"trh"=>-1, "trb"=>-1);

		//$this->_form->set_attribute("name",$pname);
		//$this->_xpath = 
	}

	function xhtml_form_set($pmethod, $paction, $pclass = "xhtml_form") {

		$this -> _form -> set_attribute("method", strtolower($pmethod));
		$this -> _form -> set_attribute("class", $pclass);
		$this -> _form -> set_attribute("action", $paction);
		// $this->_form->set_attribute("onsubmit","return check_input_" . $_pname."(this)");

		$this -> _i_lines = 0;

	}

	function new_zone_fieldset($name, $legend, $class = -1) {
		$this -> priv_new_zone("fieldset", $name, $class = -1);
		$node = $this -> _xhtmldoc -> create_element("legend");
		$node -> set_content($legend);
		$this -> _currentnode -> append_child($node);
	}

	function set_file_transfer($file_transfer = true) {
		if ($file_transfer)
			$this -> _form -> set_attribute("enctype", "multipart/form-data");
	}

	function set_const($is_const) {
		$this -> _const = $is_const;
	}

	function set_lazy_mode($tab_values) {
		//please let cut/paste for the others... use the lazy mode:
		// just use this method once to set the associative array containing
		// field name and correspondant values
		//then use input methods with only field name... the value will be automatically filled
		if (is_array($tab_values))
			$this -> _tab_values = $tab_values;
		else {
			$this -> xhtml_message("ERROR in xhtml_form object: the argument passed to set_lazy_mode is not an array", "error");
		}
	}

	function set_display_vtable($class = -1) {
		if ($this -> _table_mode != "")
			$this -> _currentnode = $this -> _svg_node;
		$table = $this -> _xhtmldoc -> create_element("table");
		if ($class != -1)
			$table -> set_attribute("class", $class);
		$tbody = $this -> _xhtmldoc -> create_element("tbody");
		$table -> append_child($tbody);

		$this -> _currentnode -> append_child($table);
		$this -> _svg_node = $this -> _currentnode;
		$this -> _currentnode = $tbody;
		$this -> _table_mode = "VERTICAL";
		$this -> _lock_zone = true;
	}

	function set_display_htable($line_number = 1) {
			//$this->_tab_values = array();
	$this -> _tab_values_row = array();
		if ($this -> _table_mode != "")
			$this -> _currentnode = $this -> _svg_node;
		$this -> _table_mode = "HORIZONTAL";

		if ($line_number == 0) {
			return;
		}

		$table = $this -> _xhtmldoc -> create_element("table");
		$this -> _currentnode -> append_child($table);
		$this -> _svg_node = $this -> _currentnode;
		$this -> _currentnode = $table;
		//$this->_table_mode = "HORIZONTAL";
		$this -> _lock_zone = true;

		$thead = $this -> _xhtmldoc -> create_element("thead");
		$this -> _title_row = $this -> _xhtmldoc -> create_element("tr");
		$thead -> append_child($this -> _title_row);
		$table -> append_child($thead);

		$tbody = $this -> _xhtmldoc -> create_element("tbody");
		$table -> append_child($tbody);
		for ($i = 0; $i < $line_number; $i ++) {
			$this -> _tab_value_row[$i] = $this -> _xhtmldoc -> create_element("tr");
			$tbody -> append_child($this -> _tab_value_row[$i]);
		}

	}

	function add_check_fill($field_name, $alert_message) {
		$field_name = "form.".$this -> priv_get_unique_id($field_name);
		//$field_name = "form.".$field_name;
		//$javascript = " alert(\"".$alert_message."\");\n";

		$javascript = "if(".$field_name.".value != \"\") {\n";
		//      $javascript .= " alert(\"".$alert_message."\");\n";
		//$javascript .= " return true;\n";
		$javascript.= "}\n";
		$javascript.= "else {\n";
		$javascript.= " ".$field_name.".focus();\n";
		$javascript.= " alert(\"".$alert_message."\");\n";
		$javascript.= " return false;\n";
		$javascript.= "}\n";

		$this -> priv_add_check_javascript($javascript);
	}

	// add a special link to post the current form and go the the URL:
	function add_post_link($name, $text, $param = array()) {
		$a = $this -> _xhtmldoc -> create_element("div");
		$a -> set_content($text);
		$a -> set_attribute("class", "superlink");
		$a -> set_attribute("onclick", "");
		$this -> _currentnode -> append_child($a);

		$javascript_function_name = $this -> priv_get_unique_id($name);
		$a -> set_attribute("onclick", $javascript_function_name."()");
		$this -> priv_javascript_post_button_code($javascript_function_name, $param);

	}
	// add a special button to post the current form and go the the URL:
	function add_post_button($name, $text, $class = "-1", $param = array()) {
			//$button->set_attribute("onclick",$javascript_function_name."()");

	$javascript_function_name = $this -> priv_get_unique_id($name);
		$this -> priv_input(-1, -1, $text, $ptype = "button", array("class" => $class, "onclick" => $javascript_function_name."()"));
		$this -> priv_javascript_post_button_code($javascript_function_name, $param);

	}

	function priv_javascript_post_button_code($unique_function_name, $param) {
		//JAVASCRIPT CODE
		$javascript_code = "\nfunction ".$unique_function_name." () {\n";
		$javascript_code.= "var form=document.forms['".$this -> _form -> get_attribute("id")."'];\n";
		reset($param);
		while (list ($key, $val) = each($param)) {
			$javascript_code.= "form.elements['".$this -> priv_get_unique_id($key)."'].value = \"".$val."\";\n";
		}
		$javascript_code.= "form.submit();\n";
		$javascript_code.= " return true;\n";
		$javascript_code.= "}\n";
		$this -> priv_add_javascript($javascript_code);
	}

	function goto_zone($name) {
		//set the current node to the zone "name"
		$this -> _table_mode = "";
		$this -> _lock_zone = false;
		$this -> priv_goto_zone($name);
	}

	function set_display_free($free_mode = "", $class = -1) {
		if ($this -> _table_mode != "")
			$this -> _currentnode = $this -> _svg_node;
		$this -> _table_mode = "";
		$this -> _free_mode = $free_mode;
		$this -> _free_mode_class = $class;
		$this -> _lock_zone = false;
	}

	function input_textarea($ptag, $pname, $pval, $rows, $cols, $pclass = -1) {
		$parameters["class"] = $pclass;
		$parameters["rows"] = $rows;
		$parameters["cols"] = $cols;
		$this -> priv_input($ptag, $pname, $pval, "textarea", $parameters);
	}

	function input_select($ptag, $pname, $pdefault, $plist_val, $parameters = array()) {
		if (!is_array($parameters)) {
			$class = $parameters;
			$parameters = array();

			$parameters["class"] = $class;
		}
		if (!array_key_exists("class", $parameters))
			$parameters["class"] = -1;
		if (!array_key_exists("size", $parameters))
			$parameters["size"] = -1;
		//      $parameters["class"] = $pclass;
		if (count($plist_val) == 0)
			$plist_val = array("" => "");
		reset($plist_val);
		$this -> priv_input($ptag, $pname, $pdefault, "select", $parameters, $plist_val);
	}

	function input_submit_image($src, $alt, $pclass = -1) {
		$this -> priv_input(-1, $src, $alt, $ptype = "image", array("class" => $pclass));
	}

	function input_submit($pval, $pclass = -1) {
		$this -> priv_input(-1, -1, $pval, $ptype = "submit", array("class" => $pclass));
	}

	function input_reset($pval, $pclass = -1) {
		$this -> priv_input(-1, -1, $pval, $ptype = "reset", array("class" => $pclass));
	}

	function input_radio($ptag, $pname, $pval, $pcheck, $pclass = -1) {
			//pval is an array: display vertical array 
		// to have a unique ID:
	$parameters["check"] = $pcheck;
		$parameters["class"] = $pclass;
		$parameters["id"] = $this -> priv_get_unique_id($pname).$this -> _radio_number;
		$this -> _radio_number++;
		$this -> priv_input($ptag, $pname, $pval, "radio", $parameters);
	}

	function input_checkbox($ptag, $pname, $pval, $pcheck, $pclass = -1) {
			//pval is an array: display vertical array 
	$parameters["check"] = $pcheck;
		$parameters["class"] = $pclass;
		//if ($pval == "") $pval = "OK";
		$this -> priv_input($ptag, $pname, $pval, "checkbox", $parameters);
	}

	function input_text($ptag, $pname, $pval, $psize = 10, $pmaxlength = -1, $pclass = -1) {
		$this -> priv_input($ptag, $pname, $pval, "text", array("class" => $pclass, "size" => $psize, "maxlength" => $pmaxlength));
	}

	function input_message($ptag, $pname, $pval, $pclass = -1) {
		$this -> priv_input($ptag, $pname, $pval, "message", array("class" => $pclass));
	}

	function input_hidden($pname, $pval, $pclass = -1) {
		$this -> priv_input(-1, $pname, $pval, "hidden", array("class" => $pclass, "size" => -1, "maxlength" => -1));
	}

	function input_file($ptag, $pname, $pval, $psize = 10, $pmaxlength = -1, $pclass = -1) {
		$this -> priv_input($ptag, $pname, $pval, "file", array("class" => $pclass, "size" => $psize, "maxlength" => $pmaxlength));
	}

	function input_password($ptag, $pname, $pval, $psize = 10, $pmaxlength = -1, $pclass = -1) {
		$this -> priv_input($ptag, $pname, $pval, "password", array("class" => $pclass, "size" => $psize, "maxlength" => $pmaxlength));
	}

	function priv_input($ptag, $pname, $pval, $ptype = "text", $parameters = array(), $plist = array()) {

		if ($this -> _table_mode == "HORIZONTAL") {
			if (count($this -> _tab_value_row) < 1) {
				return;
			}
			// lazy mode: $pval takes precedence
			$temp = str_replace("[]", "", $pname);
			if (($pval == "") & (array_key_exists($temp, $this -> _tab_values)))
				$pval = $this -> _tab_values[$temp];
		}

		// lazy mode: $pval takes precedence
		if (($pval == "") & (array_key_exists($pname, $this -> _tab_values)))
			$pval = $this -> _tab_values[$pname];
		//encodage en UTF8
		$ptag = utf8_encode($ptag);
		if (!is_array($pval))
			$pval = utf8_encode($pval);
		//création du champ
		if (!array_key_exists("class", $parameters))
			$parameters["class"] = -1;
		$pclass = $parameters["class"];
		$node = $this -> _currentnode;

		if (!is_array($pval))
			$field_node = $this -> priv_create_node($ptype, $pname, $pval, $parameters, $plist, $pclass);

		// label creation
		if ($ptag == -1)
			$tag_node = false;
		else {
			$tag_node = $this -> _xhtmldoc -> create_element("label");
			if ($ptype != "radio")
				$tag_node -> set_attribute("for", $this -> priv_get_unique_id($pname));
			else
				$tag_node -> set_attribute("for", $parameters["id"]);
			if ($ptag != "")
				$tag_node -> set_content($ptag);
		}

		//$this->xhtml_message("coucouV");
		//affichage du champ en tenant compte de la présentation
		if ($this -> _table_mode != "") {
			if ($this -> _table_mode == "VERTICAL") {

				//nouvelle ligne, avec libellé et champ dans deux cellules
				$row = $this -> _xhtmldoc -> create_element("tr");
				$node -> append_child($row);
				$cell = $this -> _xhtmldoc -> create_element("td");
				if ($ptag != -1)
					$cell -> append_child($tag_node);
				$row -> append_child($cell);

				$cell = $this -> _xhtmldoc -> create_element("td");
				$cell -> append_child($field_node);
				$row -> append_child($cell);

			} else {
				if (count($this -> _tab_value_row) < 1) {
					return;
				}

				$th = $this -> _xhtmldoc -> create_element("th");
				if ($pname != -1) {
					if ($tag_node == false)
						$tag_node = $this -> _xhtmldoc -> create_element("label");
					$tag_node -> set_attribute("for", $this -> priv_get_unique_id(str_replace("[]", "0", $pname)));
					$th -> append_child($tag_node);
					$this -> _title_row -> append_child($th);
				}
				if (!is_array($pval)) {
					$td = $this -> _xhtmldoc -> create_element("td");
					$td -> append_child($field_node);
					$this -> _tab_value_row[0] -> append_child($td);
				} else {
					for ($i = 0; $i < count($pval); $i ++) {
						if ($i >= count($this -> _tab_value_row)) {
							$this -> xhtml_message("ERROR: the field ".$pname." is not consistent. Not enough rows declared, contact the administrator (in the object xhtml_form)", "error");
							$this -> xhtml_message("i = ".$i.", max value = ".count($this -> _tab_value_row), "error");
							$this -> xhtml_message("table of values to display: ".serialize($pval), "error");
							return;
						}

						$td = $this -> _xhtmldoc -> create_element("td");
						$parameters["id"] = $this -> priv_get_unique_id(str_replace("[]", $i, $pname));
						if ($ptype == "checkbox") {
							$tmp_val = "-1";
							if ($parameters["check"] == $pval[$i]) {
								// echo $parameters["check"]."/". $pval[$i]."]";
								$tmp_val = $i;
							}
							//$parameters["check"] = $i;
							$td -> append_child($this -> priv_create_node($ptype, $pname, $tmp_val, array("id" => $parameters["id"], "check" => $i), $plist, $pclass));
						} else {
							$td -> append_child($this -> priv_create_node($ptype, $pname, utf8_encode($pval[$i]), $parameters, $plist, $pclass));
						}
						$this -> _tab_value_row[$i] -> append_child($td);

					}
				}
			}
		} else {
			//free mode display (without table)
			if (($ptype != "hidden") & ($this -> _free_mode != "")) {
				$container = $this -> _xhtmldoc -> create_element($this -> _free_mode);
				if ($this -> _free_mode_class != -1) {
					$container -> set_attribute("class", $this -> _free_mode_class);
					$contain_field = $this -> _xhtmldoc -> create_element("span");
					$contain_field -> append_child($field_node);
					$field_node = $contain_field;
					if ($tag_node == false) {
						$contain_tag = $this -> _xhtmldoc -> create_element("span");
						$contain_tag -> set_content(" ");
						$tag_node = $contain_tag;
					}

				}

				if (!is_object($node)) {
					echo ("ERROR: the field ".$pname.", value :".serialize($pval)." is not consistent (xhtml_form object).");
					echo ("please contact the administrator");
					exit;
				}

				$node -> append_child($container);
				$node = $container;

			}
			if ($tag_node != false) {
				$node -> append_child($tag_node);
				//$node = $tag_node;
			}
			$node -> append_child($field_node);
		}

	}

	function priv_create_node($ptype, $pname, $pval, $parameters, $plist, $pclass) {
		//      if (!array_key_exists("class", $parameters)) $parameters["class"] = "";
		if (!array_key_exists("size", $parameters))
			$parameters["size"] = -1;
		if (!array_key_exists("maxlength", $parameters))
			$parameters["maxlength"] = -1;
		if (!array_key_exists("onclick", $parameters))
			$parameters["onclick"] = -1;
		if (array_key_exists("id", $parameters))
			$id = $parameters["id"];
		else
			$id = $this -> priv_get_unique_id($pname);

		switch ($ptype) { //on traite les cas des differents types

			case "text" :
			case "password" :
			case "reset" :
			case "file" :
			case "hidden" :
			case "submit" :
			case "image" :
			case "button" :
				$size = $parameters["size"];
				$maxlength = $parameters["maxlength"];
				$onclick = $parameters["onclick"];
				if ($maxlength == 0)
					$maxlength = $size;
				$class = $parameters["class"];
				$new_node = $this -> priv_create_node_input($id, $ptype, $pname, $pval, $pclass, $size, $maxlength, $onclick);
				break;

			case "textarea" :
				$rows = $parameters["rows"];
				$cols = $parameters["cols"];
				$class = $parameters["class"];
				$new_node = $this -> priv_create_node_textarea($id, $pname, $pval, $rows, $cols, $class);
				break;

			case "affichage" :
				$balise = $parametres["balise"];
				$classe = $parametres["class"];
				$_champs = $this -> champ_prive_affichage($pval, $balise, $classe);
				break;

			case "select" :
				//$this->xhtml_message("coucou");
				//$size = $parameters["size"];
				//$pclass = $parameters["class"];
				// if ($parameters[])
				$new_node = $this -> priv_create_node_select($id, $pname, $plist, $pval, $parameters);
				break;

			case "checkbox" :
			case "radio" :
				$new_node = $this -> priv_create_node_input_checkbox($id, $ptype, $pname, $pval, $pclass, $parameters);
				break;

			case "message" :
				$new_node = $this -> priv_create_node_message($id, $pname, $pval, $pclass, $parameters);
				break;

			default :
				echo html_message("erreur : $ptype est un type inconnu", "erreur");
				break;
		}
		return $new_node;
	}

	function priv_create_node_message($id, $pname, $pval, $pclass, $parameters) {
		$node = $this -> _xhtmldoc -> create_element("span");
		$node -> set_attribute("id", $id);
		if ($pclass != -1)
			$node -> set_attribute("class", $pclass);
		$this -> priv_xhtml_insert($pval, $node);
		return $node;
	}

	function priv_create_node_textarea($id, $pname, $pval, $rows, $cols, $pclass) {
		$pval = str_replace("&", "&#038;", $pval);

		if ($this -> _const == true) {
			$node = $this -> _xhtmldoc -> create_element("span");
			if ($pval != "")
				$node -> set_content($pval);
		} else {
			$node = $this -> _xhtmldoc -> create_element("textarea");
			$node -> set_content($pval);
			$node -> set_attribute("id", $this -> priv_get_unique_id($pname));
			$node -> set_attribute("name", $pname);
			$node -> set_attribute("rows", $rows);
			$node -> set_attribute("cols", $cols);
			if ($pclass != -1)
				$node -> set_attribute("class", $pclass);
		}
		return $node;
	}

	function priv_create_node_select($id, $pname, $plist, $pdefault, $parameters) {
		if ($this -> _const == true) {
			$node = $this -> _xhtmldoc -> create_element("span");
			$node -> set_content($pdefault);
		} else {
			$node = $this -> _xhtmldoc -> create_element("select");
			//$node->set_content($pdefault);
			$node -> set_attribute("name", $pname);
			$node -> set_attribute("id", $id);
			if ($parameters["size"] != -1)
				$node -> set_attribute("size", $parameters["size"]);
			if ($parameters["class"] != -1)
				$node -> set_attribute("class", $parameters["class"]);

			$this -> priv_create_node_select_options($node, $plist, $pdefault);

		}
		return $node;
	}

	function priv_create_node_select_options($node, $plist, $pdefault) {
		while (list ($tag, $val) = each($plist)) {
			if (is_array($val)) {
				if (count($val)) {
					$option = $this -> _xhtmldoc -> create_element("optgroup");
					$option -> set_attribute("label", utf8_encode($tag));
					//  $node->append_child($option);
					$this -> priv_create_node_select_options($option, $val, $pdefault);
				} else
					break;
			} else {
				$val = utf8_encode($val);
				$tag = utf8_encode($tag);
				$option = $this -> _xhtmldoc -> create_element("option");
				//  $node->append_child($option);
				$option -> set_attribute("value", $val);
				$option -> set_content($tag);

				if ($val == $pdefault) {
					$option -> set_attribute("selected", "selected");
				}
			}
			$node -> append_child($option);

		}
	}

	function priv_get_unique_id($id) {
		return ($this -> _form -> get_attribute("id")."_".$id);
	}

	function priv_create_node_input_checkbox($id, $ptype, $pname, $pval, $pclass, $parameters) {
		if ($this -> _const == true) {
			$node = $this -> _xhtmldoc -> create_element("span");
			if ($pval == $parameters["check"])
				$node -> set_content("yes");
			else
				$node -> set_content("no");
		} else {
			$node = $this -> _xhtmldoc -> create_element("input");
			$node -> set_attribute("type", $ptype);
			if ($pname != -1) {
				if ($ptype != "radio")
					$node -> set_attribute("id", $id);
				else
					$node -> set_attribute("id", $parameters["id"]);
				$node -> set_attribute("name", $pname);
			}
			$node -> set_attribute("value", $parameters["check"]);
			if ($pval == $parameters["check"]) {
				$node -> set_attribute("checked", "checked");
			}
		}
		if ($pclass != -1)
			$node -> set_attribute("class", $pclass);
		return $node;

	}

	function priv_create_node_input($id, $ptype, $pname, $pval, $pclass, $psize, $pmaxlength, $ponclick) {
		if ($this -> _const == true) {
			$node = $this -> _xhtmldoc -> create_element("span");
			if ($ptype == "text")
				$node -> set_content($pval);
		} else {
			$node = $this -> _xhtmldoc -> create_element("input");
			$node -> set_attribute("type", $ptype);
			if ($ptype == "image") {
				$node -> set_attribute("src", $pname);
				$node -> set_attribute("alt", $pval);
				return $node;
			}
			if ($pname != -1) {
				$node -> set_attribute("id", $id);
				$node -> set_attribute("name", $pname);
			}
			$node -> set_attribute("value", $pval);
			if ($psize != -1)
				$node -> set_attribute("size", $psize);
			if ($pmaxlength != -1)
				$node -> set_attribute("maxlength", $pmaxlength);
			if ($ponclick != -1)
				$node -> set_attribute("onclick", $ponclick);
			//      $toto="<input type=\"$ptype\" name=\"$pnom\"  value=\"$pval\" size=\"$ptaille\"></input>\n";
		}
		if ($pclass != -1)
			$node -> set_attribute("class", $pclass);
		return $node;

	}

	function priv_add_javascript($javascript) {
		//add a javascript code to the form
		//	$this->xhtml_message("coucou".$javascript_code);

		// 1) is the validate function there ?
		if (array_key_exists($this -> priv_get_unique_id("javascript"), $this -> _tab_nodes)) {
			//	$this->xhtml_message("coucou1".$javascript_code);
			$javascript_node = $this -> _tab_nodes[$this -> priv_get_unique_id("javascript")];
			$cdata = $this -> _tab_nodes[$this -> priv_get_unique_id("javascript_cdata_section")];
			$javascript_code = $cdata -> get_content();
			$javascript_code = str_replace("//string_to_replace", $javascript."//string_to_replace\n", $javascript_code);
		} else {
			//create the cdata node to add the javascript code
			//	$node = $this->_xhtmldoc->create_element("script");
			$javascript_node = $this -> _xhtmldoc -> create_element("script");
			$this -> _tab_nodes[$this -> priv_get_unique_id("javascript")] = $javascript_node;
			//$this->_currentnode->append_child($javascript_node);
			$this -> _tab_nodes[$this -> priv_get_unique_id("ground0")] -> append_child($javascript_node);
			$javascript_node -> set_attribute("type", "text/javascript");

			$javascript_code = $javascript."//string_to_replace\n";

			$cdata = $this -> _xhtmldoc -> create_cdata_section($javascript_code);

			$this -> _tab_nodes[$this -> priv_get_unique_id("javascript_cdata_section")] = $cdata;

			$javascript_node -> append_child($cdata);

		}
		$cdata -> set_content($javascript_code);
	}

	function priv_add_check_javascript($javascript) {
		//add a javascript code to the form
		//	$this->xhtml_message("coucou".$javascript_code);

		// 1) is the validate function there ?
		if (array_key_exists($this -> priv_get_unique_id("javascript_check"), $this -> _tab_nodes)) {
			//	$this->xhtml_message("coucou1".$javascript_code);
			$javascript_node = $this -> _tab_nodes[$this -> priv_get_unique_id("javascript_check")];
			$cdata = $this -> _tab_nodes[$this -> priv_get_unique_id("javascript_check_cdata_section")];
			$javascript_code = utf8_decode($cdata -> get_content());
			$javascript_code = str_replace("//string_to_replace", $javascript."//string_to_replace\n", $javascript_code);
		} else {
			$javascript_node = $this -> _xhtmldoc -> create_element("script");
			$this -> _tab_nodes[$this -> priv_get_unique_id("javascript_check")] = $javascript_node;
			//$this->_currentnode->append_child($javascript_node);
			$this -> _tab_nodes[$this -> priv_get_unique_id("ground0")] -> append_child($javascript_node);
			$javascript_node -> set_attribute("type", "text/javascript");

			//	$this->xhtml_message("coucou2".$javascript_code);
			//set the onsubmit parameter to call the future javascript code:
			$javascript_function_name = "check_on_submit_".$this -> _form -> get_attribute("id");
			$this -> _form -> set_attribute("onsubmit", "return ".$javascript_function_name."(this)");

			$javascript_code = "\nfunction ".$javascript_function_name." (form) {\n";
			$javascript_code.= $javascript;
			$javascript_code.= "//string_to_replace\n";
			$javascript_code.= " return true;\n";
			$javascript_code.= "}\n";
			//$javascript_code .= "//string_to_replace\n"
			$cdata = $this -> _xhtmldoc -> create_cdata_section($javascript_code);
			//$cdata = $this->_xhtmldoc->create_text_node ($javascript_code);
			$this -> _tab_nodes[$this -> priv_get_unique_id("javascript_check_cdata_section")] = $cdata;
			//	$$javascript_nodenode->set_content($legend);

			$javascript_node -> append_child($cdata);

		}
		$cdata -> set_content(utf8_encode($javascript_code));
	}
}

?>