<?php

/***************************************************************************
                    xhtml_page.inc  -
         object to manipulate xhtml page
                           -------------------
  begin                :  12/01/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

/* xhtml_page object interface:
//constructor, creates the xhtml document, with basic attibutes needed to
// produce valid xhtml code
xhtml_page()

//set the title of the xhtml page:
xhtml_page_set_title($title)
// add a CSS url reference for this xhtml page
xhtml_page_add_css($css)
// print the xhtml code to the output (usually, the remote browser)
xhtml_page_display()
*/

class xhtml_page extends xhtml_zone {
	//var $_xhtmldoc;
	//var $_currentnode;
	var $_root;
	var $_head;
	var $_head_title;

	var $_body;
	//var $_xpath;

	function xhtml_page() { //constructor
		$this -> xhtml_zone();
		// echo"coucou";
		//$this->_xhtmldoc = new DomDocument();
		//$this->_xhtmldoc = domxml_open_file("exemple.xml");
		$this -> _xhtmldoc = domxml_new_doc("1.0");
		//$xhtmldoc = &$this->_xhtmldoc;
		//$this->_xhtmldoc = domxml_open_mem("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//FR\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> <html> </html>");
		$this -> _root = $this -> _xhtmldoc -> create_element("html");
		$this -> _xhtmldoc -> append_child($this -> _root);

		// init xpath
		$this -> _xpath = xpath_new_context($this -> _xhtmldoc);
		//$xpresult = xpath_eval($this->_xpath, "/html");

		//$this->_root = $this->_xhtmldoc->document_element();
		//$this->_root = $this->_xhtmldoc->document_element()->first_child();
		//$this->_root = $this->_xhtmldoc->create_comment("Doctype truc");
		//$this->_xhtmldoc->append_child($this->_root);
		$this -> _root = $this -> _xhtmldoc -> document_element();
		$this -> _root -> set_attribute("xmlns", "http://www.w3.org/1999/xhtml");
		$this -> _root -> set_attribute("xml:lang", "fr");
		$this -> _root -> set_attribute("lang", "fr");

		$this -> _head = $this -> _xhtmldoc -> create_element("head");
		$node = $this -> _xhtmldoc -> create_element("meta");
		$node -> set_attribute("http-equiv", "Content-Type");
		$node -> set_attribute("content", "text/html; charset=iso-8859-1");
		//$node->set_attribute("type","text/CSS");
		//$node->set_content(utf8_encode($title));
		$this -> _head -> append_child($node);
		$this -> _head_title = $this -> _xhtmldoc -> create_element("title");
		$this -> _head -> append_child($this -> _head_title);

		$this -> _root -> append_child($this -> _head);
		$this -> _body = $this -> _xhtmldoc -> create_element("body");
		$this -> _root -> append_child($this -> _body);

		$this -> _currentnode = $this -> _body;

		$this -> _tab_nodes["ground0"] = $this -> _body;

		//$this->_xhtmldoc = $xhtmldoc;
		//$this->_head = &$head;
	}

	function xhtml_page_set_title($title) {
		//if ($this->_xhtmldoc->has_attribute("title"))
		//      $xpresult = xpath_eval($this->xpath, "/html/head/title");
		$this -> _head_title -> unlink_node();
		$this -> _head_title = $this -> _xhtmldoc -> create_element("title");
		$this -> _head -> append_child($this -> _head_title);
		$this -> _head_title -> set_content(utf8_encode($title));

	}

	function xhtml_page_add_css($css) {
		//<link rel ="stylesheet" href="./libcss/echantillons.css" type="text/CSS"/>
		$node = $this -> _xhtmldoc -> create_element("link");
		$node -> set_attribute("rel", "stylesheet");
		$node -> set_attribute("href", $css);
		$node -> set_attribute("type", "text/CSS");
		//$node->set_content(utf8_encode($title));
		$this -> _head -> append_child($node);
	}

	function xhtml_page_display() {
		//last function to use un a script
		// $doctype = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//FR\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";

		$doctype = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"
		 \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
		$page = $this -> _xhtmldoc -> dump_mem(1, "iso-8859-1");

		// $page = str_replace("0&lt;0","<",$page);
		// $page = str_replace("0&gt;0",">",$page);
		$page = str_replace("0(0", "<", $page);
		$page = str_replace("0)0", ">", $page);
		$page = str_replace("0dquote0", "\"", $page);
		$page = str_replace("0euh0", "?", $page);
		$page = str_replace("0and0", "&", $page);
		//$html_text = str_replace("?","0euh0",$html_text);

		//  $page = str_replace("&#amp;","&",$page);
		////
		//protection du CDATA contenant le javascript:
		$page = str_replace("type=\"text/javascript\"><![CDATA[", "type=\"text/javascript\">\n<!--/*--><![CDATA[//><!--\n", $page);
		$page = str_replace("]]></script>", "//--><!]]>\n</script>", $page);
		//<!--/*--><![CDATA[//><!--
		//--><!]]>

		$page = str_replace("\"?>", "\"?>\n".$doctype, $page);
		//echo utf8_decode($page);
		echo $page;
		//echo $this->_xhtmldoc->html_dump_mem();
	}

}

?>
