<?php
/***************************************************************************
                      xhtml_table.inc  -
          base class to produce xhtml tables
                             -------------------
    begin                :  27/01/2004
    copyright            : (C) 2004 by Olivier Langella
    email                : langella@moulon.inra.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

/* xhtml_table object interface:
//constructor, parameters: xml document, current node, form name
xhtml_table($xhtmldoc, $node, $id)

*/

class xhtml_table extends xhtml_zone {
	// var $_xhtmldoc;
	var $_table;
	var $_caption;
	var $_thead;
	var $_tbody;
	var $_theadtr;
	var $_tbodytr;
	// var $_currentnode;

	function xhtml_table($xhtmldoc, $node, $id, $class = -1) {
		$this -> xhtml_zone();
		$this -> _xhtmldoc = $xhtmldoc;
		$this -> _table = $this -> _xhtmldoc -> create_element("table");
		$node -> append_child($this -> _table);
		$this -> _currentnode = $this -> _table;
		$this -> _tab_nodes["ground0"] = $this -> _table;
		$this -> _table -> set_attribute("id", $id);
		if ($class != -1)
			$this -> _table -> set_attribute("class", $class);

		$this -> _thead = $this -> _xhtmldoc -> create_element("thead");
		$this -> _table -> append_child($this -> _thead);
		//$tr = $this->_xhtmldoc->create_element("tr");
		//$this->_thead->append_child($tr);
		$this -> _theadtr = -1;
		$this -> _tbodytr = -1;

		$this -> _tbody = $this -> _xhtmldoc -> create_element("tbody");
		$this -> _table -> append_child($this -> _tbody);
	}

	function add_line($tab = array()) {
		if (!is_array($tab))
			return;
		$tr = $this -> _xhtmldoc -> create_element("tr");
		$this -> _tbody -> append_child($tr);
		$this -> _tbodytr = $tr;
		for ($i = 0; $i < count($tab); $i ++) {
			$this -> priv_xhtml_insert_td($tab[$i], $tr);
		}
	}
	function add_cell($text, $class = -1) {
		if ($this -> _tbodytr == -1)
			return;
		//$tr = $this->_thead->first_child();
		$param = array();
		if ($class != -1)
			$param["class"] = $class;
		$this -> priv_xhtml_insert_td($text, $this -> _tbodytr, $param);
	}

	function add_header($text, $colspan = -1) {
		if ($this -> _theadtr == -1)
			return;
		//$tr = $this->_thead->first_child();
		$param = array();
		if ($colspan != -1)
			$param["colspan"] = $colspan;
		$this -> priv_xhtml_insert_td($text, $this -> _theadtr, $param);
	}

	function add_headers($tab = array()) {
		if (!is_array($tab))
			return;
		//$tr = $this->_thead->first_child();
		$tr = $this -> _xhtmldoc -> create_element("tr");
		$this -> _thead -> append_child($tr);
		$this -> _theadtr = $tr;
		for ($i = 0; $i < count($tab); $i ++) {
			$this -> priv_xhtml_insert_td($tab[$i], $tr);
		}
	}

	function priv_xhtml_insert_td($html_text, $node, $parameters = array()) {
			// insert $html_div in the current node
	if (array_key_exists("class", $parameters))
			$class = $parameters["class"];
		else
			$class = -1;
		if (array_key_exists("colspan", $parameters))
			$colspan = $parameters["colspan"];
		else
			$colspan = -1;

		//$dom = domxml_new_doc("1.0");
		$html_text = $html_text."</td>";
		$begin = "<td";
		if ($class != -1)
			$begin.= " class=\"".$class."\"";
		if ($colspan != -1)
			$begin.= " colspan=\"".$colspan."\"";

		$html_text = $begin.">".$html_text;
		$this -> priv_xhtml_insert(utf8_encode($html_text), $node);
	}

}
?>