<?php

/***************************************************************************
                    xhtml_zone.inc  -
         object to navigate in an xhtml document
                           -------------------
  begin                :  13/01/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

/* xhtml_zone object interface:
xhtml_zone() //constructor

//set the current_node pointer to the zone named $name
goto_zone($name)
//create a new div zone named $name, and set the pointer to it
new_zone_div($name, $class=-1)
//create a new span zone named $name, and set the pointer to it
new_zone_span($name, $class=-1)
//create a new ul (unordered list) zone named $name, and set the pointer to it
new_zone_ul($name, $class=-1)
*/

class xhtml_zone extends xhtml_base {
	var $_tab_nodes;
	var $_lock_zone;

	function xhtml_zone() {
		$this -> xhtml_base();
		$this -> _lock_zone = false;
	}

	function goto_zone($name) {
		$this -> priv_goto_zone($name);
	}

	function priv_goto_zone($name) {
		$name = $this -> priv_get_unique_id($name);
		//$this->xhtml_message($name);
		if (!array_key_exists($name, $this -> _tab_nodes)) {
			$this -> xhtml_message("ERROR: this zone doesn't exists: ".$name, "error");
			return;
		}
		if ($this -> _lock_zone == false)
			$this -> _currentnode = $this -> _tab_nodes[$name];
		else { //there is a human error
		}
	}

	function new_zone_div($name, $class = -1) {
		$this -> priv_new_zone("div", $name, $class);
	}

	function new_zone_span($name, $class = -1) {
		$this -> priv_new_zone("span", $name, $class);
	}

	function new_zone_ul($name, $class = -1) {
		$this -> priv_new_zone("ul", $name, $class);
	}
	function new_zone_li($name, $class = -1) {
		$this -> priv_new_zone("li", $name, $class);
	}
	function new_zone_table($name, $class = -1) {
		$table = $this -> _xhtmldoc -> create_element("table");
		$this -> _currentnode -> append_child($table);
		//  $table->append_child($tbody);
		$this -> _currentnode = $table;

		$this -> priv_new_zone("tbody", $name, $class);
	}
	function new_zone_tr($name, $class = -1) {
		$this -> priv_new_zone("tr", $name, $class);
	}
	function new_zone_td($name, $class = -1) {
		$this -> priv_new_zone("td", $name, $class);
	}

	function zone_ul_add_li($name, $arr_li, $class = -1) {
		$current = "-1";
		if (is_array($arr_li)) {
			reset($arr_li);
			while (list ($i, $content) = each($arr_li)) {
				//for ($i = 0; $i < count($array); $i++){
				// if ($array[$i] != "") {
				if ($content != "") {
					$li = $this -> _xhtmldoc -> create_element("li");
					//$this->xhtml_insert($array[$i],$li);
					$this -> priv_xhtml_insert($content, $li);
					if (is_string($i)) {
						$this -> _tab_nodes[$i] = $li;
					}
					$this -> _tab_nodes[$name] -> append_child($li);
				}
			}
		}
		//      for (
		//$this->_tab_nodes[$name]
		// $this->goto_zone($name)
		// $this->priv_new_zone("ul", $name, $class);
	}

	function priv_new_zone($tag, $name, $class = -1) {
		$name = $this -> priv_get_unique_id($name);
		$node = $this -> _xhtmldoc -> create_element($tag);
		$node -> set_attribute("id", $name);
		if ($class != -1)
			$node -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($node);
		$this -> _tab_nodes[$name] = $node;
		$this -> _currentnode = $node;
	}

	function priv_get_unique_id($name) {
		return ($name);
	}

}

?>