<?php

/***************************************************************************
                    svg_tree.inc  -
         object to draw phylogenetic tree
                           -------------------
  begin                :  12/01/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

class svg_tree {
	var $_xmldoc;
	var $_root;
	var $_current_node;
	var $_xpath;
	var $_tab_otu;
	var $_tag_otu_group;
	var $_tree_group;
	var $_bootstrap_group;
	var $_abs_tree_depth;
	var $_abs_tree_depth_tmp;
	var $_tree_depth;
	var $_tree_depth_back;
	var $_tree_depth_tmp;
	var $_xml_tree_doc;
	var $_tab_xml_tree_info;
	var $_unite_y;
	var $_x_scale;
	var $_viewbox;
	var $_itaxon;

	var $_defs;
	var $_style_line;
	var $_style_text;
	var $_no_length;

	var $_x_viewbox;
	var $_y_viewbox;

	function svg_tree() { //constructor
		$this -> _xmldoc = domxml_new_doc("1.0");
		// init xpath
		$this -> _xpath = xpath_new_context($this -> _xmldoc);

		$this -> _root = $this -> _xmldoc -> create_element("svg");
		$this -> _root -> set_attribute("height", "29.7cm");
		$this -> _root -> set_attribute("width", "21cm");
		$this -> _x_viewbox = 1000;
		$this -> _y_viewbox = 1000;
		$this -> _root -> set_attribute("viewBox", "0 0 ".$this -> _x_viewbox." ".$this -> _y_viewbox);
		$this -> _root -> set_attribute("preserveAspectRatio", "none");
		$this -> _xmldoc -> append_child($this -> _root);

		$this -> _style_line = "fill:none;fill-rule:evenodd;stroke:black;stroke-opacity:1;stroke-width:2pt;stroke-linejoin:miter;stroke-linecap:butt;fill-opacity:0.75;";
		$this -> _style_text = "font-size:1.5cm;font-weight:bold;stroke-width:1;font-family:Arial;";

		$this -> _viewbox = $this -> _root;
		//$this -> _viewbox = $this -> _xmldoc -> create_element("svg");
		//$this -> _viewbox -> set_attribute("x", "1cm");
		//$this -> _viewbox -> set_attribute("y", "1cm");
		//$this -> _viewbox -> set_attribute("height", "27.7cm");
		//$this -> _viewbox -> set_attribute("width", "19cm");
		//$this -> _viewbox -> set_attribute("viewbox", "0 0 1000 1000");
		//$this -> _root -> append_child($this -> _viewbox);

		$this -> _currentnode = $this -> _viewbox;
		$this -> _tree_group = $this -> _xmldoc -> create_element("g");
		$this -> _tree_group -> set_attribute("transform", "translate(30,0)");
		$this -> _currentnode -> append_child($this -> _tree_group);
		$this -> _tag_otu_group = $this -> _xmldoc -> create_element("g");
		$this -> _tag_otu_group -> set_attribute("style", $this -> _style_text);
		$this -> _bootstrap_group = $this -> _xmldoc -> create_element("g");
		$this -> _tree_group -> append_child($this -> _bootstrap_group);
		$this -> _tree_group -> append_child($this -> _tag_otu_group);

		$this -> _unite_y = 0;
		$this -> _x_scale = 0;
		$this -> _tree_depth = 0;
		$this -> _tree_depth_tmp = 0;
		$this -> _abs_tree_depth = 0;
		$this -> _abs_tree_depth_tmp = 0;
		$this -> _no_length = false;
		$this -> _tab_otu = array();
		$this -> _itaxon = 0;
	}

	function set_font_size($size) {
		$this -> _style_text = $this -> priv_modify_style($this -> _style_text, "font-size", $size);
		//echo $this -> _style_text;
		$this -> _tag_otu_group -> set_attribute("style", $this -> _style_text);
	}

	function set_stroke_width($size) {
		$this -> _style_line = $this -> priv_modify_style($this -> _style_line, "stroke-width", $size);
		//echo $this -> _style_text;
		//$this -> _tag_otu_group -> set_attribute("style", $this -> _style_line);
	}

	function priv_modify_style($text_style, $item, $value) {
		//return (ereg_replace($item.":.;",$item.":".$value.";",$text_style));
		return (ereg_replace($item.":[a-z,0-9,A-Z,\., ]*;", $item.":".$value.";", $text_style));
	}

	function draw_tree($xml_tree) {
		//$this -> _unite_y = 10;
		$this -> _xml_tree_doc = $xml_tree;
		$this -> _tab_xml_tree_info = array();
		$tab_tree = $xml_tree -> _xpath -> xpath_eval("//trees/tree/*");
		$this -> priv_get_tree_info($tab_tree -> nodeset[0]);
		//print_r($this -> _tab_xml_tree_info);
		$id = $tab_tree -> nodeset[0] -> get_attribute("id");
		//echo $this -> _itaxon;
		$nbmax = $this -> _itaxon;
		if ($this -> _tree_depth <= 0)
			$this -> _no_length = true;
		$this -> _unite_y = $this -> _y_viewbox / $nbmax;
		if ($this -> _no_length == false)
			$this -> _x_scale = $this -> _x_viewbox / $this -> _tree_depth;
		else
			$this -> _x_scale = $this -> _x_viewbox / $this -> _abs_tree_depth;
		$this -> _x_scale = $this -> _x_scale - ($this -> _x_scale / 5);
		$y1 = ($nbmax * $this -> _unite_y) / 2;
		$this -> priv_draw_scale();
		$this -> _bootstrap_group -> set_attribute("style", $this -> _style_text);
		$this -> priv_draw_tree($tab_tree -> nodeset[0], 0, $y1, 0);
	}

	function priv_draw_bootstrap($x, $y, $bootstrap) {

		$text = $this -> _xmldoc -> create_element("text");
		$textspan = $this -> _xmldoc -> create_element("tspan");
		//$this ->_tab_otu[cou] ;
		$text -> set_attribute("x", $x * $this -> _x_scale);
		$text -> set_attribute("y", $y);
		$text -> set_attribute("style", "text-anchor: end;");
		$textspan -> set_attribute("style", "text-anchor: end;");
		//$textspan -> set_attribute("dx", -4);
		$textspan -> set_attribute("dy", -4);
		//$textspan -> set_attribute("style", "baseline-shift: sub;");
		//$textspan -> set_attribute("y", $y1);
		$textspan -> set_content($bootstrap);
		$text -> append_child($textspan);
		//$group -> append_child($text);

		$this -> _bootstrap_group -> append_child($text);
	}

	function priv_draw_scale() {
		//scale segment:
		//echo $this -> _tree_depth;
		if ($this -> _tree_depth <= 0) {
			return;
		}
		if ($this -> _tree_depth > 100) {
			$scale = 100;
		} else
			if ($this -> _tree_depth > 10) {
				$scale = 10;
			} else
				if ($this -> _tree_depth > 1) {
					$scale = 1;
				} else
					if ($this -> _tree_depth > 0.1) {
						$scale = 0.1;
					} else
						if ($this -> _tree_depth > 0.01) {
							$scale = 0.01;
						} else
							if ($this -> _tree_depth > 0.001) {
								$scale = 0.001;
							}

		$length = $scale * $this -> _x_scale;

		$group = $this -> _xmldoc -> create_element("g");
		$group -> set_attribute("style", $this -> _style_text);
		$branch = $this -> _xmldoc -> create_element("line");
		$branch -> set_attribute("x1", 0);
		$branch -> set_attribute("y1", 1000);
		$branch -> set_attribute("x2", $length);
		$branch -> set_attribute("y2", 1000);
		$branch -> set_attribute("style", $this -> _style_line);
		$group -> append_child($branch);

		$text = $this -> _xmldoc -> create_element("text");
		$textspan = $this -> _xmldoc -> create_element("tspan");
		//$this ->_tab_otu[cou] ;
		$text -> set_attribute("x", $length / 2);
		$text -> set_attribute("y", 1000);
		$text -> set_attribute("style", "text-anchor: middle;");
		$textspan -> set_attribute("style", "text-anchor: middle;");
		$textspan -> set_attribute("dy", -4);
		//$textspan -> set_attribute("style", "baseline-shift: sub;");
		//$textspan -> set_attribute("y", $y1);
		$textspan -> set_content($scale);
		$text -> append_child($textspan);
		$group -> append_child($text);

		$this -> _tree_group -> append_child($group);
	}

	function priv_get_tree_info($node) {
		//collect information about nodes and store it in an associative array
		// informations are for branches : abs_depth, depth
		//echo "coucou";
		$nodes = $node -> child_nodes();
		if ($node -> node_name() == "node") {
			$this -> _tab_xml_tree_info[$node -> get_attribute("id")] = array("depth" => $this -> _tree_depth_tmp, "abs_depth" => $this -> _abs_tree_depth_tmp);
			$this -> _tab_xml_tree_info[$node -> get_attribute("id")]["cumul"] = 0;
		}

		$tab_pre_y = array();
		for ($i = 0; $i < count($nodes); $i ++) {
			$current = $nodes[$i];
			//echo $nodes[$i] -> node_name();
			if ($nodes[$i] -> node_name() == "node") {
				$this -> priv_get_tree_info($nodes[$i]);
			}
			if ($nodes[$i] -> node_name() == "branch") {
				$tree_depth_back = $this -> _tree_depth_tmp;
				$this -> _abs_tree_depth_tmp += 1;
				//echo "coucou";
				//$this->_tab_xml_tree_info[] = array($current, "abs_depth" =>$this->_abs_tree_depth_tmp);
				//$this->_tab_xml_tree_info[&$current]["abs_depth"] =$this->_abs_tree_depth_tmp;
				$tab_pre_y[] = $this -> priv_get_tree_info($nodes[$i]);
				$this -> _abs_tree_depth_tmp--;
				$this -> _tree_depth_tmp = $tree_depth_back;
			}
			if ($nodes[$i] -> node_name() == "length") {
				$length = $current -> get_content();
				if ($length < 0)
					$length = 0;
				$this -> _tree_depth_tmp += $length;
				//$this->_tab_xml_tree_info[$node]["depth"] =$this->_tree_depth_tmp;
			}
			if ($nodes[$i] -> node_name() == "bootstrap") {
			}
			if ($nodes[$i] -> node_name() == "taxon") {
				//echo $current->get_content();
				$pre_y = $this -> _itaxon + 0.5;
				$this -> _itaxon++;
				$this -> _tab_xml_tree_info[$current -> get_attribute("id")] = array("pre_y" => $pre_y, "depth" => $this -> _tree_depth_tmp, "abs_depth" => $this -> _abs_tree_depth_tmp);
				if ($this -> _tree_depth_tmp > $this -> _tree_depth)
					$this -> _tree_depth = $this -> _tree_depth_tmp;
				//$this->_tree_depth_tmp = 0;
				if ($this -> _abs_tree_depth_tmp > $this -> _abs_tree_depth)
					$this -> _abs_tree_depth = $this -> _abs_tree_depth_tmp;
				//$this->_abs_tree_depth_tmp--;
				//echo $node ->get_content();
				$this -> priv_cumul($current);
				return ($pre_y);
			}
		}

		if ($node -> node_name() == "node") {
			//print_r($tab_pre_y);
			$pre_y = 0;
			for ($i = 0; $i < count($tab_pre_y); $i ++) {
				//echo $tab_pre_y[$i]."\n";
				$pre_y += $tab_pre_y[$i];
			}
			$pre_y = $pre_y / count($tab_pre_y);
			$this -> _tab_xml_tree_info[$node -> get_attribute("id")]["pre_y"] = $pre_y;
			//echo $pre_y."\n";
			return ($pre_y);
		}

	}

	function priv_cumul($node) {
		//echo $node-> node_name() ;
		if (($node -> node_name() == "node") or ($node -> node_name() == "taxon")) {
			if (array_key_exists("cumul", $this -> _tab_xml_tree_info[$node -> get_attribute("id")]))
				$this -> _tab_xml_tree_info[$node -> get_attribute("id")]["cumul"]++;
			else
				$this -> _tab_xml_tree_info[$node -> get_attribute("id")]["cumul"] = 0;
			$parent = $node -> parent_node();
			$parent = $parent -> parent_node();
			$this -> priv_cumul($parent);
		}
	}

	function priv_draw_branch($x1, $y1, $x2, $y2) {
		$x1 = $this -> _x_scale * $x1;
		$x2 = $this -> _x_scale * $x2;
		//$y1 = intval($y1);
		//$y2 = intval($y2);
		//$branch = $this -> _xmldoc -> create_element("polyline");
		//$branch -> set_attribute("points", $x1." ".$y1.", ".$x1." ".$y2.", ".$x2." ".$y2);
		/*
		$branch = $this -> _xmldoc -> create_element("line");
		$branch -> set_attribute("x1", $x1);
		$branch -> set_attribute("y1", $y1);
		$branch -> set_attribute("x2", $x2);
		$branch -> set_attribute("y2", $y2);
		$branch -> set_attribute("style", $this->_style_line);
		$this -> _current_node -> append_child($branch);
		*/
		$branch = $this -> _xmldoc -> create_element("path");
		$branch -> set_attribute("style", $this -> _style_line);
		$branch -> set_attribute("d", "M $x1 $y1 L $x1 $y2 L $x2 $y2");
		$this -> _current_node -> append_child($branch);

		/*
		$branch = $this -> _xmldoc -> create_element("line");
		$branch -> set_attribute("x1", $x1);
		$branch -> set_attribute("y1", $y1);
		$branch -> set_attribute("x2", $x1);
		$branch -> set_attribute("y2", $y2);
		$branch -> set_attribute("style", "stroke-linecap: round; stroke: black; stroke-linejoin: bevel; stroke-width: 5;");
		$this -> _current_node -> append_child($branch);
		
		$branch = $this -> _xmldoc -> create_element("line");
		$branch -> set_attribute("x1", $x1);
		$branch -> set_attribute("y1", $y2);
		$branch -> set_attribute("x2", $x2);
		$branch -> set_attribute("y2", $y2);
		$branch -> set_attribute("style", "stroke-linecap: round; stroke: black; stroke-linejoin: bevel; stroke-width: 5;");
		$this -> _current_node -> append_child($branch);
		*/
	}

	function priv_draw_tree($node, $x1, $y1, $offsety) {
		//echo "coucou draw";
		$nodes = $node -> child_nodes();
		if ($node -> node_name() == "branch") {
			$unite_y = $this -> _unite_y;
			$length = 0;
			for ($i = 0; $i < count($nodes); $i ++) {
				$current = $nodes[$i];
				//echo $current -> node_name();
				if ($current -> node_name() == "length") {
					$length = $current -> get_content();
				}
				if (($current -> node_name() == "node") or ($current -> node_name() == "taxon")) {
					$inode = $i;
				}
			}
			//echo $length;
			$id = $nodes[$inode] -> get_attribute("id");
			$ymax = $offsety + $this -> _tab_xml_tree_info[$id]["cumul"] * $unite_y;
			$this -> _current_node = $this -> _tree_group;
			//trac�:
			$x2 = $x1 + $length;
			$y2 = ($ymax - $offsety) / 2 + $offsety;
			$new_offset = $this -> priv_draw_tree($nodes[$inode], $x2, $y2, $offsety);

			$this -> priv_draw_branch($x1, $y1, $x2, $y2);
			return ($ymax);

		} else {
			if ($node -> node_name() == "node") {
				//transmit to branches
				for ($i = 0; $i < count($nodes); $i ++) {
					$current = $nodes[$i];
					if ($current -> node_name() == "bootstrap") {
						$this -> priv_draw_bootstrap($x1, $y1, $current -> get_content());
					} else
						$offsety = $this -> priv_draw_tree($current, $x1, $y1, $offsety);
				}
				return ($offsety);
			} else {
				if ($node -> node_name() == "taxon") {
					$x1 = $x1 * $this -> _x_scale;
					$text = $this -> _xmldoc -> create_element("text");
					$textspan = $this -> _xmldoc -> create_element("tspan");
					//$this ->_tab_otu[cou] ;
					$text -> set_attribute("x", $x1);
					$text -> set_attribute("y", $y1);
					$textspan -> set_attribute("dx", 4);
					$textspan -> set_attribute("dy", 4);
					//$textspan -> set_attribute("style", "baseline-shift: sub;");
					//$textspan -> set_attribute("y", $y1);
					$textspan -> set_content($node -> get_content());
					//$text -> set_attribute("style", $this->_style_text);
					$text -> append_child($textspan);
					$this -> _tag_otu_group -> append_child($text);
					//return($offsety + $unite_y);
					return (0);
				}
			}
		}
	}
}
?>