<?php

/***************************************************************************
                    svg_tree_phylo.inc  -
         object to draw phylogenetic tree
                           -------------------
  begin                :  12/01/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

class point {
	var $_x;
	var $_y;
}

class svg_tree_phylo extends svg_tree {
	function priv_draw_tree($node, $x1, $y1, $offsety) {
		$nodes = $node -> child_nodes();
		if ($node -> node_name() == "branch") {
			$length = -1;
			for ($i = 0; $i < count($nodes); $i ++) {
				$current = $nodes[$i];
				//echo $current -> node_name();
				if ($current -> node_name() == "length") {
					$length = $current -> get_content();
				}
				if (($current -> node_name() == "node") or ($current -> node_name() == "taxon")) {
					$inode = $i;
				}
			}
			if ($length < 0)
				$length = 0;
			if ($this -> _no_length)
				$length = 1;
			$x2 = $x1 + $length;
			$y2 = 0;
			$point2 = $this -> priv_draw_tree($nodes[$inode], $x2, $y2, $offsety);

			//$point2->_x = $x2;
			return ($point2);

		} else {
			if ($node -> node_name() == "node") {
				//transmit to branches
				$cumuly = 0;
				$nbbranches = 0;
				$tab_points = array();
				for ($i = 0; $i < count($nodes); $i ++) {
					$current = $nodes[$i];
					if ($current -> node_name() == "branch") {
						$tab_points[$nbbranches] = $this -> priv_draw_tree($current, $x1, $y1, $offsety);
						$cumuly += $tab_points[$nbbranches] -> _y;
						$nbbranches ++;
					}
				}
				//print_r($tab_points);
				$y1 = $cumuly / $nbbranches;
				$nbbranches = 0;
				$this -> _current_node = $this -> _tree_group;
				for ($i = 0; $i < count($nodes); $i ++) {
					$current = $nodes[$i];
					if ($current -> node_name() == "bootstrap") {
						$this -> priv_draw_bootstrap($x1, $y1, $current -> get_content());
					}
					elseif ($current -> node_name() == "branch") {
						$this -> priv_draw_branch($x1, $y1, $tab_points[$nbbranches] -> _x, $tab_points[$nbbranches] -> _y);
						$nbbranches ++;
					}
				}
				$tab_points[0] -> _x = $x1;
				$tab_points[0] -> _y = $y1;
				return ($tab_points[0]);
			} else {
				if ($node -> node_name() == "taxon") {
					$id = $node -> get_attribute("id");
					if ($this -> _no_length)
						$x1 = $this -> _abs_tree_depth;
					//else $x1 = $x1 ;
					$y1 = ($this -> _tab_xml_tree_info[$id]["pre_y"]) * $this -> _unite_y;
					//	echo $this -> _tab_xml_tree_info[$id]["pre_y"];
					//echo $unite_y
					$text = $this -> _xmldoc -> create_element("text");
					$textspan = $this -> _xmldoc -> create_element("tspan");
					//$this ->_tab_otu[cou] ;
					$text -> set_attribute("x", $x1 * $this -> _x_scale);
					$text -> set_attribute("y", $y1);
					$textspan -> set_attribute("dx", 4);
					$textspan -> set_attribute("dy", 4);
					//$textspan -> set_attribute("style", "baseline-shift: sub;");
					//$textspan -> set_attribute("y", $y1);
					$textspan -> set_content($node -> get_content());
					//$text -> set_attribute("style", $this->_style_text);
					$text -> append_child($textspan);
					$this -> _tag_otu_group -> append_child($text);
					//return($offsety + $unite_y);
					$point = new point();
					$point -> _x = $x1;
					$point -> _y = $y1;

					return ($point);
				}
			}
		}
	}
}
?>