<?php

/***************************************************************************
                    xml_tree.inc  -
         object to manipulate phylogenetic trees
                           -------------------
  begin                :  19/2/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
require_once (APP_ROOT_RELATIVE_PATH."libsvgtree/xml_tree_base.inc");

class xml_tree extends xml_tree_base {

	function xml_tree() {
		//echo "coucou";
		$this -> xhtml_tree_base();
	}

	function add_phylip_tree($text) {
		$text = utf8_encode($text);
		$tree = $this -> _xmldoc -> create_element("tree");
		$this -> _root -> append_child($tree);
		$info = substr($text, 0, strpos($text, "("));
		$text = substr($text, strpos($text, "("), strrpos($text, ";"));
		$node = $this -> priv_add_node_phylip_tree($text);
		if (is_object($node))
			$tree -> append_child($node -> first_child());
		else
			echo $node;
		//	if (! $node ->has_attribute(length)) $node ->set_attribute("length",0);

	}

	function priv_add_node_phylip_tree($text) {
		//echo "_".$text."_";
		$pos = strpos($text, ",");
		if ($pos === false) {
			//Add a leaf
			$branch = $this -> _xmldoc -> create_element("branch");
			$pos = strpos($text, ":");
			//echo "leaf".$text."leaf";
			if (!($pos === false)) {
				$length = $this -> _xmldoc -> create_element("length");
				$branch -> append_child($length);
				$length -> set_content(substr($text, $pos +1));
				$text = substr($text, 0, $pos);
			}
			$taxon = $this -> _xmldoc -> create_element("taxon");
			$taxon -> set_attribute("id", "t".$this -> _count++);
			$branch -> append_child($taxon);
			$text = trim($text);
			$text = trim($text, "'");
			$taxon -> set_content($text);
			//$node->set_attribute("name",$text);
			//return ($branch);
		} else {
			//Add a node
			$pos = strpos($text, "(");
			if ($pos == 1) {
				$text = substr($text, 1);
				$pos = strpos($text, "(");
			}
			if ($pos != 0) {
				return ("ERROR: tree not consistent ".$text);
			}
			$branch = $this -> _xmldoc -> create_element("branch");
			$node = $this -> _xmldoc -> create_element("node");
			$node -> set_attribute("id", "n".$this -> _count++);

			$node_info = substr(strrchr($text, ")"), 1);

			$pos = strpos($node_info, ":");
			if (!($pos === false)) {
				$length = $this -> _xmldoc -> create_element("length");
				$branch -> append_child($length);
				$length -> set_content(substr($node_info, $pos +1));
				//$node -> set_attribute("length", substr($node_info, $pos +1));
				$node_info = substr($node_info, 0, $pos);
			}
			$branch -> append_child($node);
			//echo $node_info;
			if ($node_info != "") {
				//bootstrap value
				$bootstrap = $this -> _xmldoc -> create_element("bootstrap");
				$bootstrap -> set_content($node_info);
				$node -> append_child($bootstrap);
			}
			//	$node -> set_attribute("force", $node_info);

			$text = substr($text, 0, strrpos($text, ")"));
			$text = substr($text, 1);
			//echo $text;
			$tab = array();
			$j = 0;
			$niveau = 0;
			$tab[0] = "";
			for ($i = 0; $i < strlen($text); $i ++) {
				//s�parer le texte du noeud gr�ce aux virgules
				//echo "_".$text[$i]."_\n";
				if ($text[$i] == "(")
					$niveau ++;
				else
					if ($text[$i] == ")")
						$niveau --;
				//echo $niveau;
				if (($niveau == 0) & ($text[$i] == ",")) {
					//echo "_#".$tab[$j]."_\n";
					$j ++;
					$tab[$j] = "";
				} else {
					//echo "_�".$tab[$j].$text[$i]."_\n";
					$tab[$j] = $tab[$j].$text[$i];
				}
			}
			for ($i = 0; $i < count($tab); $i ++) {
				//echo "_".$tab[$i]."_";
				$child = $this -> priv_add_node_phylip_tree($tab[$i]);

				if (is_object($child))
					$node -> append_child($child);
				else
					echo $child;
			}
		}

		return $branch;
	}
}

?>