<?php
/*
$tree = domxml_new_doc("1.0");
$root = $tree -> create_element("svg");
$tree -> append_child($root);

// init xpath
$path = xpath_new_context($tree);

$svgtree = new phylotree($tree,$root);
$svgtree -> read_phylip($_POST["texttree"]);
*/
require_once (APP_ROOT_RELATIVE_PATH."libsvgtree/xml_tree.inc");
require_once (APP_ROOT_RELATIVE_PATH."libsvgtree/svg_tree.inc");
require_once (APP_ROOT_RELATIVE_PATH."libsvgtree/svg_tree_phylo.inc");

$xml_tree = new xml_tree();
$_POST["texttree"] = stripslashes($_POST["texttree"]);

switch ($_FILES['tree_file']['error']) {
	case (0) : //file upload ok
		$arbre_texte = file_get_contents($_FILES['tree_file']['tmp_name']);
		$svg_treefile_name = $_FILES['tree_file']['name'].".svg";
		break;
	case (1) : //The uploaded file exceeds the upload_max_filesize directive in php.ini.
		$page -> xhtml_message("The uploaded file exceeds the upload_max_filesize directive in php.ini.", "error");
		return;
		break;
	case (2) : //The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form
		$page -> xhtml_message("The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.", "error");
		return;
		break;
	case (3) : //The uploaded file was only partially uploaded
		$page -> xhtml_message("The uploaded file was only partially uploaded.", "error");
		return;
		break;
	case (4) : //no file uploaded
		$arbre_texte = $_POST["texttree"];
		$svg_treefile_name = "phpphylotree.svg";
		break;
	default :
		break;
}
/*
    The original name of the file on the client machine. 
$_FILES['tree_file']['type']

    The mime type of the file, if the browser provided this information. An example would be "image/gif". 
$_FILES['tree_file']['size']
*/

$xml_tree -> add_phylip_tree($arbre_texte);

//$_SESSION["xmltree"] = $xml_tree -> _xmldoc -> dump_mem(1, "iso-8859-1");
//echo $xml_tree -> _xmldoc -> dump_mem(1, "iso-8859-1");

$svg_tree = new svg_tree_phylo();
$svg_tree -> set_font_size($_POST["otu_font_size"]);
$svg_tree -> set_stroke_width($_POST["stroke_width"]);
$svg_tree -> draw_tree($xml_tree);
//echo $xml_tree->_xmldoc->dump_mem(1, "iso-8859-1");
header("Content-Type: image/svg+xml");
//header("Content-Type: text/txt");
header("Content-Disposition: attachment; filename=".$svg_treefile_name);
echo $svg_tree -> _xmldoc -> dump_mem(1, "iso-8859-1");
exit;

?>