<?php

/***************************************************************************
                      html_functions.inc  -
           production de code HTML (ancres, paragraphes...)
           
                             -------------------
    begin                :  19/1/2002
    copyright            : (C) 2004 by Olivier Langella, 
derived from the work of Philippe Rigaud
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

if (!isset($module_html_functions)) {
	$module_html_functions = 1;

	function html_anchor($url, $libelle, $classe = -1) {
		if (($url == "") & ($libelle == ""))
			return "";
		$url = str_replace("&", "&amp;", $url);
		$optionClasse = "";
		if ($classe != -1)
			$optionClasse = " class=\"$classe\"";
		return "<a href=\"".$url."\"".$optionClasse.">".$libelle."</a>";
	}

	function ancre_nom($nom) {
		return "<a id=\"$nom\"></a>";
	}

	function html_image($url, $alt, $parameters = array()) {
			//$alt => obligatoire pour le XHTML
	$tag = "<img src=\"".$url."\" alt=\"".$alt."\"";
		if (array_key_exists("class", $parameters))
			$tag.= " class=\"".$parameters["class"]."\"";
		if (array_key_exists("title", $parameters))
			$tag.= " title=\"".$parameters["title"]."\"";
		$tag.= "/>";

		return $tag;
	}

	function html_message($ligne, $classe = -1) {
		if ($classe == "")
			$classe = -1;
		if ($classe == -1)
			return ("<div>".$ligne."</div>");
		else
			return ("<div class='".$classe."'>".$ligne."</div>");
	}

	function html_confirmation($message, $url_oui, $url_non) {
		$tmp_message = $message;
		$tmp_message.= html_message(ancre($url_oui, "oui"));
		$tmp_message.= html_message(ancre($url_non, "non"));
		echo html_message($tmp_message, "confirmation");

	}

}
?>
