<?php

/***************************************************************************
                    oxml_document.inc  -
         Olivier simple xml document object
                           -------------------
  begin                :  19/10/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

//echo 'coucou';
class oxml_document {
	var $_root_element;
	var $_version;
	var $_current_element;
	
	function oxml_document($xml_version) {
		$this->_version = $xml_version;
		$this->_root_element=null;
		
	}
	
	function &create_element($tag_name) {
		$ref = new oxml_element($this,$tag_name);
		return ($ref);
	}
	
	function &create_cdata_section($cdata) {
		$ref = new oxml_cdata($this);
		$ref -> set_content($cdata);
		return ($ref);
	}
	
	function &document_element() {
		return ($this->_root_element);
	}
	
	function append_child(&$element){
		$this->_root_element = $element;
	}
	
	function dump_mem_xhtml($style, $code, $doctype) {
		$returned_string = '<?xml version="'.$this->_version.'" encoding="'.$code.'"?>';
		$returned_string .= "\n".$doctype."\n";
		$this->_root_element->priv_dump_mem_xhtml($returned_string, $style, $code);
		
		if ($code == 'iso-8859-1') return(utf8_decode($returned_string));
		else return ($returned_string);
	}
}

?>