<?php

/***************************************************************************
                    oxml_element.inc  -
         Olivier simple xml element object
                           -------------------
  begin                :  19/10/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

class oxml_element {
	//var $_original_doc;
	var $_name;
	var $_arr_attributes;
	var $_arr_content;

	function oxml_element(& $doc, $element_name) {
		//$this->_original_doc = $doc;
		$this -> _name = $element_name;
		$this -> _arr_attributes = array();
		$this -> _arr_content = array(); //this contains 2 types of keys: element or text
	}

	function unlink_node() {
		//unlink ($this->_arr_content);
		$this -> _arr_content = array(); //this contains 2 types of keys: element or text
		//echo count ($this->_arr_content);
	}

	function get_attribute($tag_name) {
		return ($this -> _arr_attributes[$tag_name]);
	}

	function append_child(& $element) {
		$this -> _arr_content[] = & $element;
		//$this->_root_element = $element;
	}

	function set_attribute($name, $value) {
		$this -> _arr_attributes[$name] = $value;
	}

	function set_content($text) {
		$this -> _arr_content[] = $text;
	}

	function priv_dump_mem_xhtml(& $returned_string, $style, $code) {
		$returned_string.= '<'.$this -> _name;
		if (count($this -> _arr_attributes) != 0) {
			foreach ($this -> _arr_attributes as $key => $value) {
				$returned_string.= ' '.$key.'="'.$value.'"';
			}
		}

		if (count($this -> _arr_content) == 0) {
			switch ($this -> _name) {
				case 'div' :
				case 'textarea' :
					$returned_string.= '></'.$this -> _name.">\n";
					break;
				default :
					$returned_string.= '/>';
					break;
			}
			return ($returned_string);
		} else
			$returned_string.= '>';

		foreach ($this -> _arr_content as $case) {
			if (is_object($case)) {
				$returned_string.= "\n";
				$case -> priv_dump_mem_xhtml($returned_string, $style, $code);
			} else {
				//echo $case;
				$returned_string.= $case;
			}
		}

		if ($this -> _name != 'textarea')
			$returned_string.= "\n";
		$returned_string.= '</'.$this -> _name.'>';

		return ($returned_string);
	}
}

?>