<?php

/***************************************************************************
                    xhtml_base.inc  -
         base object to navigate in an xhtml document
                           -------------------
  begin                :  19/01/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

/* xhtml_base interface
xhtml_base() //constructor

get_xhtml_doc() // get xml document pointer
get_current_node() // get pointer to the current xml node in the document

// methods to produce xhtml code:
xhtml_hr($class=-1)
xhtml_br($class=-1)
xhtml_header($title, $level = 0, $class = -1)
// produce an "ul" list from the array
xhtml_ul($array, $class=-1, $parameters=array())
// insert a "div" section containing the given text at the current node
xhtml_message($text, $class=-1)
// same as xhtml_message, but with explicit "div" tag
xhtml_insert_div($html_text, $class=-1)
// insert a "span" section containing the given text
 xhtml_insert_span($html_text, $class=-1)
// insert any xhtml tag the user want in the document, at the current node or the given node
// beware that the $html_text have to be a well formed node
xhtml_insert($html_text, $insert_node = -1)
*/

//modified by Olivier Langella 07/06/2004 to add xhtml_header
/*
if (!extension_loaded('domxml')) {
	die("The extension 'domxml' couldn't be found.\n"." This extension is only available if PHP was configured with --with-dom[=DIR]. DIR is the libxml version 2.4.14 or superior base install directory\n");
	exit;
	//	return false;
}
*/


/**  \brief converts a string to UTF8.

to be sure that the given string is converted into UTF8

\param $str is the string to convert
\result an utf8 string
*/
function utf8_ensure($str) {
	return seems_utf8($str) ? $str : utf8_encode($str);
}

function seems_utf8($Str) {
	// tell if a string is already encoded into utf8
	//usefull function taken from http://fr2.php.net/manual/en/function.utf8-encode.php

	for ($i = 0; $i < strlen($Str); $i ++) {
		if (ord($Str[$i]) < 0x80)
			continue; # 0bbbbbbb
		elseif ((ord($Str[$i]) & 0xE0) == 0xC0) $n = 1; # 110bbbbb
		elseif ((ord($Str[$i]) & 0xF0) == 0xE0) $n = 2; # 1110bbbb
		elseif ((ord($Str[$i]) & 0xF8) == 0xF0) $n = 3; # 11110bbb
		elseif ((ord($Str[$i]) & 0xFC) == 0xF8) $n = 4; # 111110bb
		elseif ((ord($Str[$i]) & 0xFE) == 0xFC) $n = 5; # 1111110b
		else
			return false; # Does not match any model
		for ($j = 0; $j < $n; $j ++) { # n bytes matching 10bbbbbb follow ?
			if ((++ $i == strlen($Str)) || ((ord($Str[$i]) & 0xC0) != 0x80))
				return false;
		}
	}
	return true;
}


/** \brief base object to navigate in an xhtml document.
*
* provides a base object that is used to produce basic xhtml tags
*/

class xhtml_base {
	/**
	this is a reference to the xhtml document, consider this as private
	*/
	var $_xhtmldoc;
	/**
	this is a reference to the current node of the xhtml document, consider this as private
	*/
	var $_currentnode;

/** \brief this constructor should be called only by other xhtml_objects.
*
* this is used as a base constructor by xhtml_page, xhtml_form, xhtml_list, xhtml_table
*/
	function xhtml_base() {
		$this -> _lock_zone = false;
	}

/**
\return the pointer to the current xhtml document
*/
	function & get_xhtml_doc() {
		return $this -> _xhtmldoc;
	}

/**
\return the pointer to the current xhtml node
*/
	function & get_current_node() {
		return $this -> _currentnode;
	}

	function priv_no_amp($text) {
		//return(str_replace("& ","&amp;",$text));
	}

/** \brief inserts a horizontal rule tag <hr/>

\param $class is the CSS class to use 
*/

	function xhtml_hr($class = -1) {
		$node = & $this -> _xhtmldoc -> create_element("hr");
		if ($class != -1)
			$node -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($node);
	}

/** \brief inserts a header tag h1, h2 .. hlevel

\param $title is the string used as header
\param $level is the type of header, 1 is bigger than 2 bigger than 3 
\param $class is the CSS class to use
*/
	function xhtml_header($title, $level = 1, $class = -1) {
		$node = & $this -> _xhtmldoc -> create_element("h".$level);
		if ($class != -1)
			$node -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($node);
		$this -> priv_xhtml_insert(utf8_ensure($title), & $node);
	}

/** \brief inserts an image tag in the xhtml document

\param $url is the url of the image file
\param $alt is the alternative description (used if the browser can not display the image)
\param $parameters is an associative array that can contain optionals xhtml parameters, such as the CSS class in $parameters['class'] or a title for the image $parameters['title']
*/
	function xhtml_image($url, $alt, $parameters = array()) {
		$node = & $this -> _xhtmldoc -> create_element('img');
		$node -> set_attribute("src", $url);
		$node -> set_attribute("alt", $alt);
		if (array_key_exists("class", $parameters))
			$node -> set_attribute("class", $parameters["class"]);
		if (array_key_exists("title", $parameters))
			$node -> set_attribute("title", $parameters["title"]);
		$this -> _currentnode -> append_child($node);
	}

/** \brief inserts a break line <br/> in the xhtml document

\param $class is the CSS class to use
*/
	function xhtml_br($class = -1) {
		$node = & $this -> _xhtmldoc -> create_element("br");
		if ($class != -1)
			$node -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($node);
	}

/** \brief inserts an unordered list 'ul' in the xhtml document

\param $array is a list, each element will be inserted in an 'li' tag
\param $class is the CSS class to use
\param $parameters is an associative array that can contain optionals xhtml parameters, 
	such as the current li tag $parameters["current"] that contains a string that match with the li content that will be set as current for CSS
*/
	function xhtml_ul($array, $class = -1, $parameters = array()) {

		$ul = & $this -> _xhtmldoc -> create_element("ul");
		if ($class != -1)
			$ul -> set_attribute("class", $class);
		$current = -1;
		if (array_key_exists("current", $parameters))
			$current = $parameters["current"];
		//$this->xhtml_message($current);
		if (is_array($array)) {
			reset($array);
			while (list ($i, $content) = each($array)) {
				//for ($i = 0; $i < count($array); $i++){
				// if ($array[$i] != "") {
				if ($content != "") {
					$li = & $this -> _xhtmldoc -> create_element("li");
					//$this->xhtml_insert($array[$i],$li);
					$this -> priv_xhtml_insert(utf8_ensure($content), & $li);
					if (strpos($content, $current) == true) {
						$li -> set_attribute("class", "current");

					}
					$ul -> append_child($li);
				}
			}
		}
		//$this->xhtml_insert();

		$this -> _currentnode -> append_child($ul);
	}
	
/** \brief inserts an li tag

\param $class is the CSS class to use
*/
	
	function new_li($class = -1) {
		$li = & $this -> _xhtmldoc -> create_element("li");
		if ($class != -1)
			$li -> set_attribute("class", $class);
		$this -> _currentnode -> append_child($li);
		$this -> _currentnode = & $li;
	}

/** \brief inserts an div tag that contains a message

\param $text the message to display
\param $class is the CSS class to use
*/
	function xhtml_message($text, $class = -1) {
		$this -> xhtml_insert_div($text, $class);
	}

/** \brief inserts an div tag that contains a message

\param $html_text the message to display
\param $class is the CSS class to use
*/
	function xhtml_insert_div($html_text, $class = -1) {
			// insert $html_div in the current node
		//$dom = domxml_new_doc("1.0");

	$div = & $this -> _xhtmldoc -> create_element("div");
		if ($class != -1) {
			$div -> set_attribute("class", $class);

		}

		if (!is_object($this -> _currentnode)) {
			echo ("ERROR: the field ".$html_text." is not consistent (xhtml_base object).");
			echo ("please contact the administrator");
			exit;
		}

		$this -> _currentnode -> append_child($div);

		$this -> priv_xhtml_insert(utf8_ensure($html_text), & $div);
		// $this->priv_xhtml_insert($html_text);
	}


/** \brief inserts an span tag that contains a message

\param $html_text the message to display
\param $class is the CSS class to use
*/
	function xhtml_insert_span($html_text, $class = -1) {
			// insert $html_div in the current node
		//$dom = domxml_new_doc("1.0");
	$div = & $this -> _xhtmldoc -> create_element("span");
		if ($class != -1) {
			$div -> set_attribute("class", $class);

		}
		$this -> _currentnode -> append_child($div);

		$this -> priv_xhtml_insert(utf8_ensure($html_text), & $div);
	}


/** \brief function to insert any xhtml tag, and its content

\param $tag the tag that will be created
\param $html_text the message to display
\param $class is the CSS class to use
*/
	function xhtml_insert_tag($tag, $html_text, $class = -1) {
		$div = & $this -> _xhtmldoc -> create_element($tag);
		if ($class != -1) {
			$div -> set_attribute("class", $class);

		}
		$this -> _currentnode -> append_child($div);

		$this -> priv_xhtml_insert(utf8_ensure($html_text), & $div);
	}

/** \brief private function to insert any text in a given node

\param $html_text the text to insert in the node
\param &$insert_node the reference of the node that will contain $html_text
*/	
	function priv_xhtml_insert($html_text, & $insert_node) {
		// insert $html_div in the current node
		if ($insert_node == -1) {
			$insert_node = & $this -> _currentnode;
		}
		$insert_node -> set_content($html_text);
	}

}
?>