<?php

/***************************************************************************
                    xhtml_page.inc  -
         object to manipulate xhtml page
                           -------------------
  begin                :  12/01/2004
  copyright            : (C) 2004 by Olivier Langella
  email                : langella@moulon.inra.fr
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *    modify it under the terms of the GNU Lesser General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 ***************************************************************************/

/* xhtml_page object interface:
//constructor, creates the xhtml document, with basic attibutes needed to
// produce valid xhtml code
xhtml_page()

//set the title of the xhtml page:
xhtml_page_set_title($title)
// add a CSS url reference for this xhtml page
xhtml_page_add_css($css)
// print the xhtml code to the output (usually, the remote browser)
xhtml_page_display()
*/


/** \brief object to generate a complete XHTML page
*
* this object creates an xml document and the basic xhtml elements to produce
* a well formed XHTML page:
* - html tag root
* - xml namespace
* - language used
* - header with title, icons, css
* - body
*/


class xhtml_page extends xhtml_zone {
	//var $_xhtmldoc;
	//var $_currentnode;
	/** \brief private: reference to the html root tag
	*/
	var $_root;
	/** \brief private: reference to the head tag
	*/
	var $_head;
	/** \brief private: reference to the title tag
	*/
	var $_head_title;

	/** \brief private: reference to the body tag
	*/
	var $_body;
	//var $_xpath;

	/** \brief constructor
	*
	* build the XHTML page from an xml document
	* set xml namespace, preferred language, content type, character set
	* creates basic tags: header with title, body
	*/
	function xhtml_page() { //constructor
		$this -> xhtml_zone();
		//$this -> _xhtmldoc = domxml_new_doc("1.0");
		
		$this -> _xhtmldoc = new oxml_document("1.0");

		$this -> _root = $this -> _xhtmldoc -> create_element("html");
		$this -> _xhtmldoc -> append_child($this -> _root);

		$this -> _root = &$this -> _xhtmldoc -> document_element();
		$this -> _root -> set_attribute("xmlns", "http://www.w3.org/1999/xhtml");
		$this -> _root -> set_attribute("xml:lang", "en");
		$this -> _root -> set_attribute("lang", "en");

		$this -> _head = &$this -> _xhtmldoc -> create_element("head");
		$node = $this -> _xhtmldoc -> create_element("meta");
		$node -> set_attribute("http-equiv", "Content-Type");
		$node -> set_attribute("content", "text/html; charset=iso-8859-1");

		$this -> _head -> append_child($node);
		$this -> _head_title = &$this -> _xhtmldoc -> create_element("title");
		$this -> _head -> append_child($this -> _head_title);

		$this -> _root -> append_child($this -> _head);
		$this -> _body = &$this -> _xhtmldoc -> create_element("body");
		$this -> _root -> append_child($this -> _body);

		$this -> _currentnode =&$this -> _body;

		$this -> _tab_nodes["ground0"] = &$this -> _body;
	}

	/** \brief set a title for this page
	*
	* \param $title the title of the page
	*/
	function xhtml_page_set_title($title) {
		//if ($this->_xhtmldoc->has_attribute("title"))
		//      $xpresult = xpath_eval($this->xpath, "/html/head/title");
		$this -> _head_title -> unlink_node();
		//$this -> _head_title = &$this -> _xhtmldoc -> create_element("title");
		//$this -> _head -> append_child($this -> _head_title);
		$this -> _head_title -> set_content(utf8_ensure($title));

	}

	/** \brief add an icon for this page
	*
	* \param $icon_ref the URL path to a picture file (png, jpg) 
	*/
	function xhtml_page_add_icon($icon_ref) {
		//<link rel ="stylesheet" href="./libcss/echantillons.css" type="text/CSS"/>
		$node = &$this -> _xhtmldoc -> create_element("link");
		$node -> set_attribute("rel", "shortcut icon");
		$node -> set_attribute("href", $icon_ref);
		$node -> set_attribute("type", "images/x-icon");
		//$node->set_content(utf8_ensure($title));
		$this -> _head -> append_child($node);
	}

	/** \brief add reference on a css file
	*
	* \param $css the URL path to a css file (Cascading Style Sheet)
	*/
	function xhtml_page_add_css($css) {
		//<link rel ="stylesheet" href="./libcss/echantillons.css" type="text/CSS"/>
		$node = &$this -> _xhtmldoc -> create_element("link");
		$node -> set_attribute("rel", "stylesheet");
		$node -> set_attribute("href", $css);
		$node -> set_attribute("type", "text/CSS");
		//$node->set_content(utf8_ensure($title));
		$this -> _head -> append_child($node);
	}

	/** \brief dump the xhtml_page object to a string
	*
	* the xhtml code is generated from the xml document. this code is sent to the browser and displayed
	*/
	function xhtml_page_display() {
		//last function to use un a script
		// $doctype = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//FR\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
		$doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">';
		$render = $this -> _xhtmldoc -> dump_mem_xhtml(1, "iso-8859-1", $doctype);
		echo $render;
	}

	/** \brief retrieve messages from the page
	* 
	* this retrieve all messages written to that page with the css class $css_class.
	* \param $css_class the css class of the messages to retrieve
	* \return a string each div separated by \n
	*/
	function retrieve_messages_to_string($css_class) {
		// not implemented at 14/1/2005
	}
}

?>
