/***************************************************************************
                          allele.h  -  description
                             -------------------
    begin                : Thu Sep 14 2000
    copyright            : (C) 2000 by Olivier Langella
    email                : Olivier.Langella@pge.cnrs-gif.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ALLELE_H
#define ALLELE_H

//#include "arbres.h"
#include "vecteurs.h"

using namespace std;

class Individu;
class Population;
class Allele;
class StrucPop;
class Locus;
class Jeupop;
class ConstGnt;

typedef biolib::vecteurs::ChaineCar ChaineCar;
//allle
class Allele {
public :
//	Allele();
	Allele(Locus*);
//	Allele(Locus*, const Allele &);
	Allele(const Allele &, Locus * Ploc);//constructeur de sopies
	Allele(Locus*, const char *);
	Allele(Locus*, const string &);
	~Allele();
	bool f_verifnum(int) const;

//	string& get_NomLocus();
	const string& get_Nom() const {return(_nom);};
	Locus * get_Ploc() const {return(_Ploc);};
	const string& get_nom() const {return(_nom);};
	const string& get_NomLocus() const;
	const unsigned int get_nbrepet() const{return(_nbrepet);};
	void set_nbrepet(unsigned int nbrepet) {_nbrepet = nbrepet;};

	void set_Plocus(Locus * Ploc) {_Ploc = Ploc;};
	void set_nom(const char * mot) {_nom = mot;};
	void set_nom(const ChaineCar& mot) {_nom = mot;};
	void set_idXML(const string& id) {_idXML = id;};

	const string& get_idXML() const {return(_idXML);};

  bool r_estnul() const {return(_miss);};
	bool r_nonnul() const {return(!_miss);};

	const Allele& operator= (const Allele &);
	bool operator== (const Allele & rval) const;

	friend class Locus;
	friend class Individu;
	friend class StrucPop;
	friend class Jeupop;
	friend class DistancesGnt;

private :
//	int _occurence; //nb d'occurences de cet allle dans le jeu de populations
	bool r_ismissingvalue(const string &) const;
	string _nom;
//	char _nomgpop[4];
	Locus * _Ploc;
	bool _miss; //missing value
	unsigned int _nbrepet; //specifique aux microsatellite: nombre de repetitions de motifs
//	int _nbind; //nb d'individus pourvus de cet allle
//	Individu ** _tabPind;
  string _idXML; //sert  la lecture et  l'criture en XML

};

#endif
