/***************************************************************************
                          fstat.cpp  -  bibliotheque permettant de calculer et de
																		prsenter les indices de Wright
                             -------------------
    begin                : Wed Oct 11 2000
    copyright            : (C) 2000 by Olivier Langella
    email                : Olivier.Langella@pge.cnrs-gif.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "fstat.h"

Fstat::Fstat(MetaPop * Pmetapop):_Pmetapop(Pmetapop) {
	_Pjeupop = _Pmetapop->get_Pjeu();
}

Fstat::~Fstat() {

}

void Fstat::f_affparlocus (ostream & sortie) const {

//affichage simple
	unsigned long nbloc (_Pjeupop->get_nbloc()),l;

	try {
		for (l=0;l < nbloc;l++) {
			sortie << "locus: " << _Pjeupop->get_nomlocus(l) << endl;
			sortie << "Fis: " << _Pmetapop->f_M_Fis(l);
			sortie << " Fst: " << _Pmetapop->f_M_Fst(l);

			sortie << " Fit: " << _Pmetapop->f_M_Fit(l) << endl << endl;
		}
	}
	catch (StrucPop::Anomalie lepb) {
		cerr << "exception dans strucpop: " << lepb.le_pb;
	}
}

void Fstat::f_calcFstFisFit (MatriceLD & matrice, const MetaPop * Pmetapop) const {
	
	unsigned long nbloc (_Pjeupop->get_nbloc()),l;

	matrice.resize(6,nbloc);
	
	//get_nbpop()
	
//	matrice._titre.push_back(_("generated by Populations "));
//	matrice._titre.back() += version_populations;
	matrice._titre.push_back(_("Fis, Fst, Fit for one population ("));
	if (Pmetapop == _Pmetapop) matrice._titre.back() += _("root");
	else matrice._titre.back() += Pmetapop->get_nom();
	matrice._titre.back() += _(") and ");
	matrice._titre.back().AjEntier(Pmetapop->get_nbpop());
	matrice._titre.back() += _(" subpopulations");
	matrice._titre.push_back(_("locus by columns"));
	matrice._titre.push_back(_("rows:"));
	matrice._titre.push_back(_("Fis"));
	matrice._titre.push_back(_("Fst"));
	matrice._titre.push_back(_("Fit"));
	matrice._titre.push_back(_("Ho --> observed heterozygosity (mean overall subpopulations)"));
	matrice._titre.push_back(_("Hs --> expected heterozygosity (mean overall subpopulations)"));
	matrice._titre.push_back(_("Ht --> total expected heterozygosity"));
	
	matrice.SetFlag(3);
	matrice.SetType(1);
	
	matrice._tlig[0] = "Fis";
	matrice._tlig[1] = "Fst";
	matrice._tlig[2] = "Fit";
	matrice._tlig[3] = "Ho";
	matrice._tlig[4] = "Hs";
	matrice._tlig[5] = "Ht";
//affichage simple

	try {
		for (l=0;l < nbloc;l++) {
			matrice._tcol[l] = _Pjeupop->get_nomlocus(l);
			matrice.GetCase(0,l) = Pmetapop->f_M_Fis(l);
			matrice.GetCase(1,l) = Pmetapop->f_M_Fst(l);
			matrice.GetCase(2,l) = Pmetapop->f_M_Fit(l);
			matrice.GetCase(3,l) = Pmetapop->f_Mheterozygotieobs(l);
			matrice.GetCase(4,l) = Pmetapop->f_Mheterozygotieatt(l);
			matrice.GetCase(5,l) = Pmetapop->f_Mheterozygotietotale(l);
			//sortie << "locus: " << _Pjeupop->get_nomlocus(l) << endl;
			//sortie << "Fis: " << _Pjeupop->_Pracinepops->f_M_Fis(l);
			//sortie << " Fst: " << _Pjeupop->_Pracinepops->f_M_Fst(l);

			//sortie << " Fit: " << _Pjeupop->_Pracinepops->f_M_Fit(l) << endl << endl;
		}
	}
	catch (StrucPop::Anomalie lepb) {
		cerr << "exception dans strucpop: " << lepb.le_pb;
	}
}

void Fstat::f_calcFstFisFit (JeuMatriceLD & matrices) const {
//calcul rcursif de toutes les Fst, Fis, Fit possibles (pour les populations hirarchises
	f_calcFstFisFit(matrices, _Pmetapop);

}

void Fstat::f_calcFstFisFit (JeuMatriceLD & matrices, const MetaPop * Pmetapop) const {
//calcul rcursif de toutes les Fst, Fis, Fit possibles (pour les populations hirarchises
	unsigned int i;


	// ajouter une matrice
	if (Pmetapop == _Pmetapop) matrices.push_back(new(MatriceLD), _("root"));
	else matrices.push_back(new(MatriceLD), Pmetapop->get_nom());
	
	
	//remplir la matrice
	f_calcFstFisFit (matrices.back(), Pmetapop);
	
	//on fait le reste:
	for (i=0; i < Pmetapop->get_nbmetapop(); i++) {
		f_calcFstFisFit (matrices, Pmetapop->get_tabPmetapop(i));
	}

}

