/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/

//================================================================
// Modified Brian Walenz's code. Provides methods for buffered I/O.
// VB 9/18/00
//===============================================================

#ifndef IBPEP_MS_NDX_BUFFEREDFILE_H
#define IBPEP_MS_NDX_BUFFEREDFILE_H

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <string>
#include "types.h"

class BufferedFile {
private:
  FILE* bufF;
  char* _buffer;
  int               _bufferMax;
  int               _bufferLen;
  int               _readPos;
  FILE_POSITION_TYPE _pos;
  FILE_SIZE_TYPE     _size;
public:
  BufferedFile(std::string const &, int buffersize=1024*1024);
  BufferedFile();
  ~BufferedFile();
  
  unsigned char     getCharacter(void);
  void openBuf(std::string const &fname);
  bool              isEndOfFile(void) const {
    return(_pos>=_size);
  }
  FILE_POSITION_TYPE getPos() const ;
  void setPos(FILE_POSITION_TYPE p);
  FILE_SIZE_TYPE getSize() const {
    return _size;
  }
  void reset();
};

#endif  //  BUFFEREDFILE_H
