/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/


#ifndef _IBPEP_EXACT_BASES_H
#define _IBPEP_EXACT_BASES_H

#include <iostream>
#include <utility>
#include <vector>
#include <map>
#include "char_io.h"
#include "keyword_tree.h"
#include "types.h"

#if !defined(NO_STD_NAMESPACE)
using namespace std;
#endif

class exact_bases : public PatternMatch {
private:
  PatternMatch *pm_;
  long unsigned int num_patterns_;
  unsigned int k_;
  unsigned char eos_;
  bool _wc;
  bool _textn;
  bool _indels;
  long unsigned int _mpl;
  std::vector<std::string> rempat_;
  std::vector<bool> prefix_;
  std::vector<pattern_list::const_iterator> plit_;
public:
  exact_bases(PatternMatch *pm,
	      unsigned int k=0, unsigned char eos='\n', 
	      bool wc=false, bool tn=false, bool indels=true);
  exact_bases(PatternMatch *pm);
  ~exact_bases();
  long unsigned int add_pattern(std::string const & pat, unsigned long id=0,
				int esb=0, int eeb=0);
  bool find_patterns(CharacterProducer & cp, 
		     pattern_hit_vector & kas,
		     long unsigned minka=1);
  void init(CharacterProducer & cp);
  void reset();
  unsigned int mismatches() const;
  void mismatches(unsigned int k);
  bool wildcards() const;
  void wildcards(bool wc);
  bool wildcard_text_N() const;
  void wildcard_text_N(bool tn);
  bool indels() const;
  void indels(bool tn);
  unsigned char eos_char() const;
  void eos_char(unsigned char c);
};

#endif


