/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/

#ifndef IBPEP_MMAPUTIL_H
#define IBPEP_MMAPUTIL_H

#include "types.h"

class MapFile {

 public:
  unsigned char *fileString;
  FILE_SIZE_TYPE mapsize;
  MapFile();
  MapFile(const char *filename);
  virtual ~MapFile();
  void createMap(const char *filename);
  unsigned char * const & file_string() const {
    return fileString;
  }
  FILE_SIZE_TYPE map_size() const {
    return mapsize;
  }
  inline bool endOfFile() const {
    return(_pos>=mapsize);
  }
  inline bool endOfFile(const FILE_POSITION_TYPE pos) const {
    return(pos>=mapsize);
  }
  inline FILE_SIZE_TYPE size() const {
    return mapsize;
  }
  inline signed char readCharacter() const{
    if (_pos < mapsize)
      return fileString[_pos];
    else return(-1);
  }
  inline char readCharacter( FILE_POSITION_TYPE const indx) const {
    if (indx < mapsize-1) 
      return fileString[indx];
    else 
      return fileString[mapsize-1];
  }


  inline char getCharacter () {
#ifdef CHECK_GETCHARACTER
    if (_pos < mapsize)
      return fileString[_pos++];
    else
      return -1;
#else
    return  fileString[_pos++];
#endif
  }

  inline char getCharacter (FILE_POSITION_TYPE indx) const {
#ifdef CHECK_GETCHAR
    if (indx < mapsize - 1)
      return  fileString[indx];
    else
      return  fileString[mapsize-1];
#else
    return  fileString[indx];
#endif
  }

  int setPos(const FILE_POSITION_TYPE);
  FILE_POSITION_TYPE getPos() const{
    return _pos;
  }
  virtual void reset() {
    _pos=0;
  }
 protected:
  FILE_POSITION_TYPE _pos;
  
};

#endif  //  MMAPUTIL_H

