/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/


#ifndef _SELECT_T
#define _SELECT_T_

#include "util.h"
#include "fasta_io.h"
#include "fasta_io.t"

template<class H>
FastaFile<H> * pick_fasta_file(std::string database,
			       int ffselect,
			       bool memmap,
			       bool alignments,
			       bool uc,
			       char eos_char,
			       bool verbose) {
  FastaFile<H> * ff=0;
  if ((ffselect == 0 && exist(database+".sqn")) || ffselect == 3) {
    if (verbose) timestamp("Normalized sequence database...");
    if (memmap) {
      ff = new IndexedFastaFile<Normalized<MapFileChars>,H>(database,alignments);
      if (verbose) timestamp("Using mmap for sequence I/O...");
    } else {
      ff = new IndexedFastaFile<Normalized<BufferedFileChars>,H>(database,alignments);
      if (verbose) timestamp("Not using mmap for sequence I/O...");
    }
  } else if ((ffselect == 0 && exist(database+".sqz")) || ffselect == 4) {
    if (verbose) timestamp("Compressed sequence database...");
    if (memmap) {
      ff = new IndexedFastaFile<Compressed<MapFileChars>,H>(database,alignments);
      if (verbose) timestamp("Using mmap for sequence I/O...");
    } else {
      ff = new IndexedFastaFile<Compressed<BufferedFileChars>,H>(database,alignments);
      if (verbose) timestamp("Not using mmap for sequence I/O...");
    }
  } else if ((ffselect == 0 && exist(database+".seq")) || ffselect == 2) {
    if (verbose) timestamp("Indexed sequence database...");
    if (memmap) {
      ff = new IndexedFastaFile<MapFileChars,H>(database,alignments);
      if (verbose) timestamp("Using mmap for sequence I/O...");
    } else {
      ff = new IndexedFastaFile<BufferedFileChars,H>(database,alignments);
      if (verbose) timestamp("Not using mmap for sequence I/O...");
    }
  } else { /* either all files didn't exist or ffselect == 1 */
    if (verbose) timestamp("Raw sequence database...");
    if (memmap) {
      ff = new StreamedFastaFile<MapFileChars,H>(database,
							 alignments,
							 uc,
							 eos_char);
      if (verbose) timestamp("Using mmap for sequence I/O...");
    } else {
      ff = new StreamedFastaFile<BufferedFileChars,H>(database,
							      alignments,
							      uc,
							      eos_char);
      if (verbose) timestamp("Not using mmap for sequence I/O...");
    }
  }
  return ff;
}
  
#endif

