/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/


#ifndef _IBPEP_UTIL_H_
#define _IBPEP_UTIL_H_

#include "types.h"

unsigned int least_common_multiple(unsigned int a, unsigned int b);
bool is_true(char const * const s);
bool is_false(char const * const s);

#include <string>

void uppercase(std::string & s);
std::string reverse_comp(std::string const & sequence);

char iupac_revcomp(char);
bool iupac_contains(char,char);
bool iupac_contained(char,char);
bool iupac_compatible(char,char);
char *iupac_contains(char);
char *iupac_contained(char);
char *iupac_compatible(char);

double monomolwt(char);
double avemolwt(char);

#define bigword long unsigned int

std::string binarystr(bigword val, int length);
std::string binary(long unsigned int val);
std::string binary(long long unsigned int val);
std::string binary(unsigned char val);

bool exist(std::string const & filename);
time_t modtime(std::string const & filename);

int anypos(std::string const & s0, std::string const & s1, int pos=0);

#ifdef PROFILE
void set_profile_signal_handler();
#endif

#include <stdio.h>
#include <time.h>
#include <string.h>
#define timestamp(m) { time_t t(time(NULL)); ASCTIME(s,localtime(&t)); fprintf(stderr,"[%24.*s] %s\n",(int)strlen(s)-1,s,(m));}
#define timestampli(m,v) { time_t t(time(NULL)); ASCTIME(s,localtime(&t)); fprintf(stderr,"[%24.*s] %s%ld\n",(int)strlen(s)-1,s,(m),(v));}
#define timestampi(m,v) { time_t t(time(NULL)); ASCTIME(s,localtime(&t)); fprintf(stderr,"[%24.*s] %s%d\n",(int)strlen(s)-1,s,(m),(v));}
#define timestampd(m,v) { time_t t(time(NULL)); ASCTIME(s,localtime(&t)); fprintf(stderr,"[%24.*s] %s%g\n",(int)strlen(s)-1,s,(m),(v));}
#define checkpoint { time_t t(time(NULL)); ASCTIME(s,localtime(&t)); fprintf(stderr,"[%24.*s] Checkpoint %s:%d.\n",(int)strlen(s)-1,s,__FILE__,__LINE__); }

extern time_t tictoctime_;
#define tic {tictoctime_ = time(NULL);}
#define toc { time_t t; time(&t); t-=tictoctime_; fprintf(stderr,"Elapsed time: %d:%02d:%02d\n",t/3600,(t%3600)/60,t%60);} 
#define tocassgn(tsec) { time_t t; time(&t); t-=tictoctime_; fprintf(stderr,"Elapsed time: %ld:%02ld:%02ld\n",t/3600,(t%3600)/60,t%60); tsec = t;} 

#endif

