/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.browsing;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.browsing.BrowserManager;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BrowserOptionPanel
extends AbstractModulePanel {
    BrowserManager browserManager = null;
    private JCheckBox allNamespaceConditionCheckBox = null;
    private JCheckBox collapseDatatypesCheckBox = null;
    JCheckBox useLabelsCheckBox = null;
    JCheckBox splitPropertiesCheckBox = null;
    JList splitPropertiesList = null;
    JTextArea splitPropertyArea = null;
    JTextArea splitPropertiesTextArea = null;
    JButton splitPropertiesButton = null;

    public BrowserOptionPanel(BrowserManager browserManager) {
        this.browserManager = browserManager;
        this.redLightText = "<html>This should not happen! You are experiencing problems here... please report!</html>";
        this.yellowLightText = "<html>This should not happen! You are experiencing problems here... please report!</html>";
        this.greenLightText = "<html>You can always specify browsing options</html>";
        this.myTabText = "Representation of ontologies in Cytoscape";
        this.myTabTooltip = "<html>Specify features of the representation of ontologies in Cytoscape (see Help for details)</html>";
        this.allNamespaceConditionCheckBox = new JCheckBox("Namespace selection in and", this.browserManager.isNamespaceSelectionInAnd());
        this.collapseDatatypesCheckBox = new JCheckBox("Treat datatypes as attributes", this.browserManager.isCollapseAttributesTrue());
        this.useLabelsCheckBox = new JCheckBox("Use labels instead of URIs");
        this.splitPropertiesCheckBox = new JCheckBox("Treat some URI as multiple nodes");
        this.splitPropertiesTextArea = new JTextArea(20, 60);
        JScrollPane jScrollPane = new JScrollPane(this.splitPropertiesTextArea);
        this.splitPropertiesButton = new JButton("Commit");
        this.allNamespaceConditionCheckBox.setToolTipText("If on, when extending a network, both properties and objects must be in selected namespaces. If off, onw of the two will suffice.");
        this.collapseDatatypesCheckBox.setToolTipText("If on, datatype properties will be treated as attributes in a raph representation.");
        this.allNamespaceConditionCheckBox.addActionListener(new allNamespaceConditionBoxListener());
        this.collapseDatatypesCheckBox.addActionListener(new collapseDatatypesCheckBoxListener());
        this.useLabelsCheckBox.addActionListener(new useLabelsCheckBoxListener());
        this.splitPropertiesCheckBox.addActionListener(new splitCheckBoxListener());
        this.splitPropertiesButton.addActionListener(new splitPropertiesButtonListener());
        this.splitPropertyArea = new JTextArea();
        this.add(this.allNamespaceConditionCheckBox);
        this.add(this.collapseDatatypesCheckBox);
        this.add(this.useLabelsCheckBox);
        this.add(this.splitPropertiesCheckBox);
        this.add(jScrollPane);
        this.add(this.splitPropertiesButton);
        this.splitPropertiesButton.setEnabled(false);
        this.splitPropertiesTextArea.setEnabled(false);
    }

    public void refreshAfterKnowledgeChange() {
        if (!this.browserManager.canCollapseDatatypes()) {
            this.collapseDatatypesCheckBox.setEnabled(false);
        }
        if (!this.browserManager.canExtend()) {
            this.allNamespaceConditionCheckBox.setEnabled(false);
        }
        if (!this.browserManager.canHandleLabels()) {
            this.useLabelsCheckBox.setEnabled(false);
        }
        if (!this.browserManager.canHandleSplit()) {
            this.splitPropertiesCheckBox.setEnabled(false);
            this.splitPropertiesTextArea.setEnabled(false);
        }
    }

    public void setSplitConditions(String string) {
        this.splitPropertiesTextArea.setText(string);
    }

    @Override
    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/HowToTuneVisualizationOptions";
    }

    @Override
    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("<html>When browsing an ontology in a cytoscape network, visible alternatives are determined on the basis of whichnamespaces have been selected as <i>visible</i>.By enabling this option, only statements where <i>both the predicate and the object (or subject)</i> are in selected namespaces will be presented. <br></html>", Utilities.getHelpIcon("namespaceSelectionInAnd.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html><br>When this option is selected, when a resource is selected all of its datatype properties (for which a value is asserted) are added to the node as attributes.<br>Note that datatypes properties are anyway presented while browsing.</html>", Utilities.getHelpIcon("treatDatatypesAsAttributes.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html> Add the object of the properties rddf:label as a label, instead of the URI of the node</html>", Utilities.getHelpIcon("useLabelsInsteadOfURIs.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>It is possible to specifiy conditions under which some URIs should be visualized with a distinct node each time they are added to the network.The most notable application of this is the visualization of currency metabolites.<br>To specify this URIs, an RDQL query (for more infos refer to the help pages available on the web) yielding the results that should follow this behaviour must be specified.<br>This query will act after the checkbox is selected one more time (activate checkbox, input query, <b>commit</b> query, de-activate and re-activate the option).<br>This functinality is meant to be a-priori implemented in an analysis context.</html>", Utilities.getHelpIcon("treatSomeURIsAsMultipleNodes.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        return jPanel;
    }

    @Override
    public String getPanelName() {
        return "Browsing options";
    }

    @Override
    public int getStatusLevel() {
        return 3;
    }

    @Override
    public void refresh() {
    }

    private class splitPropertiesButtonListener
    implements ActionListener {
        private splitPropertiesButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.browserManager.setSplitConditions(BrowserOptionPanel.this.splitPropertiesTextArea.getText());
        }
    }

    private class splitCheckBoxListener
    implements ActionListener {
        private splitCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.splitPropertiesButton.setEnabled(BrowserOptionPanel.this.splitPropertiesCheckBox.isSelected());
            BrowserOptionPanel.this.splitPropertiesTextArea.setEnabled(BrowserOptionPanel.this.splitPropertiesCheckBox.isSelected());
            BrowserOptionPanel.this.browserManager.setEnableSplit(BrowserOptionPanel.this.splitPropertiesCheckBox.isSelected());
        }
    }

    private class useLabelsCheckBoxListener
    implements ActionListener {
        private useLabelsCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.browserManager.setUseLabels(BrowserOptionPanel.this.useLabelsCheckBox.isSelected());
        }
    }

    private class collapseDatatypesCheckBoxListener
    implements ActionListener {
        private collapseDatatypesCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.browserManager.setCollapseAttributes(BrowserOptionPanel.this.collapseDatatypesCheckBox.isSelected());
        }
    }

    private class allNamespaceConditionBoxListener
    implements ActionListener {
        private allNamespaceConditionBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserOptionPanel.this.browserManager.setNamespaceSelectionInAnd(BrowserOptionPanel.this.allNamespaceConditionCheckBox.isSelected());
        }
    }
}

