/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.browsing;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.browsing.BrowserManager;
import fr.pasteur.sysbio.rdfscape.browsing.ResultTableViewer;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.JenaQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.MyQueryEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class BrowserPanel
extends AbstractModulePanel {
    private BrowserManager browserManager = null;
    private JComboBox queryEnginesBox = null;
    private Hashtable queryEngines = null;
    private JButton editNetworkButton = null;
    private JButton getNetworkPatternButton = null;
    private JButton newNetworkButton = null;
    private JButton makeQueryButton = null;
    private JButton clearQueryButton = null;
    private JButton selectAll = null;
    private JButton plotSelection = null;
    private JButton searchSelection = null;
    private ResultTableViewer resultTable = null;
    private AbstractQueryResultTable queryResult = null;
    private JPanel upPanel = null;
    private JComponent currentQueryPanel = null;
    private MyQueryEngine currentQueryEngine = null;
    private BrowseModeListener browseModeListener = null;
    private JPanel northPanel = null;
    private JPanel patternPanel = null;
    private JPanel newNetworkPanel = null;

    public BrowserPanel(BrowserManager browserManager) {
        this.browserManager = browserManager;
        this.browseModeListener = new BrowseModeListener();
        this.redLightText = "<html>No ontologies correctly loaded are present</html>";
        this.yellowLightText = "<html>This should not happen... please report it!</html>";
        this.greenLightText = "<html>Ontologies present (to browse ontologies you need to plot something first)</html>";
        this.myTabText = "4) Query and browse ontologies";
        this.myTabTooltip = "<html>Query ontologies, plot results (create a graph first!), browse ontologies, extract patterns</html>";
        this.editNetworkButton = new JButton("Make Editable");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.browserManager.setEditable();
            }
        };
        this.editNetworkButton.addActionListener(actionListener);
        this.getNetworkPatternButton = new JButton("Get Pattern");
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog("Insert pattern name : ");
                if (string != null) {
                    BrowserPanel.this.browserManager.getSnapshot(string);
                }
            }
        };
        this.getNetworkPatternButton.addActionListener(actionListener2);
        this.newNetworkButton = new JButton("Create new network");
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.browserManager.makeNewCytoscapePanel((String)BrowserPanel.this.queryEnginesBox.getSelectedItem());
            }
        };
        this.newNetworkButton.addActionListener(actionListener3);
        this.newNetworkPanel = new JPanel();
        this.newNetworkPanel.setBorder(new TitledBorder("Network"));
        this.newNetworkPanel.add(this.newNetworkButton);
        this.patternPanel = new JPanel();
        this.patternPanel.setBorder(new TitledBorder("Pattern definition"));
        this.patternPanel.add(this.editNetworkButton);
        this.patternPanel.add(this.getNetworkPatternButton);
        this.resultTable = new ResultTableViewer();
        this.makeQueryButton = new JButton("Make Query");
        this.clearQueryButton = new JButton("Clear Query");
        this.selectAll = new JButton("Select All");
        this.plotSelection = new JButton("Plot Selection");
        this.searchSelection = new JButton("Search Selection");
        this.makeQueryButton.addActionListener(new QueryExecListener());
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.resultTable.selectAll();
            }
        };
        this.clearQueryButton.addActionListener(new ClearButtonListener());
        this.selectAll.addActionListener(actionListener4);
        this.plotSelection.addActionListener(new PlotSelectionListener());
        this.searchSelection.addActionListener(new SearchSelectionListener());
        this.upPanel = new JPanel();
        this.upPanel.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new GridLayout(1, 3));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 5));
        jPanel.add(this.makeQueryButton);
        jPanel.add(this.clearQueryButton);
        jPanel.add(this.selectAll);
        jPanel.add(this.plotSelection);
        jPanel.add(this.searchSelection);
        this.upPanel.add((Component)this.northPanel, "North");
        this.upPanel.add((Component)jPanel, "South");
        this.currentQueryPanel = new JPanel();
        this.upPanel.add((Component)this.currentQueryPanel, "Center");
        this.setLayout(new GridLayout(2, 1));
        this.add(this.upPanel);
        JScrollPane jScrollPane = new JScrollPane(this.resultTable);
        jScrollPane.setBorder(new TitledBorder("Results"));
        this.add(jScrollPane);
        this.initBrowseOptions();
        this.northPanel.add(this.queryEnginesBox);
        this.northPanel.add(this.newNetworkPanel);
        this.northPanel.add(this.patternPanel);
    }

    private void initBrowseOptions() {
        ArrayList arrayList = this.browserManager.getAvailableQueryElements();
        System.out.println("Available query engines: " + arrayList.size());
        this.queryEngines = new Hashtable();
        if (arrayList.size() == 0) {
            System.out.println("case 0");
            String[] stringArray = new String[]{"NO QUERY AVAILABLE"};
            this.queryEnginesBox = new JComboBox<String>(stringArray);
            this.queryEnginesBox.setBorder(new TitledBorder("Query mode"));
            this.queryEnginesBox.setEnabled(false);
            this.currentQueryEngine = null;
            if (this.currentQueryPanel != null) {
                this.upPanel.remove(this.currentQueryPanel);
                this.currentQueryPanel = new JPanel();
                this.upPanel.add((Component)this.currentQueryPanel, "Center");
            }
            this.makeQueryButton.setEnabled(false);
            this.clearQueryButton.setEnabled(false);
            this.plotSelection.setEnabled(false);
            this.searchSelection.setEnabled(false);
            this.selectAll.setEnabled(false);
            System.out.println("case 0 completed");
            return;
        }
        int n = 0;
        String[] stringArray = new String[arrayList.size()];
        for (MyQueryEngine myQueryEngine : arrayList) {
            this.queryEngines.put(myQueryEngine.getLabel(), myQueryEngine);
            stringArray[n] = myQueryEngine.getLabel();
            ++n;
        }
        this.queryEnginesBox = new JComboBox<String>(stringArray);
        this.queryEnginesBox.setBorder(new TitledBorder("Browse mode"));
        this.queryEnginesBox.addActionListener(this.browseModeListener);
        this.makeQueryButton.setEnabled(true);
        this.clearQueryButton.setEnabled(true);
        this.plotSelection.setEnabled(true);
        this.searchSelection.setEnabled(true);
        this.selectAll.setEnabled(true);
        this.queryEnginesBox.setSelectedIndex(0);
        this.currentQueryEngine = (MyQueryEngine)this.queryEngines.get((String)this.queryEnginesBox.getSelectedItem());
        this.currentQueryPanel = this.currentQueryEngine.getPanel();
    }

    public void reset() {
        this.resetQuery();
    }

    public void resetQuery() {
        Enumeration enumeration = this.queryEngines.elements();
        while (enumeration.hasMoreElements()) {
            ((MyQueryEngine)enumeration.nextElement()).reset();
        }
        this.resultTable.setModel(new JenaQueryResultTable());
    }

    public void refreshAfterEngineChange() {
        this.northPanel.remove(this.queryEnginesBox);
        this.northPanel.remove(this.newNetworkPanel);
        this.northPanel.remove(this.patternPanel);
        this.initBrowseOptions();
        this.resetQuery();
        this.northPanel.add(this.queryEnginesBox);
        this.northPanel.add(this.newNetworkPanel);
        this.northPanel.add(this.patternPanel);
    }

    @Override
    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/HowToBrowseAndQueryOntologies";
    }

    @Override
    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("<html>Use this panel to select a query mode. Available queries are SPARQL, RDQL, String based and class based.</html>", Utilities.getHelpIcon("queryModeSelection.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>The <b>SPARQL</b> query option present a panel where to input the text of the SPARQL query (SELECT).<b> The text is initialized with a template for the query, with the prefixes associated to namespaces in the preference panel. <br>The <b>RDQL</b> option is equivalent, but it present the text for the older RDQL language.</html>", Utilities.getHelpIcon("sparqlQueryPanel.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel(Utilities.getHelpIcon("stringQueryPanel.png"));
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jLabel = new JLabel("<html>This query method supports string based search. <br>All resources whose URI (or the object of one of its property) matches the given string are returned.<br>When <b>approx</b> is checked, substring matching is used instead of string matching. <i>We recommend tha you check this option in most of the cases</i></html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel(Utilities.getHelpIcon("classQueryPanel.png"));
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jLabel = new JLabel("<html>For ontologies specified in OWL, this query panel allows to select a class, and the relative querty returns all of its instances. <br><b>notes:</b><ul><li>If the ontology is not specified in OWL, the list of classes will be empty</li><li>You need to <b>clear</b> the query in order for the list of classes to be initialized</li><li>Make sure the appropraite level of reasoning is selected (at least RDFS-2 if you want transitive is-A relations to be resolved)</li></ul></html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Once you have specified a query in the above panel, <b>make Query</b> will perform the query and display the results in the box below(note that color and visibility of results dependends on namespaces as specifies in the relative preference panel. Note also that blank nodes display in light gray)<br>You can at this point select rows directly on the table. A Button <b>Select All</b> is a shortcut to select all results displayed on  the table.<br><b>Clear query</b> reset the query panel and clear the list of results.<br>It is the selection of results (and not the results themselves) that is objet of subsequent manipulation, like searching and plotting in a network.</html>", Utilities.getHelpIcon("makeClearSelectQueryButtons.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>You need to create a network in Cytoscape in order to plot your results there. This is the function of this button.<br>Note that networks created by RDFScape (via the <b>create new network</b> button) and networks created in Cytoscape are not equivalent.<br>A network created within Cytoscape can be \"understood\" by RDFScape after <b>Map</b> in <b>Map ontologies on my network</b> is performed.<br>If the use of RDFScape is only to browse and query ontologies, we suggest to only use networks created through RDFScape.</html>", Utilities.getHelpIcon("createNetworkButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Plot the selected entries on the network. Blank nodes and literals will not be plotted, and properties will be plotted as resources.</html>", Utilities.getHelpIcon("plotSelectionButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Serach the selected entries in teh current network (this does not apply to literals and blank nodes)</html>", Utilities.getHelpIcon("searchSelectionButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html><h2>Browsing the ontology content</h2>Once a network is originated from RDFScape (or after a  <b>Map</b> action in <b>Map ontologies on my network</b>, right selecting one node will prompt a menu that will make possible its iterative expansion.<br>This provides <i>browsing</b> of the ontology context, as it expand the network via related resources.</html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel(Utilities.getHelpIcon("exampleBrowsing.png"), 0);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 300));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html><b>Make editable</b> adds new entries to the context-sensitive (right click) menu. In particular for both nodes and edges it makes possible to declare them as variables. <br>When <b>Get Pattern</b> is selected, the current network (with variables) is taken as a pattern or visual query, and it appears in the <b>Pattern Library</b> section of RDFScape.<br>Refer to this section for help on how to use patterns.</html>", Utilities.getHelpIcon("patternDefinitionPanel.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Example of variable definition in RDFScape. Note that both nodes and edges can be declared as variables. For labels, a filter (regular expression) can be associated to the varibale. For instance a label made a variable with the filter /P53/ will match in thequery all labels including the string \"P53\".<br>Variable can be converted back to standard nodes.<br><font color=red>Note: variables are restored as nodes if their original nodes are plotted again to the network.</red></html>", Utilities.getHelpIcon("patternEditExample.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 380));
        jPanel.add(jLabel);
        return jPanel;
    }

    @Override
    public String getPanelName() {
        return "Browse and Query";
    }

    @Override
    public int getStatusLevel() {
        if (!RDFScape.getOntologyManager().ontologiesPresentAndCorrectlyLoaded()) {
            return 1;
        }
        return 3;
    }

    @Override
    public void refresh() {
        this.resetQuery();
    }

    private class SearchSelectionListener
    implements ActionListener {
        String[] myNodesStringArray = null;

        private SearchSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BrowserPanel.this.queryResult == null) {
                System.out.println("No query to search");
                return;
            }
            if (BrowserPanel.this.queryResult.getRowCount() == 0) {
                System.out.println("Nothing to search at all ");
                return;
            }
            if (BrowserPanel.this.queryResult.hasGraph()) {
                System.out.println("Graph results are unsupported yet");
            }
            if (BrowserPanel.this.queryResult.hasTable()) {
                System.out.println("I've seen you have selected " + BrowserPanel.this.resultTable.getSelectedRowCount() + " rows");
                BrowserPanel.this.browserManager.searchValuesInResultTable(BrowserPanel.this.queryResult.getSubsetByRows(BrowserPanel.this.resultTable.getSelectedRows()));
            }
        }
    }

    private class PlotSelectionListener
    implements ActionListener {
        String[] myNodesStringArray = null;

        private PlotSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BrowserPanel.this.queryResult == null) {
                System.out.println("No query to plot");
                return;
            }
            if (BrowserPanel.this.queryResult.getRowCount() == 0) {
                System.out.println("Nothing to plot at all ");
                return;
            }
            if (BrowserPanel.this.queryResult.hasGraph()) {
                System.out.println("Graph results are unsupported yet");
            }
            if (BrowserPanel.this.queryResult.hasTable()) {
                System.out.println("I've seen you have selected " + BrowserPanel.this.resultTable.getSelectedRowCount() + " rows");
                BrowserPanel.this.browserManager.plotValuesInResultTable(BrowserPanel.this.queryResult.getSubsetByRows(BrowserPanel.this.resultTable.getSelectedRows()));
            }
        }
    }

    private class QueryExecListener
    implements ActionListener {
        private QueryExecListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserPanel.this.queryResult = BrowserPanel.this.currentQueryEngine.makeQuery();
            BrowserPanel.this.resultTable.setModel(BrowserPanel.this.queryResult);
        }
    }

    private class ClearButtonListener
    implements ActionListener {
        private ClearButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserPanel.this.resetQuery();
        }
    }

    private class BrowseModeListener
    implements ActionListener {
        private BrowseModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Something changed");
            if (BrowserPanel.this.queryEngines == null) {
                return;
            }
            String string = (String)BrowserPanel.this.queryEnginesBox.getSelectedItem();
            System.out.println("Changing query engine to :" + string);
            if (BrowserPanel.this.queryEngines == null) {
                System.out.println("No query engines yet.");
                return;
            }
            MyQueryEngine myQueryEngine = (MyQueryEngine)BrowserPanel.this.queryEngines.get(string);
            if (BrowserPanel.this.currentQueryEngine == myQueryEngine) {
                System.out.println("... I already had it as deafult. Nothing done.");
                return;
            }
            BrowserPanel.this.upPanel.remove(BrowserPanel.this.currentQueryPanel);
            BrowserPanel.this.currentQueryEngine = myQueryEngine;
            BrowserPanel.this.currentQueryPanel = myQueryEngine.getPanel();
            BrowserPanel.this.upPanel.add((Component)BrowserPanel.this.currentQueryPanel, "Center");
            BrowserPanel.this.updateUI();
            BrowserPanel.this.validate();
        }
    }
}

