/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.context;

import fr.pasteur.sysbio.rdfscape.DefaultSettings;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ContextElement {
    private RDFScape myRDFScapeInstance = null;
    private String myPath = null;
    private String myName = null;
    private String errors = null;
    File myFile = null;

    public ContextElement(String string) {
        this.myPath = string;
        this.myFile = new File(this.myPath);
        this.myName = this.myFile.getName();
        if (!this.myFile.exists()) {
            System.out.println("Making default context. Name= " + this.myName);
            this.makeDefault();
        }
    }

    private void makeDefault() {
        Object object;
        Object object2;
        this.myFile.mkdir();
        String string = this.myFile.getAbsolutePath();
        String string2 = string + "/ontologies";
        String string3 = string + "/namespaces";
        String string4 = string + "/infsettings";
        String string5 = string + "/splitinfo";
        File file = new File(string4);
        try {
            object2 = new FileWriter(file);
            object = DefaultSettings.defaultKnowledgeEngine;
            if (!((String)object).equalsIgnoreCase("Jena")) {
                System.out.println("Only Jena is supported as default. Check your default settings");
                return;
            }
            ((Writer)object2).write("Engine: " + DefaultSettings.defaultKnowledgeEngine + "\n");
            ((OutputStreamWriter)object2).close();
        }
        catch (Exception exception) {
            System.out.println("Unable to write default");
        }
        object2 = string + "/infrules";
        object = new File((String)object2);
        ((File)object).mkdir();
        String string6 = string + "/patterns";
        File file2 = new File(string6);
        file2.mkdir();
        String string7 = string + "/maprules";
        File file3 = new File(string7);
        file3.mkdir();
    }

    public String getName() {
        return this.myName;
    }

    public void delete() {
        String string = this.myFile.getAbsolutePath();
        System.out.println("Deleting..." + string);
        String string2 = string + "/ontologies";
        File file = new File(string2);
        ContextElement.deleteDir(file);
        String string3 = string + "/namespaces";
        File file2 = new File(string3);
        file2.delete();
        String string4 = string + "/infsettings";
        File file3 = new File(string4);
        file3.delete();
        String string5 = string + "/infrules";
        File file4 = new File(string5);
        ContextElement.deleteDir(file4);
        String string6 = string + "/patterns";
        File file5 = new File(string6);
        ContextElement.deleteDir(file5);
        String string7 = string + "/maprules";
        File file6 = new File(string7);
        ContextElement.deleteDir(file6);
        this.myFile.delete();
    }

    public String getOntologiesListFileName() {
        return this.myPath + "/ontologies";
    }

    public String getNamespacesListFileName() {
        return this.myPath + "/namespaces";
    }

    public String getReasoningSettingsFileName() {
        return this.myPath + "/infsettings";
    }

    public String getReasoningInfRulesDirName() {
        return this.myPath + "/infrules";
    }

    public String getDefaultMapDirName() {
        return this.myPath + "/maprules";
    }

    public String getPatternsDirName() {
        return this.myPath + "/patterns";
    }

    public boolean check() {
        return new File(this.getReasoningSettingsFileName()).exists();
    }

    public Object getErrorString() {
        return this.errors;
    }

    private static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = ContextElement.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public String getSplitConditionsFileName() {
        return this.myPath + "/splitinfo";
    }
}

