/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.context;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.DefaultSettings;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RDFScapeModuleInterface;
import fr.pasteur.sysbio.rdfscape.context.ContextElement;
import fr.pasteur.sysbio.rdfscape.context.ContextManagerPanel;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ContextManager
implements RDFScapeModuleInterface {
    private ContextElement activeContext = null;
    private ContextManagerPanel myPanel = null;
    private Hashtable<String, ContextElement> availableContextElements = null;
    private String contextDirectory = null;
    private ArrayList<Contextualizable> modulesHandled = null;

    public ContextManager() {
        System.out.println("<CONTEXT MANAGER>");
        this.modulesHandled = new ArrayList();
        if (this.initialize()) {
            System.out.println("Ok");
        } else {
            System.out.println("Ko");
        }
        System.out.println("</CONTEXT MANAGER>");
    }

    public void addContextualizableElement(Contextualizable contextualizable) {
        this.modulesHandled.add(contextualizable);
    }

    @Override
    public boolean initialize() {
        System.out.println("Looking for contexts...");
        this.availableContextElements = new Hashtable();
        this.contextDirectory = DefaultSettings.contextsDirectory;
        String string = System.getProperty("user.dir") + "/" + this.contextDirectory;
        System.out.println("Context directory= " + string);
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Context directory is missing. Trying to make it now.");
            file.mkdir();
            if (!file.exists()) {
                System.out.println("Unable to make directory");
                return false;
            }
        }
        int n = 0;
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        for (n = 0; n < fileArray.length; ++n) {
            System.out.println("Looking for context in " + fileArray[n].getPath());
            ContextElement contextElement = new ContextElement(fileArray[n].getPath());
            if (contextElement.check()) {
                this.availableContextElements.put(fileArray[n].getName(), contextElement);
                System.out.println("Found a valid context, added to the list of available contexts.");
                continue;
            }
            System.out.print(fileArray[n].getName() + "Context had errors: ");
            System.out.println(contextElement.getErrorString());
        }
        System.out.println("No more contexts");
        if (this.isInValidState()) {
            System.out.println("Setting default context");
            this.activeContext = this.availableContextElements.elements().nextElement();
            return true;
        }
        System.out.println("No contexts found, making a new context and starting again. If I hang here, complain for poor design...");
        this.activeContext = new ContextElement(file + "/default");
        return this.initialize();
    }

    @Override
    public void reset() {
        this.initialize();
    }

    public boolean isInValidState() {
        return this.availableContextElements.size() > 0;
    }

    public String[] getAvailableContextsNames() {
        int n = this.availableContextElements.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        Enumeration<String> enumeration = this.availableContextElements.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n2] = enumeration.nextElement();
            ++n2;
        }
        System.out.println("#context elements' names " + n2);
        return stringArray;
    }

    ContextElement getContextByName(String string) {
        return this.availableContextElements.get(string);
    }

    public ContextElement getActiveContext() {
        return this.activeContext;
    }

    public String getActiveContextName() {
        if (this.activeContext == null) {
            return null;
        }
        return this.activeContext.getName();
    }

    public void deleteContext(String string) {
        ContextElement contextElement = this.availableContextElements.get(string);
        this.availableContextElements.remove(contextElement.getName());
        contextElement.delete();
        if (this.myPanel != null) {
            this.myPanel.updateContextElementsList();
        }
    }

    public void addContext(String string) {
        if (this.availableContextElements.containsKey(string)) {
            return;
        }
        ContextElement contextElement = new ContextElement(this.contextDirectory + "/" + string);
        this.availableContextElements.put(string, contextElement);
        if (this.myPanel != null) {
            this.myPanel.updateContextElementsList();
        }
    }

    public void loadActiveContext() {
        RDFScape.resetModulesBeforeChangeOfContext();
        System.out.println("Going to load (default) context: " + this.activeContext.getName());
        Iterator<Contextualizable> iterator = this.modulesHandled.iterator();
        while (iterator.hasNext()) {
            System.out.println(".");
            Contextualizable contextualizable = iterator.next();
            contextualizable.loadFromActiveContext();
        }
        RDFScape.activeContextChanged();
    }

    @Override
    public boolean canOperate() {
        return true;
    }

    public AbstractModulePanel getContextManagerPanel() {
        if (this.myPanel == null) {
            this.myPanel = new ContextManagerPanel(this);
        }
        return this.myPanel;
    }

    @Override
    public void touch() {
    }

    public void setActiveContext(String string) {
        this.activeContext = this.availableContextElements.get(string);
    }

    public void saveActiveContext() {
        System.out.println("Going to save (default) context: " + this.activeContext.getName());
        Iterator<Contextualizable> iterator = this.modulesHandled.iterator();
        while (iterator.hasNext()) {
            System.out.println(".");
            Contextualizable contextualizable = iterator.next();
            contextualizable.saveToContext();
        }
    }
}

