/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.query;

import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.MyQueryEngine;
import fr.pasteur.sysbio.rdfscape.query.SPQRLQueryAnswerer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class SPQRLQueryEngine
extends MyQueryEngine {
    private SPQRLQueryAnswerer myKnowledge = null;
    private SPQRLQueryPanel myPanel = null;
    private String query = null;

    public SPQRLQueryEngine() throws Exception {
        try {
            this.myKnowledge = (SPQRLQueryAnswerer)((Object)RDFScape.getKnowledge());
        }
        catch (Exception exception) {
            throw new Exception("SPARQL query not supported by this KnowledgeWrapper");
        }
        this.query = this.getDefaultQuery();
    }

    @Override
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = new SPQRLQueryPanel(this);
        }
        return this.myPanel;
    }

    @Override
    public void setQuery(String string) {
        this.query = string;
        if (this.myPanel != null) {
            this.myPanel.refresh();
        }
    }

    @Override
    public AbstractQueryResultTable makeQuery() {
        System.out.println("Querying my knowledge...");
        if (this.myPanel != null) {
            this.query = this.myPanel.getQueryText();
        }
        return this.myKnowledge.makeSPAQRLQuery(this.query);
    }

    @Override
    public String getLabel() {
        return "SPQRLQuery";
    }

    @Override
    public void reset() {
        this.query = this.getDefaultQuery();
        if (this.myPanel != null) {
            this.myPanel.refresh();
        }
    }

    public String getDefaultQuery() {
        String string = new String();
        string = string.concat(this.getQueryNameSpacesClause());
        string = string.concat("SELECT \n WHERE {     } \n");
        return string;
    }

    public String getQueryNameSpacesClause() {
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        String string = new String();
        ArrayList arrayList = commonMemory.getNamespacesList();
        if (arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (commonMemory.getNamespacePrefix(string2) == null) continue;
                string = string.concat("PREFIX \t" + commonMemory.getNamespacePrefix(string2) + ":");
                string = string.concat("\t <" + string2 + ">\n");
            }
            string = string + "\n";
        }
        return string;
    }

    private class SPQRLQueryPanel
    extends JPanel {
        private SPQRLQueryEngine spqrlQueryManager = null;
        private JTextArea spqrlQueryTextArea = null;

        public SPQRLQueryPanel(SPQRLQueryEngine sPQRLQueryEngine2) {
            this.spqrlQueryManager = sPQRLQueryEngine2;
            this.setBorder(new TitledBorder("SPQRL query"));
            this.setLayout(new BorderLayout());
            this.spqrlQueryTextArea = new JTextArea(this.spqrlQueryManager.query, 8, 60);
            this.add((Component)this.spqrlQueryTextArea, "Center");
        }

        public String getQueryText() {
            return this.spqrlQueryTextArea.getText();
        }

        public void refresh() {
            this.spqrlQueryTextArea.setText(this.spqrlQueryManager.query);
        }
    }
}

