/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.browsing;

import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.browsing.BrowserOptionPanel;
import fr.pasteur.sysbio.rdfscape.browsing.BrowserPanel;
import fr.pasteur.sysbio.rdfscape.cytoscape.CytoscapeDealer;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.GraphQueryAnswerer;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;

public class BrowserManager
implements Contextualizable {
    BrowserPanel myPanel = null;
    BrowserOptionPanel myOptionPanel = null;
    boolean useLabels = false;
    private String splitQuery;

    public BrowserManager() throws Exception {
        System.out.print("\tBrowserManager... ");
        if (RDFScape.getCommonMemory() == null) {
            throw new Exception("Cannot build BrowserMnager : no common Memory");
        }
        if (RDFScape.getContextManager() == null) {
            throw new Exception("Cannot build BrowserMnager : no context Manager");
        }
        RDFScape.getCommonMemory().setNamespaceConditionInAnd(false);
        RDFScape.getCommonMemory().setCollapseAttributes(false);
        RDFScape.getContextManager().addContextualizableElement(this);
        this.splitQuery = new String();
        System.out.println("Ok");
    }

    public BrowserPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = new BrowserPanel(this);
        }
        return this.myPanel;
    }

    public BrowserOptionPanel getOptionPanel() {
        this.myOptionPanel = new BrowserOptionPanel(this);
        this.myOptionPanel.refreshAfterKnowledgeChange();
        return this.myOptionPanel;
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void makeNewCytoscapePanel(String string) {
        if (string.equals("RDQL") || string.equals("RDF")) {
            string = "RDF";
        }
        RDFScape.getCytoscapeDealer().makeNewPanel(string);
    }

    public void plotNodesOnly(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("Dealin with: " + stringArray[i]);
        }
    }

    public String makeRDFQuery(String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = "SELECT ?x \n WHERE ";
        if (!bl && bl2) {
            string2.concat("text ");
        }
        return null;
    }

    public String[] getClassesList() {
        System.out.println("getClasses");
        if (RDFScape.getKnowledgeEngine() == null) {
            System.out.println("Null knowledge");
            return new String[]{""};
        }
        System.out.println("...");
        return null;
    }

    public void setEditable() {
        RDFScape.getCytoscapeDealer().setEditable();
    }

    public void getSnapshot(String string) {
        System.out.println("Pattern!!!");
        RDFScape.getPatternManager().getSnapshot(string);
    }

    public void setKnowledge(KnowledgeWrapper knowledgeWrapper) {
        if (this.myPanel != null) {
            this.myPanel.refreshAfterEngineChange();
        }
    }

    public ArrayList getAvailableQueryElements() {
        if (RDFScape.getKnowledgeEngine() == null) {
            return new ArrayList();
        }
        return RDFScape.getKnowledgeEngine().getAvailableQueryManagers();
    }

    public void plotValuesInResultTable(AbstractQueryResultTable abstractQueryResultTable) {
        Object object;
        int n;
        System.out.println("Plotting a " + abstractQueryResultTable.getRowCount() + " x " + abstractQueryResultTable.getColumnCount() + " matrix");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            for (n = 0; n < abstractQueryResultTable.getColumnCount(); ++n) {
                object = new int[]{i, n};
                System.out.println(i + "," + n + ": isURI :" + abstractQueryResultTable.isURI(i, n));
                if (!abstractQueryResultTable.isURI(i, n)) continue;
                arrayList.add(object);
            }
        }
        int[][] nArray = new int[arrayList.size()][2];
        n = 0;
        object = arrayList.iterator();
        while (object.hasNext()) {
            int[] nArray2 = (int[])object.next();
            nArray[n][0] = nArray2[0];
            nArray[n][1] = nArray2[1];
            ++n;
        }
        RDFScape.getCytoscapeDealer().addSelectedSetOfNodes(abstractQueryResultTable, nArray);
    }

    public void searchValuesInResultTable(AbstractQueryResultTable abstractQueryResultTable) {
        CytoscapeDealer cytoscapeDealer = RDFScape.getCytoscapeDealer();
        if (!cytoscapeDealer.hasGraph()) {
            RDFScape.warn("No graph to search into");
            return;
        }
        System.out.println("Searching a " + abstractQueryResultTable.getRowCount() + " x " + abstractQueryResultTable.getColumnCount() + " matrix");
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
            for (int j = 0; j < abstractQueryResultTable.getColumnCount(); ++j) {
                if (!abstractQueryResultTable.isURI(i, j)) continue;
                cytoscapeDealer.searchURIs(abstractQueryResultTable);
            }
        }
    }

    public boolean isNamespaceSelectionInAnd() {
        return RDFScape.getCommonMemory().isNamespaceConditionInAnd();
    }

    public boolean isCollapseAttributesTrue() {
        return RDFScape.getCommonMemory().isCollapseAttributesTrue();
    }

    public void setNamespaceSelectionInAnd(boolean bl) {
        RDFScape.getCommonMemory().setNamespaceConditionInAnd(bl);
    }

    public void setCollapseAttributes(boolean bl) {
        RDFScape.getCommonMemory().setCollapseAttributes(bl);
    }

    public boolean canCollapseDatatypes() {
        return RDFScape.getCytoscapeDealer().canCollapseDatatypes();
    }

    public boolean canExtend() {
        return RDFScape.getCytoscapeDealer().canExtend();
    }

    public void setPropagateURI(boolean bl) {
        RDFScape.getCommonMemory().setPropagateURI(true);
    }

    public boolean canHandleLabels() {
        return KnowledgeWrapper.hasGraphAccessSupport(RDFScape.getKnowledgeEngine());
    }

    public void setUseLabels(boolean bl) {
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        CytoscapeDealer cytoscapeDealer = RDFScape.getCytoscapeDealer();
        KnowledgeWrapper knowledgeWrapper = RDFScape.getKnowledgeEngine();
        if (!this.canHandleLabels()) {
            return;
        }
        if (bl != commonMemory.showRDFSLabels) {
            System.out.println("Updating labels!");
            commonMemory.showRDFSLabels = bl;
            if (commonMemory.showRDFSLabels) {
                System.out.println("-> to rdfs");
                String[] stringArray = commonMemory.getURIs();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = ((GraphQueryAnswerer)((Object)knowledgeWrapper)).getRDFLabelForURI(stringArray[i]);
                    if (string != null) {
                        commonMemory.registerURILabel(stringArray[i], string);
                    }
                    cytoscapeDealer.updateURILabel(stringArray[i]);
                }
            } else {
                String[] stringArray = commonMemory.getURIs();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = ((GraphQueryAnswerer)((Object)knowledgeWrapper)).getShortLabelForURI(stringArray[i]);
                    if (string != null) {
                        commonMemory.registerURILabel(stringArray[i], string);
                    }
                    cytoscapeDealer.updateURILabel(stringArray[i]);
                    System.out.println("-> to short");
                }
            }
            cytoscapeDealer.updateView();
        }
    }

    public boolean canHandleSplit() {
        return KnowledgeWrapper.hasRDQLSupport(RDFScape.getKnowledgeEngine());
    }

    public void setEnableSplit(boolean bl) {
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        if (commonMemory.splitEnabled != bl) {
            commonMemory.splitEnabled = bl;
            if (commonMemory.splitEnabled) {
                if (this.splitQuery.length() < 1) {
                    return;
                }
                RDFScape.getCytoscapeDealer().restoreSplitConditions();
                String string = this.splitQuery;
                while (string.indexOf("OR CONDITION") > 0) {
                    int n = string.indexOf("OR CONDITION");
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 12, string.length());
                    System.out.println("Query: " + string2);
                    AbstractQueryResultTable abstractQueryResultTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).makeRDQLQuery(string2);
                    string = string3;
                    RDFScape.getCytoscapeDealer().addSplitConditions(abstractQueryResultTable);
                }
                System.out.println("Query: " + string);
                AbstractQueryResultTable abstractQueryResultTable = ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).makeRDQLQuery(string);
                RDFScape.getCytoscapeDealer().addSplitConditions(abstractQueryResultTable);
            }
        }
    }

    public void setSplitConditions(String string) {
        this.splitQuery = string;
    }

    @Override
    public boolean loadFromActiveContext() {
        this.splitQuery = new String();
        System.out.print("Saving split query ");
        String string = RDFScape.getContextManager().getActiveContext().getSplitConditionsFileName();
        File file = new File(string);
        try {
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    this.splitQuery = this.splitQuery.concat(string2 + "\n");
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            if (this.myOptionPanel != null) {
                this.myOptionPanel.setSplitConditions(this.splitQuery);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to load split conditions");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean saveToContext() {
        System.out.print("Saving split query ");
        String string = RDFScape.getContextManager().getActiveContext().getSplitConditionsFileName();
        File file = new File(string);
        try {
            file.createNewFile();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.splitQuery);
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to read split conditions");
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

