/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.computing;

import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.computing.CompNode;
import fr.pasteur.sysbio.rdfscape.computing.CompValueNode;
import fr.pasteur.sysbio.rdfscape.computing.PatternEvaluatedTable;
import fr.pasteur.sysbio.rdfscape.computing.PatternNode;
import fr.pasteur.sysbio.rdfscape.computing.builtinfunctions.FunctionManager;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;

public class EvaluationNode
implements CompNode {
    String name = null;
    PatternNode patternNode = null;
    CompNode expressionNode = null;
    boolean hasErrors = false;
    String errorString;
    FunctionManager myFunctionManager = null;
    String[] bitePattern;
    String[][] otherPatterns;
    ArrayList otherPatternsTemp = new ArrayList();
    Hashtable biteToPatternHash = null;
    PatternEvaluatedTable myOutputTable;
    boolean patternIndependentEvaluationResult = false;
    boolean randomIndependentEvaluationResult = false;
    int optAction = 0;
    int optStep = 0;

    @Override
    public String dump() {
        if (this.patternNode != null && this.expressionNode != null) {
            return "Eval(" + this.patternNode.dump() + ")=" + this.expressionNode.dump();
        }
        return "";
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPatternNode(PatternNode patternNode) {
        this.patternNode = patternNode;
    }

    public void setExpressionNode(CompNode compNode) {
        this.expressionNode = compNode;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean bl) {
        this.hasErrors = bl;
    }

    public void setErrorString(String string) {
        this.errorString = string;
    }

    public String getGlobalErrorString() {
        return this.errorString;
    }

    public boolean setupPatternIndependentEvaluation() {
        if (this.patternNode == null || this.expressionNode == null) {
            System.out.println("There is not a valid function to evaluate");
            this.hasErrors = true;
            return false;
        }
        System.out.println("Begin pattern setup");
        this.bitePattern = this.patternNode.getPatternVariablesArray();
        System.out.print("Byte pattern: ");
        this.dumpStringArray(this.bitePattern);
        this.collectPatterns(this.otherPatternsTemp);
        this.otherPatterns = new String[this.otherPatternsTemp.size()][];
        int n = 0;
        for (String[] stringArray : this.otherPatternsTemp) {
            this.otherPatterns[n] = stringArray;
            System.out.println("Pattern #" + n);
            this.dumpStringArray(stringArray);
            ++n;
        }
        this.patternIndependentEvaluationResult = true;
        return true;
    }

    public void optimizeTree() {
        System.out.println("Ostart");
        if (this.hasErrors) {
            System.out.println("Can't optimize... ");
            return;
        }
        int n = this.optAction;
        this.expressionNode.optimizeTree(this, null);
        ++this.optStep;
        System.out.println("----1------OPT------1----");
        this.expressionNode.dump();
        while (this.optAction > n) {
            n = this.optAction;
            this.expressionNode.optimizeTree(this, null);
            ++this.optStep;
            System.out.println("-----------OPT------------");
            this.expressionNode.dump();
        }
        System.out.println("Optimization ended after " + this.optStep + " iteractions (" + this.optAction + " actions)");
    }

    @Override
    public CompNode optimizeTree(EvaluationNode evaluationNode, CompNode compNode) {
        return this;
    }

    @Override
    public boolean collectPatterns(ArrayList arrayList) {
        System.out.println("Pattern Collection Begin");
        this.expressionNode.collectPatterns(arrayList);
        System.out.println("Pattern Collection End");
        return true;
    }

    public void setPatternMatches(AbstractQueryResultTable abstractQueryResultTable) {
        int n;
        int n2;
        AbstractCollection[] abstractCollectionArray;
        int n3;
        int n4;
        if (!this.patternIndependentEvaluationResult) {
            return;
        }
        this.myOutputTable = new PatternEvaluatedTable(abstractQueryResultTable.getRowCount());
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        System.out.println("Establishing correspondence between variable and indexes in table");
        for (int i = 0; i < abstractQueryResultTable.getColumnCount(); ++i) {
            hashtable.put("?" + abstractQueryResultTable.getColumnName(i), new Integer(i));
            System.out.println("index :" + abstractQueryResultTable.getColumnName(i) + "->" + i);
        }
        int[] nArray = new int[this.bitePattern.length];
        System.out.println("Looking for pattern bite variables...");
        for (int i = 0; i < this.bitePattern.length; ++i) {
            System.out.print(this.bitePattern[i] + " ");
            if (!hashtable.containsKey(this.bitePattern[i])) {
                System.out.println("UNKNOWN");
                this.hasErrors = true;
                return;
            }
            System.out.println("OK (" + (Integer)hashtable.get(this.bitePattern[i]) + ")");
            nArray[i] = (Integer)hashtable.get(this.bitePattern[i]);
        }
        int[][] nArrayArray = new int[this.otherPatterns.length][];
        System.out.println("Looking for other variables...");
        for (n4 = 0; n4 < this.otherPatterns.length; ++n4) {
            nArrayArray[n4] = new int[this.otherPatterns[n4].length];
            for (int i = 0; i < this.otherPatterns[n4].length; ++i) {
                System.out.print(this.otherPatterns[n4][i] + " ");
                if (!hashtable.containsKey(this.otherPatterns[n4][i])) {
                    System.out.println("UNKNOWN");
                    this.hasErrors = true;
                    return;
                }
                System.out.println("OK (" + (Integer)hashtable.get(this.otherPatterns[n4][i]) + ")");
                nArrayArray[n4][i] = (Integer)hashtable.get(this.otherPatterns[n4][i]);
            }
        }
        System.out.println("indexes and indexes and indexes setup....");
        this.biteToPatternHash = new Hashtable();
        n4 = 0;
        Hashtable<Object, AbstractCollection[]> hashtable2 = new Hashtable<Object, AbstractCollection[]>();
        for (n3 = 0; n3 < abstractQueryResultTable.getRowCount(); ++n3) {
            System.out.println("Starting table analysis for row: " + n3);
            Object object = new String();
            for (int i = 0; i < nArray.length; ++i) {
                object = ((String)object).concat(abstractQueryResultTable.getURI(n3, nArray[i]));
            }
            System.out.println("Bite: " + object);
            if (this.biteToPatternHash.get(object) == null) {
                System.out.println("First time for Bite: " + (String)object);
                ++n4;
                ArrayList[] arrayListArray = new ArrayList[this.otherPatterns.length];
                abstractCollectionArray = new HashSet[this.otherPatterns.length];
                for (n2 = 0; n2 < this.otherPatterns.length; ++n2) {
                    arrayListArray[n2] = new ArrayList();
                    abstractCollectionArray[n2] = new HashSet();
                }
                this.biteToPatternHash.put(object, arrayListArray);
                hashtable2.put(object, abstractCollectionArray);
            }
            ArrayList[] arrayListArray = (ArrayList[])this.biteToPatternHash.get(object);
            abstractCollectionArray = (HashSet[])hashtable2.get(object);
            System.out.println("Recovering " + (String)object);
            for (n2 = 0; n2 < arrayListArray.length; ++n2) {
                String[] stringArray = new String[this.otherPatterns[n2].length];
                Object object2 = new String();
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = abstractQueryResultTable.getURI(n3, nArrayArray[n2][n]);
                    object2 = object2.concat(stringArray[n]);
                }
                System.out.print("Considering pattern: ");
                this.dumpStringArray(stringArray);
                System.out.println("with bite: " + (String)object2);
                if (!((HashSet)abstractCollectionArray[n2]).contains(object2)) {
                    ((HashSet)abstractCollectionArray[n2]).add(object2);
                    arrayListArray[n2].add(stringArray);
                    System.out.println("new");
                    continue;
                }
                System.out.println("Duplicated");
            }
            abstractQueryResultTable.setBite((String)object, n3);
        }
        this.myOutputTable = new PatternEvaluatedTable(this.biteToPatternHash.keySet().size());
        n3 = 0;
        for (ArrayList[] arrayListArray : this.biteToPatternHash.keySet()) {
            this.myOutputTable.setValueAt(arrayListArray, n3, 0);
            ++n3;
        }
        for (ArrayList[] arrayListArray : this.biteToPatternHash.keySet()) {
            System.out.println("Bite: " + (String)arrayListArray);
            abstractCollectionArray = (ArrayList[])this.biteToPatternHash.get(arrayListArray);
            for (n2 = 0; n2 < abstractCollectionArray.length; ++n2) {
                System.out.println("   Pattern: #" + n2);
                for (Object object2 : abstractCollectionArray[n2]) {
                    for (n = 0; n < ((String[])object2).length; ++n) {
                        System.out.println("     " + object2[n]);
                    }
                }
            }
        }
    }

    public PatternEvaluatedTable getDataResultTable() {
        return this.myOutputTable;
    }

    public boolean computeValues(int n, String string) {
        if (this.hasErrors) {
            return false;
        }
        this.myFunctionManager = new FunctionManager();
        System.out.println("Going to compute " + this.myOutputTable.getRowCount() * n + 1 + " trees");
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setBorder(new TitledBorder("Computing"));
        jProgressBar.setStringPainted(true);
        jProgressBar.setMinimum(0);
        jProgressBar.setMaximum(this.myOutputTable.getRowCount() * n + 1);
        JOptionPane.showMessageDialog(null, jProgressBar);
        int n2 = 0;
        for (int i = 0; i < this.myOutputTable.getRowCount(); ++i) {
            String string2 = (String)this.myOutputTable.getValueAt(i, 0);
            System.out.println("Eval: " + string2);
            Hashtable hashtable = RDFScape.getCytoMapper().getGenesMapping();
            Hashtable hashtable2 = RDFScape.getCytoMapper().getConditionMappings();
            double[][] dArray = RDFScape.getCytoMapper().getDataMatrix();
            if (((CompValueNode)((Object)this.expressionNode)).computePartial(this, hashtable, hashtable2, (ArrayList[])this.biteToPatternHash.get(string2))) {
                double d = ((CompValueNode)((Object)this.expressionNode)).computeTotal(dArray);
                System.out.println("===" + d);
                this.myOutputTable.setValueAt(new Double(d), i, 1);
            }
            jProgressBar.setValue(++n2);
        }
        return true;
    }

    private void dumpStringArray(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.print(stringArray[i] + " ");
        }
        System.out.println();
    }
}

